/*
 * Decompiled with CFR 0.152.
 */
package de.sakurajin.sakuralib.internal.ui;

import de.sakurajin.sakuralib.SakuraLib;
import de.sakurajin.sakuralib.util.v1.VersionHelper;
import de.sakurajin.sakuralib.versionTracker.v1.ModVersionTracker;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.Version;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2561;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_528;
import org.jetbrains.annotations.NotNull;

public class modUpdateScreen
extends BaseOwoScreen<FlowLayout> {
    private final class_528.class_4272 worldEntry;
    private boolean allowJoining = false;
    private HashMap<String, class_3545<class_3545<Version, Version>, class_3545<Integer, Integer>>> updateInfo = new HashMap();

    public modUpdateScreen(class_528.class_4272 parent) {
        super((class_2561)class_2561.method_43471((String)"text.sakuralib.updatetracker.title"));
        this.worldEntry = parent;
        this.loadData();
    }

    private void loadData() {
        Path saveDataDir = FabricLoader.getInstance().getGameDir().resolve("saves").resolve(this.worldEntry.field_19138.method_248()).resolve("data");
        File modDataFile = saveDataDir.resolve("sakuralib.nbt").toFile();
        if (!modDataFile.exists()) {
            this.allowJoining = true;
            return;
        }
        try {
            String nbtString = Files.readString(modDataFile.toPath());
            class_2487 nbtData = class_2512.method_32260((String)nbtString);
            ModVersionTracker modVersionData = ModVersionTracker.createFromNbt(nbtData);
            this.updateInfo = ModVersionTracker.getDifference(modVersionData);
            this.allowJoining = this.checkIfDiffAllowsJoin();
        }
        catch (Exception e) {
            this.allowJoining = true;
        }
    }

    private boolean checkIfDiffAllowsJoin() {
        if (!SakuraLib.CONFIG.ENABLE_WARNING_SCREEN()) {
            return true;
        }
        for (Map.Entry<String, class_3545<class_3545<Version, Version>, class_3545<Integer, Integer>>> entry : this.updateInfo.entrySet()) {
            int newFormat;
            int oldFormat = (Integer)((class_3545)entry.getValue().method_15441()).method_15442();
            if (oldFormat > (newFormat = ((Integer)((class_3545)entry.getValue().method_15441()).method_15441()).intValue())) {
                return false;
            }
            if (SakuraLib.CONFIG.WARN_ON_FORMAT_VERSION_UPDATE() && newFormat > oldFormat) {
                return false;
            }
            try {
                Version oldVersion = (Version)((class_3545)entry.getValue().method_15442()).method_15442();
                Version newVersion = (Version)((class_3545)entry.getValue().method_15442()).method_15441();
                if (newVersion == null) {
                    return false;
                }
                int majorComapre = VersionHelper.compareMajor(oldVersion, newVersion);
                if (majorComapre < 0) {
                    return false;
                }
                if (SakuraLib.CONFIG.WARN_ON_MAJOR_VERSION_UPDATE() && majorComapre > 0) {
                    return false;
                }
                int allComapre = oldVersion.compareTo((Object)newVersion);
                if (allComapre < 0) {
                    return false;
                }
                if (!SakuraLib.CONFIG.WARN_ON_MINOR_VERSION_UPDATE() || allComapre <= 0) continue;
                return false;
            }
            catch (Exception ignored) {
                return false;
            }
        }
        return true;
    }

    public void saveData() {
        if (!this.allowJoining) {
            return;
        }
        Path saveDataDir = FabricLoader.getInstance().getGameDir().resolve("saves").resolve(this.worldEntry.field_19138.method_248()).resolve("data");
        File modDataFile = saveDataDir.resolve("sakuralib.nbt").toFile();
        try {
            class_2487 nbtData = ModVersionTracker.INSTANCE.toNbt();
            Files.writeString(modDataFile.toPath(), (CharSequence)class_2512.method_32271((class_2487)nbtData), new OpenOption[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean canJoin() {
        return this.allowJoining;
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.surface(Surface.OPTIONS_BACKGROUND).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        FlowLayout updateInfoContainer = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)75), (Sizing)Sizing.content()).surface(Surface.BLANK).verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER).padding(Insets.of((int)5));
        updateInfoContainer.child((Component)Components.label((class_2561)class_2561.method_43471((String)"text.sakuralib.updatetracker.warning_main"))).child((Component)Components.label((class_2561)class_2561.method_43471((String)"text.sakuralib.updateTracker.updates_title")));
        for (Map.Entry<String, class_3545<class_3545<Version, Version>, class_3545<Integer, Integer>>> entry : this.updateInfo.entrySet()) {
            int versionCompare;
            String modName = entry.getKey();
            Version oldVersion = (Version)((class_3545)entry.getValue().method_15442()).method_15442();
            Version newVersion = (Version)((class_3545)entry.getValue().method_15442()).method_15441();
            int oldFormat = (Integer)((class_3545)entry.getValue().method_15441()).method_15442();
            int newFormat = (Integer)((class_3545)entry.getValue().method_15441()).method_15441();
            if (newVersion == null) {
                updateInfoContainer.child((Component)Components.label((class_2561)class_2561.method_43469((String)"text.sakuralib.updateTracker.mod_removed", (Object[])new Object[]{modName})));
                continue;
            }
            if (oldFormat != newFormat) {
                updateInfoContainer.child((Component)Components.label((class_2561)class_2561.method_43469((String)"text.sakuralib.updateTracker.mod_format_version_change", (Object[])new Object[]{modName, oldFormat, newFormat})));
            }
            if ((versionCompare = oldVersion.compareTo((Object)newVersion)) > 0) {
                updateInfoContainer.child((Component)Components.label((class_2561)class_2561.method_43469((String)"text.sakuralib.updateTracker.mod_version_downgraded", (Object[])new Object[]{modName, oldVersion.getFriendlyString(), newVersion.getFriendlyString()})));
                continue;
            }
            if (versionCompare >= 0) continue;
            updateInfoContainer.child((Component)Components.label((class_2561)class_2561.method_43469((String)"text.sakuralib.updateTracker.mod_version_updated", (Object[])new Object[]{modName, oldVersion.getFriendlyString(), newVersion.getFriendlyString()})));
        }
        rootComponent.child((Component)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((Component)Containers.verticalScroll((Sizing)Sizing.content((int)10), (Sizing)Sizing.fill((int)60), (Component)updateInfoContainer)).padding(Insets.of((int)5)).surface(Surface.BLANK).verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER));
        rootComponent.child((Component)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(Components.button((class_2561)class_2561.method_43471((String)"text.sakuralib.updateTracker.button.ignore_warning"), button -> {
            assert (this.field_22787 != null);
            this.allowJoining = true;
            this.saveData();
            this.worldEntry.method_20174();
        }).tooltip((class_2561)class_2561.method_43471((String)"text.sakuralib.updateTracker.button.ignore_warning.tooltip")).margins(Insets.of((int)10)).sizing(Sizing.fill((int)25), Sizing.fixed((int)20))).child(Components.button((class_2561)class_2561.method_43471((String)"text.sakuralib.updateTracker.button.back_to_menu"), button -> {
            assert (this.field_22787 != null);
            this.field_22787.method_1507((class_437)this.worldEntry.field_19137);
        }).tooltip((class_2561)class_2561.method_43471((String)"text.sakuralib.updateTracker.button.back_to_menu.tooltip")).margins(Insets.of((int)10)).sizing(Sizing.fill((int)25), Sizing.fixed((int)20))).padding(Insets.of((int)5)).surface(Surface.BLANK).verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER));
    }
}

