/*
 * Decompiled with CFR 0.152.
 */
package de.sakurajin.sakuralib.datagen.v2.patchouli;

import de.sakurajin.sakuralib.SakuraLib;
import de.sakurajin.sakuralib.arrp.v2.patchouli.JPatchouliCategory;
import de.sakurajin.sakuralib.datagen.v2.patchouli.DynamicPatchouliCategoryContainer;
import de.sakurajin.sakuralib.util.v1.NameIDPair;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.class_2960;

public class PatchouliDataManager {
    private static final HashMap<String, DynamicPatchouliCategoryContainer> DYNAMIC_MOD_CATEGORIES = new HashMap();
    public static final NameIDPair SAKURALIB_BOOK = new NameIDPair("sakuralib_dynamic_book", SakuraLib.DATAGEN_CONTAINER);
    public static final DynamicPatchouliCategoryContainer MINECRAFT_CATEGORY = PatchouliDataManager.getOrCreateDynamicCategory("minecraft", JPatchouliCategory.create("sakuralib_dynamic_book.minecraft.name", "sakuralib_dynamic_book.minecraft.maintext", "minecraft:grass_block"));

    public static class_2960 getCategoryPath(String categoryName) {
        return new class_2960("sakuralib", "patchouli_books/" + SAKURALIB_BOOK.name() + "/en_us/categories/" + categoryName + ".json");
    }

    public static class_2960 getEntryPath(String categoryName, String entryName) {
        return PatchouliDataManager.getEntryPath(categoryName, entryName, "en_us");
    }

    public static class_2960 getEntryPath(String categoryName, String entryName, String locale) {
        return new class_2960("sakuralib", "patchouli_books/" + SAKURALIB_BOOK.name() + "/" + locale + "/entries/" + categoryName + "/" + entryName + ".json");
    }

    public static Optional<DynamicPatchouliCategoryContainer> getDynamicCategory(String modID) {
        DynamicPatchouliCategoryContainer category = DYNAMIC_MOD_CATEGORIES.get(modID);
        if (category == null) {
            return Optional.empty();
        }
        return Optional.of(category);
    }

    public static DynamicPatchouliCategoryContainer getOrCreateDynamicCategory(String modID, JPatchouliCategory mainCategoryData) {
        if (DYNAMIC_MOD_CATEGORIES.containsKey(modID)) {
            return DYNAMIC_MOD_CATEGORIES.get(modID);
        }
        DynamicPatchouliCategoryContainer newCategory = new DynamicPatchouliCategoryContainer(modID, mainCategoryData);
        DYNAMIC_MOD_CATEGORIES.put(modID, newCategory);
        return newCategory;
    }

    public static void registerRRPData() {
        for (DynamicPatchouliCategoryContainer category : DYNAMIC_MOD_CATEGORIES.values()) {
            category.registerData();
        }
    }
}

