/*
 * Decompiled with CFR 0.152.
 */
package de.sakurajin.sakuralib.datagen.v2.patchouli;

import de.sakurajin.sakuralib.SakuraLib;
import de.sakurajin.sakuralib.arrp.v2.patchouli.JPatchouliCategory;
import de.sakurajin.sakuralib.arrp.v2.patchouli.JPatchouliEntry;
import de.sakurajin.sakuralib.datagen.v2.patchouli.PatchouliDataManager;
import de.sakurajin.sakuralib.util.v1.NameIDPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.minecraft.class_2960;

public class DynamicPatchouliCategoryContainer {
    public final boolean isSubCategory;
    public final NameIDPair mainCategoryName;
    public final NameIDPair categoryName;
    private final JPatchouliCategory categoryData;
    private final ArrayList<DynamicPatchouliCategoryContainer> subCategories = new ArrayList();
    private final HashMap<class_2960, JPatchouliEntry> addedEntries = new HashMap();

    public DynamicPatchouliCategoryContainer(String modID, JPatchouliCategory categoryData) {
        this.mainCategoryName = new NameIDPair(modID, "sakuralib");
        this.categoryData = categoryData;
        this.categoryName = this.mainCategoryName;
        this.isSubCategory = false;
    }

    private DynamicPatchouliCategoryContainer(NameIDPair mainCategoryName, String categoryName, JPatchouliCategory subCategoryData) {
        this.mainCategoryName = mainCategoryName;
        this.categoryData = subCategoryData;
        this.isSubCategory = true;
        this.categoryName = new NameIDPair(categoryName, "sakuralib");
    }

    public DynamicPatchouliCategoryContainer add(JPatchouliCategory categoryData, String categoryName) {
        categoryData.setParent(this.categoryName.IDString());
        DynamicPatchouliCategoryContainer subContainer = new DynamicPatchouliCategoryContainer(this.categoryName, categoryName, categoryData);
        this.subCategories.add(subContainer);
        return subContainer;
    }

    public DynamicPatchouliCategoryContainer add(JPatchouliCategory categoryData) {
        return this.add(categoryData, categoryData.getName());
    }

    public void add(String locale, JPatchouliEntry entry) {
        class_2960 location = PatchouliDataManager.getEntryPath(this.categoryName.name(), entry.getName(), locale);
        JPatchouliEntry correctedEntry = entry.copyWithCategory(this.categoryName.IDString());
        this.addedEntries.put(location, correctedEntry);
    }

    public void add(String locale, JPatchouliEntry ... entries) {
        for (JPatchouliEntry entry : entries) {
            this.add(locale, entry);
        }
    }

    public void add(JPatchouliEntry entry) {
        this.add("en_us", entry);
    }

    public void add(JPatchouliEntry ... entries) {
        this.add("en_us", entries);
    }

    public void registerData() {
        this.registerData(SakuraLib.DATAGEN_CONTAINER.RESOURCE_PACK);
    }

    protected void registerData(RuntimeResourcePack resourcePack) {
        for (Map.Entry<class_2960, JPatchouliEntry> entry : this.addedEntries.entrySet()) {
            resourcePack.addAsset(entry.getKey(), entry.getValue().toString().getBytes());
        }
        resourcePack.addAsset(PatchouliDataManager.getCategoryPath(this.categoryName.name()), this.categoryData.toString().getBytes());
        for (DynamicPatchouliCategoryContainer category : this.subCategories) {
            category.registerData(resourcePack);
        }
    }

    @Deprecated(since="0.5.2", forRemoval=true)
    public DynamicPatchouliCategoryContainer addCategory(JPatchouliCategory categoryData, String categoryName) {
        return this.add(categoryData, categoryName);
    }

    @Deprecated(since="0.5.2", forRemoval=true)
    public DynamicPatchouliCategoryContainer addCategory(JPatchouliCategory categoryData) {
        return this.add(categoryData, categoryData.getName());
    }

    @Deprecated(since="0.5.2", forRemoval=true)
    public void addPatchouliEntry(String locale, JPatchouliEntry entry) {
        this.add(locale, entry);
    }

    @Deprecated(since="0.5.2", forRemoval=true)
    public void addPatchouliEntries(String locale, JPatchouliEntry ... entries) {
        this.add(locale, entries);
    }

    @Deprecated(since="0.5.2", forRemoval=true)
    public void addPatchouliEntry(JPatchouliEntry entry) {
        this.add(entry);
    }

    @Deprecated(since="0.5.2", forRemoval=true)
    public void addPatchouliEntries(JPatchouliEntry ... entries) {
        this.add(entries);
    }
}

