/*
 * Decompiled with CFR 0.152.
 */
package de.sakurajin.sakuralib.datagen.v2;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sakurajin.sakuralib.SakuraLib;
import de.sakurajin.sakuralib.util.v1.SakuraJsonHelper;
import java.util.HashMap;
import java.util.Map;

public class DynamicOwOLangManager {
    private static final HashMap<String, JsonObject> langFiles = new HashMap();

    public static void declareLang(String lang) {
        if (!langFiles.containsKey(lang)) {
            langFiles.put(lang, new JsonObject());
        }
    }

    public static void addGlobalEntry(String key, JsonArray value) {
        DynamicOwOLangManager.addEntry("global", key, value);
    }

    public static void addEntry(String lang, String key, JsonArray value) {
        DynamicOwOLangManager.declareLang(lang);
        langFiles.get(lang).add(key, (JsonElement)value);
    }

    public static void updateRRP() {
        JsonObject globalData = langFiles.get("global");
        for (Map.Entry<String, JsonObject> entry : langFiles.entrySet()) {
            if (entry.getKey().equals("global")) continue;
            JsonObject mergedData = SakuraJsonHelper.merge(globalData, entry.getValue());
            SakuraLib.DATAGEN_CONTAINER.RESOURCE_PACK.addAsset(SakuraLib.DATAGEN_CONTAINER.getSimpleID(entry.getKey() + ".json", "lang"), SakuraJsonHelper.toPrettyBytes((JsonElement)mergedData));
        }
    }

    static {
        DynamicOwOLangManager.declareLang("en_us");
    }
}

