/*
 * Decompiled with CFR 0.152.
 */
package de.sakurajin.sakuralib.datagen.v1.Presets;

import de.sakurajin.sakuralib.datagen.v1.DatagenModContainer;
import de.sakurajin.sakuralib.datagen.v1.Presets.Blocks.CubeAll;
import de.sakurajin.sakuralib.datagen.v1.Presets.Blocks.CubeColumn;
import de.sakurajin.sakuralib.datagen.v1.Presets.Blocks.Door;
import de.sakurajin.sakuralib.datagen.v1.Presets.Blocks.Fence;
import de.sakurajin.sakuralib.datagen.v1.Presets.Blocks.FenceGate;
import de.sakurajin.sakuralib.datagen.v1.Presets.Blocks.Slab;
import de.sakurajin.sakuralib.datagen.v1.Presets.Blocks.Stairs;
import de.sakurajin.sakuralib.datagen.v1.Presets.Blocks.Trapdoor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.devtech.arrp.json.recipe.JIngredient;
import net.devtech.arrp.json.recipe.JIngredients;
import net.devtech.arrp.json.recipe.JRecipe;
import net.devtech.arrp.json.recipe.JResult;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.type.BlockSetTypeBuilder;
import net.fabricmc.fabric.api.object.builder.v1.block.type.WoodTypeBuilder;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_7923;
import net.minecraft.class_8177;

public class GeneratedWoodType {
    private final String name;
    private final String baseWoodType;
    private final String textureFolder;
    public final class_4719 woodType;
    public final class_8177 blockSetType;
    public final ArrayList<SettingsOverride> settingsOverrides = new ArrayList();
    private CubeColumn log = null;
    private CubeAll planks = null;
    private Slab slabs = null;
    private Stairs stairs = null;
    private Fence fence = null;
    private FenceGate fenceGate = null;
    private Door door = null;
    private Trapdoor trapdoor = null;

    public GeneratedWoodType(String name, class_8177 blockSetType, class_4719 woodType, String baseWoodType, ArrayList<SettingsOverride> settingsOverrides, DatagenModContainer container) {
        this.name = name;
        this.blockSetType = blockSetType;
        this.woodType = woodType;
        this.textureFolder = container.getStringID(name, "block");
        this.baseWoodType = baseWoodType;
        this.settingsOverrides.addAll(settingsOverrides);
    }

    private String getTextureName(String suffix) {
        return this.textureFolder + "/" + suffix;
    }

    private FabricBlockSettings getSettingsOf(String suffix, GenerationSettings settings) {
        FabricBlockSettings blockSettings = settings == null || settings.blockSettings == null ? FabricBlockSettings.copyOf((class_4970)((class_4970)class_7923.field_41175.method_10223(new class_2960(this.baseWoodType + "_" + suffix)))) : settings.blockSettings;
        blockSettings = blockSettings.sounds(this.woodType.comp_1301());
        for (SettingsOverride override : this.settingsOverrides) {
            blockSettings = override.override(blockSettings);
        }
        if (settings != null && settings.settingsOverrides != null) {
            for (SettingsOverride override : settings.settingsOverrides) {
                blockSettings = override.override(blockSettings);
            }
        }
        return blockSettings;
    }

    public CubeColumn getLog(final GenerationSettings genSettings) {
        if (this.log == null) {
            FabricBlockSettings blockSettings = this.getSettingsOf("log", genSettings);
            this.log = new CubeColumn(blockSettings, this.getTextureName("log_top"), this.getTextureName("log")){

                @Override
                public class_1935 generateData(DatagenModContainer container, String identifier) {
                    container.addTag("minecraft:blocks/mineable/axe", identifier);
                    container.addTag("minecraft:blocks/enderman_holdable", identifier);
                    container.addTag("minecraft:blocks/logs", identifier);
                    container.addTag("minecraft:blocks/logs_that_burn", identifier);
                    container.addTag("minecraft:items/logs", identifier);
                    container.addTag("minecraft:items/logs_that_burn", identifier);
                    container.addTag(GeneratedWoodType.this.name, identifier);
                    container.addTags(genSettings.extraTags);
                    class_1935 item = super.generateData(container, identifier);
                    if (genSettings.lootOptions != null) {
                        container.createBlockLootTable(identifier, genSettings.lootOptions);
                    }
                    return item;
                }
            };
        }
        return this.log;
    }

    public CubeAll getPlanks(final GenerationSettings genSettings) {
        if (this.planks == null) {
            FabricBlockSettings settings = this.getSettingsOf("planks", genSettings);
            this.planks = new CubeAll(settings, this.getTextureName("planks")){

                @Override
                public class_1935 generateData(DatagenModContainer container, String identifier) {
                    class_1935 item = super.generateData(container, identifier);
                    container.addTag("minecraft:blocks/mineable/axe", identifier);
                    container.addTag("minecraft:blocks/enderman_holdable", identifier);
                    container.addTag("minecraft:blocks/planks", identifier);
                    container.addTag("minecraft:items/planks", identifier);
                    container.addTag(GeneratedWoodType.this.name, identifier);
                    container.addTags(genSettings.extraTags);
                    container.RESOURCE_PACK.addRecipe(container.getSimpleID(identifier), (JRecipe)JRecipe.shapeless((JIngredients)JIngredients.ingredients().add(JIngredient.ingredient().item(container.getStringID(GeneratedWoodType.this.name + "_log"))), (JResult)JResult.result((String)container.getStringID(identifier))));
                    if (genSettings.lootOptions != null) {
                        container.createBlockLootTable(identifier, genSettings.lootOptions);
                    }
                    return item;
                }
            };
        }
        return this.planks;
    }

    public Slab getSlabs(final GenerationSettings genSettings) {
        if (this.slabs == null) {
            FabricBlockSettings settings = this.getSettingsOf("slab", genSettings);
            this.slabs = new Slab(settings, this.name + "_planks", false, new String[]{this.getTextureName("planks")}){

                @Override
                public class_1935 generateData(DatagenModContainer container, String identifier) {
                    class_1935 item = super.generateData(container, identifier);
                    container.addTag("minecraft:blocks/mineable/axe", identifier);
                    container.addTag("minecraft:blocks/wodden_slabs", identifier);
                    container.addTag("minecraft:items/wooden_slabs", identifier);
                    container.addTag(GeneratedWoodType.this.name, identifier);
                    container.addTags(genSettings.extraTags);
                    if (genSettings.lootOptions != null) {
                        container.createBlockLootTable(identifier, genSettings.lootOptions);
                    }
                    return item;
                }
            };
        }
        return this.slabs;
    }

    public Stairs getStairs(final GenerationSettings genSettings) {
        if (this.stairs == null) {
            if (this.planks == null) {
                throw new IllegalStateException("Stairs can only be generated after planks have been generated");
            }
            FabricBlockSettings settings = this.getSettingsOf("stairs", genSettings);
            this.stairs = new Stairs(settings, this.planks, this.name + "_planks", new String[]{this.getTextureName("planks")}, false){

                @Override
                public class_1935 generateData(DatagenModContainer container, String identifier) {
                    class_1935 item = super.generateData(container, identifier);
                    container.addTag("minecraft:blocks/mineable/axe", identifier);
                    container.addTag("minecraft:blocks/wodden_stairs", identifier);
                    container.addTag("minecraft:items/wooden_stairs", identifier);
                    container.addTag(GeneratedWoodType.this.name, identifier);
                    container.addTags(genSettings.extraTags);
                    if (genSettings.lootOptions != null) {
                        container.createBlockLootTable(identifier, genSettings.lootOptions);
                    }
                    return item;
                }
            };
        }
        return this.stairs;
    }

    public Fence getFence(final GenerationSettings genSettings) {
        if (this.fence == null) {
            if (this.planks == null) {
                throw new IllegalStateException("Fence can only be generated after planks have been generated");
            }
            FabricBlockSettings settings = this.getSettingsOf("fence", genSettings);
            this.fence = new Fence((class_4970.class_2251)settings, this.getTextureName("planks"), this.name + "_planks"){

                @Override
                public class_1935 generateData(DatagenModContainer container, String identifier) {
                    class_1935 item = super.generateData(container, identifier);
                    container.addTag("minecraft:blocks/mineable/axe", identifier);
                    container.addTag("minecraft:blocks/wodden_fences", identifier);
                    container.addTag("minecraft:items/wooden_fences", identifier);
                    container.addTag(GeneratedWoodType.this.name, identifier);
                    container.addTags(genSettings.extraTags);
                    if (genSettings.lootOptions != null) {
                        container.createBlockLootTable(identifier, genSettings.lootOptions);
                    }
                    return item;
                }
            };
        }
        return this.fence;
    }

    public FenceGate getFenceGate(final GenerationSettings genSettings) {
        if (this.fenceGate == null) {
            if (this.planks == null) {
                throw new IllegalStateException("FenceGate can only be generated after planks have been generated");
            }
            FabricBlockSettings settings = this.getSettingsOf("fence_gate", genSettings);
            this.fenceGate = new FenceGate((class_4970.class_2251)settings, this.woodType, this.getTextureName("planks"), this.name + "_planks"){

                @Override
                public class_1935 generateData(DatagenModContainer container, String identifier) {
                    class_1935 item = super.generateData(container, identifier);
                    container.addTag(GeneratedWoodType.this.name, identifier);
                    container.addTags(genSettings.extraTags);
                    if (genSettings.lootOptions != null) {
                        container.createBlockLootTable(identifier, genSettings.lootOptions);
                    }
                    return item;
                }
            };
        }
        return this.fenceGate;
    }

    public Door getDoor(final GenerationSettings genSettings) {
        if (this.door == null) {
            if (this.planks == null) {
                throw new IllegalStateException("Door can only be generated after planks have been generated");
            }
            FabricBlockSettings settings = this.getSettingsOf("door", genSettings);
            this.door = new Door((class_4970.class_2251)settings, this.blockSetType, this.getTextureName("door"), this.name + "_planks"){

                @Override
                public class_1935 generateData(DatagenModContainer container, String identifier) {
                    class_1935 item = super.generateData(container, identifier);
                    container.addTag("minecraft:blocks/mineable/axe", identifier);
                    container.addTag("minecraft:blocks/wodden_doors", identifier);
                    container.addTag("minecraft:items/wooden_doors", identifier);
                    container.addTag(GeneratedWoodType.this.name, identifier);
                    container.addTags(genSettings.extraTags);
                    if (genSettings.lootOptions != null) {
                        genSettings.lootOptions.conditionAdder = entry -> this.addExtraConditions(container, identifier, entry);
                        container.createBlockLootTable(identifier, genSettings.lootOptions);
                    }
                    return item;
                }
            };
        }
        return this.door;
    }

    public Trapdoor getTrapdoor(final GenerationSettings genSettings) {
        if (this.trapdoor == null) {
            if (this.planks == null) {
                throw new IllegalStateException("Trapdoor can only be generated after planks have been generated");
            }
            FabricBlockSettings settings = this.getSettingsOf("trapdoor", genSettings);
            this.trapdoor = new Trapdoor((class_4970.class_2251)settings, this.blockSetType, this.getTextureName("trapdoor"), this.name + "_planks"){

                @Override
                public class_1935 generateData(DatagenModContainer container, String identifier) {
                    class_1935 item = super.generateData(container, identifier);
                    container.addTag("minecraft:blocks/mineable/axe", identifier);
                    container.addTag("minecraft:blocks/wodden_trapdoors", identifier);
                    container.addTag("minecraft:items/wooden_trapdoors", identifier);
                    container.addTag(GeneratedWoodType.this.name, identifier);
                    container.addTags(genSettings.extraTags);
                    if (genSettings.lootOptions != null) {
                        container.createBlockLootTable(identifier, genSettings.lootOptions);
                    }
                    return item;
                }
            };
        }
        return this.trapdoor;
    }

    public static class GenerationSettings {
        public HashMap<String, ArrayList<String>> extraTags = new HashMap();
        public SettingsOverride[] settingsOverrides = null;
        public FabricBlockSettings blockSettings = null;
        public DatagenModContainer.BlockLootOptions lootOptions = null;

        public GenerationSettings addTags(String tag, String ... values) {
            if (!this.extraTags.containsKey(tag)) {
                this.extraTags.put(tag, new ArrayList());
            }
            this.extraTags.get(tag).addAll(Arrays.asList(values));
            return this;
        }

        public GenerationSettings SettingsOverrides(SettingsOverride ... settingsOverrides) {
            this.settingsOverrides = settingsOverrides;
            return this;
        }

        public GenerationSettings BlockSettings(FabricBlockSettings blockSettings) {
            this.blockSettings = blockSettings;
            return this;
        }

        public GenerationSettings setLootOptions(DatagenModContainer.BlockLootOptions lootOptions) {
            this.lootOptions = lootOptions;
            return this;
        }

        public GenerationSettings() {
        }

        public GenerationSettings(DatagenModContainer.BlockLootOptions lootOptions) {
            this.lootOptions = lootOptions;
        }

        public static GenerationSettings create() {
            return new GenerationSettings();
        }
    }

    @FunctionalInterface
    public static interface SettingsOverride {
        public FabricBlockSettings override(FabricBlockSettings var1);
    }

    public static class GeneratedWoodTypeBuilder {
        private final String name;
        private class_8177 baseBlockSetType = class_8177.field_42823;
        private class_4719 baseWoodType = class_4719.field_21676;
        private String baseWoodTypeString = "minecraft:oak";
        private final ArrayList<SettingsOverride> settingsOverrides = new ArrayList();

        private GeneratedWoodTypeBuilder(String name) {
            this.name = name;
        }

        public static GeneratedWoodTypeBuilder create(String name) {
            return new GeneratedWoodTypeBuilder(name);
        }

        public static GeneratedWoodTypeBuilder create(String name, class_8177 baseBlockSetType, class_4719 baseWoodType, String baseWoodTypeString) {
            return GeneratedWoodTypeBuilder.create(name).baseBlockSetType(baseBlockSetType).baseWoodType(baseWoodType).baseWoodTypeString(baseWoodTypeString);
        }

        public GeneratedWoodTypeBuilder baseBlockSetType(class_8177 baseBlockSetType) {
            this.baseBlockSetType = baseBlockSetType;
            return this;
        }

        public GeneratedWoodTypeBuilder baseWoodType(class_4719 baseWoodType) {
            this.baseWoodType = baseWoodType;
            return this;
        }

        public GeneratedWoodTypeBuilder baseWoodTypeString(String baseWoodTypeString) {
            this.baseWoodTypeString = baseWoodTypeString;
            return this;
        }

        public GeneratedWoodTypeBuilder addSettingsOverride(SettingsOverride settingsOverride) {
            this.settingsOverrides.add(settingsOverride);
            return this;
        }

        public GeneratedWoodTypeBuilder addSettingsOverrides(SettingsOverride ... settingsOverrides) {
            this.settingsOverrides.addAll(Arrays.asList(settingsOverrides));
            return this;
        }

        public GeneratedWoodType build(DatagenModContainer container) {
            class_8177 blockSetType = BlockSetTypeBuilder.copyOf((class_8177)this.baseBlockSetType).register(container.getSimpleID(this.name));
            class_4719 woodType = WoodTypeBuilder.copyOf((class_4719)this.baseWoodType).register(container.getSimpleID(this.name), blockSetType);
            return new GeneratedWoodType(this.name, blockSetType, woodType, this.baseWoodTypeString, this.settingsOverrides, container);
        }
    }
}

