/*
 * Decompiled with CFR 0.152.
 */
package de.sakurajin.sakuralib.datagen.v1.Presets.Blocks;

import de.sakurajin.sakuralib.datagen.v1.DataGenerateable;
import de.sakurajin.sakuralib.datagen.v1.DatagenModContainer;
import net.devtech.arrp.json.blockstate.JBlockModel;
import net.devtech.arrp.json.blockstate.JState;
import net.devtech.arrp.json.blockstate.JVariant;
import net.devtech.arrp.json.models.JModel;
import net.devtech.arrp.json.models.JTextures;
import net.devtech.arrp.json.recipe.JIngredient;
import net.devtech.arrp.json.recipe.JKeys;
import net.devtech.arrp.json.recipe.JPattern;
import net.devtech.arrp.json.recipe.JRecipe;
import net.devtech.arrp.json.recipe.JResult;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2533;
import net.minecraft.class_4970;
import net.minecraft.class_8177;

public class Trapdoor
extends class_2533
implements DataGenerateable {
    private final String plankName;
    private final String textureBaseName;

    public Trapdoor(class_4970.class_2251 settings, class_8177 blockSetType, String textureBaseName, String plankName) {
        super(settings, blockSetType);
        this.plankName = plankName;
        this.textureBaseName = textureBaseName;
    }

    public static void generateBlockModel(DatagenModContainer container, String identifier, String textureBaseName) {
        String[] parts;
        JTextures textures = JModel.textures().var("texture", container.getStringID(textureBaseName, "block"));
        for (String part : parts = new String[]{"bottom", "open", "top"}) {
            container.RESOURCE_PACK.addModel(JModel.model().parent("minecraft:block/template_trapdoor_" + part).textures(textures), container.getSimpleID("block/" + identifier + "_" + part));
        }
    }

    private static JBlockModel getModelName(String identifier, String direction, boolean isTop, boolean open) {
        if (!open) {
            return JState.model((String)(identifier + (isTop ? "_top" : "_bottom")));
        }
        return JState.model((String)(identifier + "_open")).y(switch (direction) {
            case "east" -> 90;
            case "south" -> 180;
            case "west" -> 270;
            case "north" -> 0;
            default -> throw new IllegalArgumentException("Invalid direction: " + direction);
        });
    }

    private static String getPropertyString(String direction, boolean isUpper, boolean open) {
        return "facing=" + direction + ",half=" + (isUpper ? "top" : "bottom") + ",open=" + open;
    }

    public static void generateBlockState(DatagenModContainer container, String identifier) {
        String[] directions = new String[]{"north", "south", "east", "west"};
        JVariant variant = JState.variant();
        String modelBaseId = container.getStringID(identifier, "block");
        for (String direction : directions) {
            variant.put(Trapdoor.getPropertyString(direction, false, false), Trapdoor.getModelName(modelBaseId, direction, false, false));
            variant.put(Trapdoor.getPropertyString(direction, false, true), Trapdoor.getModelName(modelBaseId, direction, false, true));
            variant.put(Trapdoor.getPropertyString(direction, true, false), Trapdoor.getModelName(modelBaseId, direction, true, false));
            variant.put(Trapdoor.getPropertyString(direction, true, true), Trapdoor.getModelName(modelBaseId, direction, true, true));
        }
        container.RESOURCE_PACK.addBlockState(JState.state((JVariant[])new JVariant[]{variant}), container.getSimpleID(identifier));
    }

    @Override
    public class_1935 generateData(DatagenModContainer container, String identifier) {
        Trapdoor.generateBlockModel(container, identifier, this.textureBaseName);
        Trapdoor.generateBlockState(container, identifier);
        container.createBlockLootTable(identifier, null);
        container.RESOURCE_PACK.addRecipe(container.getSimpleID(identifier), (JRecipe)JRecipe.shaped((JPattern)JPattern.pattern((String[])new String[]{"###", "###"}), (JKeys)JKeys.keys().key("#", JIngredient.ingredient().item(container.getStringID(this.plankName))), (JResult)JResult.stackedResult((String)container.getStringID(identifier), (int)2)));
        container.addTag("minecraft:blocks/trapdoors", identifier);
        container.addTag("minecraft:items/trapdoors", identifier);
        container.generateItemModel(identifier, container.getStringID(identifier + "_bottom", "block"));
        return container.generateBlockItem((class_2248)this, container.settings());
    }
}

