/*
 * Decompiled with CFR 0.152.
 */
package de.sakurajin.sakuralib.datagen.v1.Presets.Blocks;

import de.sakurajin.sakuralib.datagen.v1.DataGenerateable;
import de.sakurajin.sakuralib.datagen.v1.DatagenModContainer;
import java.util.Map;
import net.devtech.arrp.json.blockstate.JState;
import net.devtech.arrp.json.blockstate.JVariant;
import net.devtech.arrp.json.recipe.JIngredient;
import net.devtech.arrp.json.recipe.JKeys;
import net.devtech.arrp.json.recipe.JPattern;
import net.devtech.arrp.json.recipe.JRecipe;
import net.devtech.arrp.json.recipe.JResult;
import net.devtech.arrp.json.recipe.JStackedResult;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2482;
import net.minecraft.class_2960;
import net.minecraft.class_4970;

public class Slab
extends class_2482
implements DataGenerateable {
    private final String texture_bottom;
    private final String texture_top;
    private final String texture_side;
    private final String texture_double;
    private final String baseBlock;
    private final boolean stonecuttable;

    public Slab(FabricBlockSettings settings, String baseBlock, String[] textures) {
        this(settings, baseBlock, true, textures);
    }

    public Slab(FabricBlockSettings settings, String baseBlock, boolean stonecuttable, String[] textures) {
        super((class_4970.class_2251)settings);
        this.baseBlock = baseBlock;
        this.stonecuttable = stonecuttable;
        if (textures.length == 1) {
            this.texture_bottom = textures[0];
            this.texture_top = textures[0];
            this.texture_side = textures[0];
            this.texture_double = textures[0];
        } else if (textures.length == 2) {
            this.texture_bottom = textures[0];
            this.texture_top = textures[0];
            this.texture_side = textures[1];
            this.texture_double = textures[1];
        } else if (textures.length == 4) {
            this.texture_bottom = textures[0];
            this.texture_top = textures[1];
            this.texture_side = textures[2];
            this.texture_double = textures[3];
        } else {
            throw new IllegalArgumentException("Slabs need 1, 2 or 4 textures");
        }
    }

    public static void generateBlockModel(DatagenModContainer container, String identifier, String texture_bottom, String texture_top, String texture_side, String texture_double) {
        Map<String, String> textures = Map.of("top", texture_top, "bottom", texture_bottom, "side", texture_side);
        container.generateBlockModel(identifier, textures, "minecraft:block/slab");
        container.generateBlockModel(identifier + "_double", Map.of("all", texture_double), "minecraft:block/cube_all");
        container.generateBlockModel(identifier + "_top", textures, "minecraft:block/slab_top");
    }

    public static void generateBlockState(DatagenModContainer container, String identifier) {
        String modelBasePath = container.MOD_ID + ":block/";
        container.RESOURCE_PACK.addBlockState(JState.state((JVariant[])new JVariant[]{JState.variant().put("type=bottom", JState.model((String)(modelBasePath + identifier))).put("type=double", JState.model((String)(modelBasePath + identifier + "_double"))).put("type=top", JState.model((String)(modelBasePath + identifier + "_top")))}), new class_2960(container.MOD_ID, identifier));
    }

    public static void generateRecepie(DatagenModContainer container, String identifier, String baseBlock, Slab slabBlock) {
        if (baseBlock == null) {
            return;
        }
        if (slabBlock == null) {
            return;
        }
        String baseBlockID = container.getStringID(baseBlock);
        class_2960 blockItemID = container.getSimpleID(identifier);
        container.RESOURCE_PACK.addRecipe(new class_2960(container.MOD_ID, identifier + "_from_blocks"), (JRecipe)JRecipe.shaped((JPattern)JPattern.pattern((String[])new String[]{"###"}), (JKeys)JKeys.keys().key("#", JIngredient.ingredient().item(baseBlockID)), (JResult)JResult.stackedResult((String)blockItemID.toString(), (int)6)));
        container.RESOURCE_PACK.addRecipe(new class_2960(container.MOD_ID, identifier + "_from_slab"), (JRecipe)JRecipe.shaped((JPattern)JPattern.pattern((String[])new String[]{"#", "#"}), (JKeys)JKeys.keys().key("#", JIngredient.ingredient().item(blockItemID.toString())), (JResult)JResult.result((String)baseBlockID)));
        if (slabBlock.stonecuttable) {
            container.RESOURCE_PACK.addRecipe(new class_2960(container.MOD_ID, identifier + "_cut"), (JRecipe)JRecipe.stonecutting((JIngredient)JIngredient.ingredient().item(baseBlockID), (JStackedResult)JResult.stackedResult((String)blockItemID.toString(), (int)2)));
        }
    }

    @Override
    public class_1935 generateData(DatagenModContainer container, String identifier) {
        container.addTag("minecraft:blocks/slabs", identifier);
        container.addTag("minecraft:items/slabs", identifier);
        Slab.generateBlockModel(container, identifier, this.texture_bottom, this.texture_top, this.texture_side, this.texture_double);
        Slab.generateBlockState(container, identifier);
        Slab.generateRecepie(container, identifier, this.baseBlock, this);
        container.generateBlockItemModel(identifier);
        container.createBlockLootTable(identifier, null);
        return container.generateBlockItem((class_2248)this, container.settings());
    }
}

