/*
 * Decompiled with CFR 0.152.
 */
package de.sakurajin.sakuralib.datagen.v1.Presets.Blocks;

import com.google.gson.JsonElement;
import de.sakurajin.sakuralib.datagen.v1.DataGenerateable;
import de.sakurajin.sakuralib.datagen.v1.DatagenModContainer;
import net.devtech.arrp.json.blockstate.JState;
import net.devtech.arrp.json.blockstate.JVariant;
import net.devtech.arrp.json.loot.JEntry;
import net.devtech.arrp.json.loot.JLootTable;
import net.devtech.arrp.json.models.JModel;
import net.devtech.arrp.json.models.JTextures;
import net.devtech.arrp.json.recipe.JIngredient;
import net.devtech.arrp.json.recipe.JKeys;
import net.devtech.arrp.json.recipe.JPattern;
import net.devtech.arrp.json.recipe.JRecipe;
import net.devtech.arrp.json.recipe.JResult;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_4970;
import net.minecraft.class_8177;

public class Door
extends class_2323
implements DataGenerateable {
    private final String textureBaseName;
    private final String plankName;

    public Door(class_4970.class_2251 settings, class_8177 blockSetType, String textureBaseName, String plankName) {
        super(settings, blockSetType);
        this.textureBaseName = textureBaseName;
        this.plankName = plankName;
    }

    public static void generateBlockModel(DatagenModContainer container, String identifier, String textureBaseName) {
        String[] parts;
        String textureBottom = container.getStringID(textureBaseName + "_bottom", "block");
        String textureTop = container.getStringID(textureBaseName + "_top", "block");
        JTextures textures = JModel.textures().var("bottom", textureBottom).var("top", textureTop);
        for (String part : parts = new String[]{"bottom_left", "bottom_left_open", "bottom_right", "bottom_right_open", "top_left", "top_left_open", "top_right", "top_right_open"}) {
            container.RESOURCE_PACK.addModel(JModel.model().parent("minecraft:block/door_" + part).textures(textures), container.getSimpleID("block/" + identifier + "_" + part));
        }
    }

    private static String getModelName(String identifier, boolean isTop, boolean isLeft, boolean open) {
        return "block/" + identifier + "_" + (isTop ? "top" : "bottom") + "_" + (isLeft ? "left" : "right") + (open ? "_open" : "");
    }

    private static String getPropertyString(String direction, boolean isUpper, boolean isLeft, boolean open) {
        return "facing=" + direction + ",half=" + (isUpper ? "upper" : "lower") + ",hinge=" + (isLeft ? "left" : "right") + ",open=" + open;
    }

    private static int getRotation(String direction, boolean isLeft, boolean open) {
        int angle = switch (direction) {
            case "east" -> 0;
            case "south" -> 90;
            case "west" -> 180;
            case "north" -> 270;
            default -> throw new IllegalArgumentException("Invalid direction: " + direction);
        };
        if (open) {
            angle += isLeft ? 90 : -90;
        }
        while (angle < 0) {
            angle += 360;
        }
        while (angle >= 360) {
            angle -= 360;
        }
        return angle;
    }

    public static void generateBlockState(DatagenModContainer container, String identifier) {
        String[] directions = new String[]{"north", "south", "east", "west"};
        JVariant variant = JState.variant();
        for (String direction : directions) {
            for (boolean isUpper : new boolean[]{true, false}) {
                for (boolean isLeft : new boolean[]{true, false}) {
                    for (boolean open : new boolean[]{true, false}) {
                        String property = Door.getPropertyString(direction, isUpper, isLeft, open);
                        String model = Door.getModelName(identifier, isUpper, isLeft, open);
                        int rotation = Door.getRotation(direction, isLeft, open);
                        if (rotation != 0) {
                            variant.put(property, JState.model((class_2960)container.getSimpleID(model)).y(rotation));
                            continue;
                        }
                        variant.put(property, JState.model((class_2960)container.getSimpleID(model)));
                    }
                }
            }
        }
        container.RESOURCE_PACK.addBlockState(JState.state((JVariant[])new JVariant[]{variant}), container.getSimpleID(identifier));
    }

    protected DatagenModContainer.BlockLootOptions getLootOptions(DatagenModContainer container, String identifier) {
        DatagenModContainer.BlockLootOptions options = new DatagenModContainer.BlockLootOptions();
        options.conditionAdder = JEntry2 -> this.addExtraConditions(container, identifier, JEntry2);
        return options;
    }

    @Override
    public class_1935 generateData(DatagenModContainer container, String identifier) {
        Door.generateBlockModel(container, identifier, this.textureBaseName);
        Door.generateBlockState(container, identifier);
        container.createBlockLootTable(identifier, this.getLootOptions(container, identifier));
        container.RESOURCE_PACK.addRecipe(container.getSimpleID(identifier), (JRecipe)JRecipe.shaped((JPattern)JPattern.pattern((String[])new String[]{"##", "##", "##"}), (JKeys)JKeys.keys().key("#", JIngredient.ingredient().item(container.getStringID(this.plankName))), (JResult)JResult.stackedResult((String)container.getStringID(identifier), (int)3)));
        container.addTag("minecraft:blocks/doors", identifier);
        container.addTag("minecraft:items/doors", identifier);
        container.generateItemModel(identifier, "minecraft:item/generated", container.getStringID(identifier, "item"));
        return container.generateBlockItem((class_2248)this, container.settings());
    }

    public JEntry addExtraConditions(DatagenModContainer container, String identifier, JEntry entry) {
        return entry.condition(JLootTable.predicate((String)"minecraft:block_state_property").parameter("block", container.getStringID(identifier)).parameter("properties", (JsonElement)class_3518.method_15285((String)"{\"half\":\"lower\"}")));
    }
}

