/*
 * Decompiled with CFR 0.152.
 */
package de.sakurajin.sakuralib.datagen.v1;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sakurajin.sakuralib.arrp.v2.patchouli.JPatchouliBook;
import de.sakurajin.sakuralib.arrp.v2.patchouli.JPatchouliCategory;
import de.sakurajin.sakuralib.arrp.v2.patchouli.JPatchouliEntry;
import de.sakurajin.sakuralib.util.v1.TagIdentifier;
import io.wispforest.owo.itemgroup.Icon;
import io.wispforest.owo.itemgroup.OwoItemGroup;
import io.wispforest.owo.itemgroup.OwoItemSettings;
import io.wispforest.owo.registration.reflect.AutoRegistryContainer;
import io.wispforest.owo.registration.reflect.FieldRegistrationHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.devtech.arrp.api.RRPCallback;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.json.blockstate.JState;
import net.devtech.arrp.json.blockstate.JVariant;
import net.devtech.arrp.json.loot.JEntry;
import net.devtech.arrp.json.loot.JLootTable;
import net.devtech.arrp.json.models.JModel;
import net.devtech.arrp.json.models.JTextures;
import net.devtech.arrp.json.tags.JTag;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatagenModContainer {
    public final String MOD_ID;
    public final RuntimeResourcePack RESOURCE_PACK;
    public final Logger LOGGER;
    @Nullable
    public final OwoItemGroup GROUP;
    @Nullable
    public final class_5321<class_1761> VANILLA_GROUP_KEY;
    private final HashMap<String, ArrayList<String>> tags = new HashMap();

    public DatagenModContainer(String MOD_ID) {
        this(MOD_ID, null, (Event<RRPCallback>)RRPCallback.AFTER_VANILLA);
    }

    public DatagenModContainer(String MOD_ID, Supplier<Icon> groupIconSupplier) {
        this(MOD_ID, groupIconSupplier, (Event<RRPCallback>)RRPCallback.AFTER_VANILLA);
    }

    public DatagenModContainer(String MOD_ID, @NotNull Event<RRPCallback> event) {
        this(MOD_ID, null, event);
    }

    public DatagenModContainer(String MOD_ID, Supplier<Icon> groupIconSupplier, @NotNull Event<RRPCallback> event) {
        this.MOD_ID = MOD_ID;
        this.RESOURCE_PACK = RuntimeResourcePack.create((String)(MOD_ID + ":resources"));
        this.LOGGER = LoggerFactory.getLogger((String)MOD_ID);
        if (groupIconSupplier == null) {
            this.GROUP = null;
            this.VANILLA_GROUP_KEY = null;
        } else {
            this.GROUP = OwoItemGroup.builder((class_2960)new class_2960(MOD_ID, MOD_ID), groupIconSupplier).build();
            Optional key = class_7923.field_44687.method_29113((Object)this.GROUP);
            if (key.isEmpty()) {
                throw new RuntimeException("Failed to register item group for mod " + MOD_ID);
            }
            this.VANILLA_GROUP_KEY = (class_5321)key.get();
        }
        event.register(a -> a.add(this.RESOURCE_PACK));
    }

    public OwoItemSettings settings() {
        return this.settings(true);
    }

    public OwoItemSettings settings(boolean hasGroup) {
        OwoItemSettings settings = new OwoItemSettings();
        if (hasGroup) {
            settings.group(this.GROUP);
        }
        return settings;
    }

    public <T> void registerContainer(@NotNull Class<? extends AutoRegistryContainer<T>> clazz, boolean recurseIntoInnerClasses) {
        FieldRegistrationHandler.register(clazz, (String)this.MOD_ID, (boolean)recurseIntoInnerClasses);
    }

    public void addTag(String tag, String ... items) {
        String tagID = this.getStringID(tag);
        if (!this.tags.containsKey(tagID)) {
            this.tags.put(tagID, new ArrayList());
        }
        for (String item : items) {
            this.tags.get(tagID).add(this.getStringID(item));
        }
    }

    public void addTags(HashMap<String, ArrayList<String>> tags) {
        for (Map.Entry<String, ArrayList<String>> entry : tags.entrySet()) {
            for (String item : entry.getValue()) {
                this.addTag(entry.getKey(), item);
            }
        }
    }

    public void registerAllTags() {
        JTag tag;
        for (Map.Entry<String, ArrayList<String>> entry : this.tags.entrySet()) {
            tag = new JTag();
            try {
                this.RESOURCE_PACK.addTag(this.getSimpleID(entry.getKey()), tag);
            }
            catch (Exception e) {
                this.LOGGER.error("Failed to register empty tag " + entry.getKey(), (Throwable)e);
                throw e;
            }
        }
        for (Map.Entry<String, ArrayList<String>> entry : this.tags.entrySet()) {
            tag = new JTag();
            try {
                for (String id : entry.getValue()) {
                    tag.add(this.getSimpleID(id));
                }
                this.RESOURCE_PACK.addTag(this.getSimpleID(entry.getKey()), tag);
            }
            catch (Exception e) {
                this.LOGGER.error("Failed to register tag " + entry.getKey() + " with the following data:" + entry.getValue(), (Throwable)e);
                throw e;
            }
        }
    }

    @Deprecated(forRemoval=true, since="1.5.0")
    public void registerPatchouliBook(String bookname, JPatchouliBook book) {
        class_2960 location = this.getSimpleID("book.json", "patchouli_books/" + bookname);
        this.RESOURCE_PACK.addData(location, book.toString().getBytes());
    }

    @Deprecated(forRemoval=true, since="1.5.0")
    public void registerPatchouliCategory(String bookname, JPatchouliCategory category) {
        this.registerPatchouliCategory(bookname, category.getName(), category);
    }

    @Deprecated(forRemoval=true, since="1.5.0")
    public void registerPatchouliCategory(String bookname, String CategoryID, JPatchouliCategory category) {
        class_2960 location = this.getSimpleID(CategoryID + ".json", "patchouli_books/" + bookname + "/en_us/categories");
        this.RESOURCE_PACK.addAsset(location, category.toString().getBytes());
    }

    @Deprecated(forRemoval=true, since="1.5.0")
    public void registerPatchouliEntry(String bookname, String locale, JPatchouliEntry entry) {
        String category = entry.getCategory();
        if (category.split(":").length == 2) {
            category = category.split(":")[1];
        }
        class_2960 location = this.getSimpleID(entry.getName() + ".json", "patchouli_books/" + bookname + "/" + locale + "/entries/" + category);
        this.RESOURCE_PACK.addAsset(location, entry.toString().getBytes());
    }

    @Deprecated(forRemoval=true, since="1.5.0")
    public void registerPatchouliEntries(String bookname, String locale, JPatchouliEntry ... entries) {
        for (JPatchouliEntry entry : entries) {
            this.registerPatchouliEntry(bookname, locale, entry);
        }
    }

    @Deprecated(forRemoval=true, since="1.5.0")
    public void registerPatchouliEntry(String bookname, JPatchouliEntry entry) {
        this.registerPatchouliEntry(bookname, "en_us", entry);
    }

    @Deprecated(forRemoval=true, since="1.5.0")
    public void registerPatchouliEntries(String bookname, JPatchouliEntry ... entries) {
        this.registerPatchouliEntries(bookname, "en_us", entries);
    }

    public String getStringID(String name) {
        return this.getSimpleID(name, null).toString();
    }

    public String getStringID(String name, String type) {
        return this.getSimpleID(name, type).toString();
    }

    public class_2960 getSimpleID(String name) {
        return this.getSimpleID(name, null);
    }

    public class_2960 getSimpleID(String name, String type) {
        if (((String)name).contains(":")) {
            return new TagIdentifier((String)name);
        }
        if (type != null) {
            if (((String)name).startsWith("#")) {
                name = ((String)name).substring(1);
                type = "#" + (String)type;
            }
            name = (String)type + "/" + (String)name;
        }
        return TagIdentifier.ofDefault((String)name, this.MOD_ID);
    }

    public void generateBlockItemModel(String name) {
        String parent = this.getStringID(name, "block");
        this.generateItemModel(name, parent, null);
    }

    public void generateBlockItemModel(String name, String texture) {
        String parent = this.getStringID(name, "block");
        this.generateItemModel(name, parent, this.getStringID(texture, "block"));
    }

    public void generateItemModel(String name) {
        this.generateItemModel(name, "minecraft:item/generated", this.getStringID(name, "item"));
    }

    public void generateItemModel(String name, String parent) {
        this.generateItemModel(name, parent, null);
    }

    public void generateItemModel(String name, String parent, String texture) {
        class_2960 ItemID = this.getSimpleID("item/" + name);
        JTextures textures = null;
        if (texture != null) {
            textures = new JTextures().var("layer0", this.getStringID(texture, "item"));
        }
        this.RESOURCE_PACK.addModel(new JModel().parent(parent).textures(textures), ItemID);
    }

    public void generateBlockModel(String name, Map<String, String> textures, String parent) {
        class_2960 BlockID = this.getSimpleID("block/" + name);
        JTextures texture = new JTextures();
        for (Map.Entry<String, String> entry : textures.entrySet()) {
            texture.var(entry.getKey(), this.getStringID(entry.getValue(), "block"));
        }
        this.RESOURCE_PACK.addModel(new JModel().parent(parent).textures(texture), BlockID);
    }

    public void generateBlockState(String name) {
        this.RESOURCE_PACK.addBlockState(JState.state((JVariant[])new JVariant[]{JState.variant().put("", JState.model((String)this.getStringID(name, "block")))}), this.getSimpleID(name));
    }

    public void generateBlockStateOrientable(String name) {
        this.generateBlockStateOrientable(name, new String[]{name});
    }

    public void generateBlockStateOrientable(String name, String[] alternatives) {
        JVariant variants = JState.variant();
        for (String alternative : alternatives) {
            class_2960 model = this.getSimpleID("block/" + alternative);
            variants.put("facing=east", JState.model((class_2960)model).y(90));
            variants.put("facing=west", JState.model((class_2960)model).y(270));
            variants.put("facing=south", JState.model((class_2960)model).y(180));
            variants.put("facing=north", JState.model((class_2960)model));
        }
        this.RESOURCE_PACK.addBlockState(JState.state((JVariant[])new JVariant[]{variants}), this.getSimpleID(name));
    }

    public class_1935 generateBlockItem(class_2248 block, OwoItemSettings settings) {
        return new class_1747(block, (class_1792.class_1793)settings);
    }

    public JEntry addSilkTouchRequirement(JEntry entry) {
        JsonObject enchantments = class_3518.method_15285((String)"{\"enchantments\":[{\"enchantment\":\"minecraft:silk_touch\"}]}");
        return entry.condition(JLootTable.predicate((String)"minecraft:match_tool").parameter("predicate", (JsonElement)enchantments));
    }

    public void createBlockLootTable(String name, BlockLootOptions options) {
        if (options == null) {
            options = new BlockLootOptions();
        }
        JEntry entry = JLootTable.entry().type("minecraft:alternatives");
        JEntry baseDropEntry = JLootTable.entry().type("minecraft:item").name(this.getStringID(name)).function(JLootTable.function((String)"minecraft:set_count").parameter("count", (Number)1));
        if (!options.survivesExplosion) {
            baseDropEntry = baseDropEntry.condition(JLootTable.predicate((String)"minecraft:survives_explosion"));
        }
        if (options.needsSilkTouch) {
            baseDropEntry = this.addSilkTouchRequirement(baseDropEntry);
        }
        if (options.conditionAdder != null) {
            baseDropEntry = options.conditionAdder.addCondition(baseDropEntry);
        }
        entry = entry.child(baseDropEntry);
        if (options.alternativeDrop != null) {
            JEntry alternative = JLootTable.entry().type("minecraft:item");
            if (options.conditionAdder != null) {
                alternative = options.conditionAdder.addCondition(alternative);
            }
            alternative = alternative.name(this.getStringID(options.alternativeDrop)).function(JLootTable.function((String)"minecraft:set_count").parameter("count", (Number)options.alternativeDropCount));
            entry = entry.child(alternative);
        }
        this.RESOURCE_PACK.addLootTable(this.getSimpleID("blocks/" + name), JLootTable.loot((String)"minecraft:block").pool(JLootTable.pool().rolls(Integer.valueOf(1)).bonus(Integer.valueOf(0)).entry(entry)));
    }

    public static class BlockLootOptions {
        public String alternativeDrop;
        public int alternativeDropCount;
        public boolean needsSilkTouch;
        public boolean survivesExplosion = true;
        public LootTableConditionAdder conditionAdder;

        public BlockLootOptions() {
            this(false, null, 0);
        }

        public BlockLootOptions(boolean needsSilkTouch) {
            this(needsSilkTouch, null, 0);
        }

        public BlockLootOptions(boolean needsSilkTouch, String alternativeDrop, int alternativeDropCount) {
            this.alternativeDrop = alternativeDrop;
            this.alternativeDropCount = alternativeDropCount;
            this.needsSilkTouch = needsSilkTouch;
        }
    }

    @FunctionalInterface
    public static interface LootTableConditionAdder {
        public JEntry addCondition(JEntry var1);
    }
}

