/*
 * Decompiled with CFR 0.152.
 */
package de.sakurajin.sakuralib.arrp.v2.patchouli.pages;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sakurajin.sakuralib.arrp.v2.patchouli.JPageBase;
import de.sakurajin.sakuralib.arrp.v2.patchouli.pages.JMultiblockStructure;
import org.jetbrains.annotations.NotNull;

public class JMultiblockPage
extends JPageBase {
    private final String name;
    private final String multiblock_id;
    private final JMultiblockStructure multiblock;
    private boolean enable_visualize = false;
    private String text = null;

    protected JMultiblockPage(String name, String multiblock_id, JMultiblockStructure multiblock) {
        super("patchouli:crafting");
        this.name = name;
        if (multiblock == null && multiblock_id == null) {
            throw new IllegalArgumentException("Either multiblock or multiblock_id has to be set.");
        }
        this.multiblock_id = multiblock_id;
        this.multiblock = multiblock;
    }

    public static JMultiblockPage create(String name, @NotNull String multiblock_id) {
        return new JMultiblockPage(name, multiblock_id, null);
    }

    public static JMultiblockPage create(String name, @NotNull JMultiblockStructure multiblock) {
        return new JMultiblockPage(name, null, multiblock);
    }

    public JMultiblockPage enableVisualize() {
        this.enable_visualize = true;
        return this;
    }

    public JMultiblockPage setText(String text) {
        this.text = text;
        return this;
    }

    @Override
    public JsonObject toJson() {
        JsonObject RecipeJson = super.toJson();
        RecipeJson.addProperty("name", this.name);
        if (this.multiblock_id != null) {
            RecipeJson.addProperty("multiblock_id", this.multiblock_id);
        }
        if (this.multiblock != null) {
            RecipeJson.add("multiblock", (JsonElement)this.multiblock.toJson());
        }
        if (this.enable_visualize) {
            RecipeJson.addProperty("enable_visualize", Boolean.valueOf(true));
        }
        if (this.text != null) {
            RecipeJson.addProperty("text", this.text);
        }
        return RecipeJson;
    }
}

