/*
 * Decompiled with CFR 0.152.
 */
package de.sakurajin.sakuralib.arrp.v2.patchouli.pages;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sakurajin.sakuralib.arrp.v2.patchouli.JPageBase;
import java.util.ArrayList;

public class JImagePage
extends JPageBase {
    private final ArrayList<String> images = new ArrayList();
    private String title = null;
    private boolean border = false;
    private String text = null;

    private JImagePage() {
        super("patchouli:image");
    }

    public static JImagePage create() {
        return new JImagePage();
    }

    public static JImagePage create(String image) {
        return new JImagePage().addImage(image);
    }

    public JImagePage addImage(String image) {
        this.images.add(image);
        return this;
    }

    public JImagePage setTitle(String title) {
        this.title = title;
        return this;
    }

    public JImagePage hasBorder() {
        this.border = true;
        return this;
    }

    public JImagePage setText(String text) {
        this.text = text;
        return this;
    }

    @Override
    public JsonObject toJson() throws IllegalStateException {
        JsonObject imageJson = super.toJson();
        if (this.images.isEmpty()) {
            throw new IllegalStateException("Image page must have at least one image");
        }
        JsonArray imagesArray = new JsonArray();
        for (String image : this.images) {
            imagesArray.add(image);
        }
        imageJson.add("images", (JsonElement)imagesArray);
        if (this.title != null) {
            imageJson.addProperty("title", this.title);
        }
        if (this.border) {
            imageJson.addProperty("border", Boolean.valueOf(true));
        }
        if (this.text != null) {
            imageJson.addProperty("text", this.text);
        }
        return imageJson;
    }
}

