/*
 * Decompiled with CFR 0.152.
 */
package de.sakurajin.sakuralib.arrp.v2.patchouli;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sakurajin.sakuralib.arrp.v2.patchouli.JPageBase;
import de.sakurajin.sakuralib.arrp.v2.patchouli.pages.JTextPage;
import de.sakurajin.sakuralib.util.v1.SakuraJsonHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JPatchouliEntry {
    private final String name;
    private final String category;
    private final String icon;
    private final ArrayList<JPageBase> pages = new ArrayList();
    private String advancement = null;
    private String flag = null;
    private boolean priority = false;
    private boolean secret = false;
    private boolean read_by_default = false;
    private int sortnum = 0;
    private String turnin = null;
    private final HashMap<String, Integer> extra_recipe_mappings = new HashMap();

    private JPatchouliEntry(String name, String category, String icon) {
        this.name = name;
        this.category = category;
        this.icon = icon;
    }

    public static JPatchouliEntry create(@NotNull String name, String category, @NotNull String icon) {
        return new JPatchouliEntry(name, category, icon);
    }

    public JPatchouliEntry copyWithCategory(String newCategory) {
        if (newCategory == null) {
            throw new IllegalArgumentException("The new category must not be null");
        }
        if (newCategory.equals(this.category)) {
            return this;
        }
        JPatchouliEntry newEntry = new JPatchouliEntry(this.name, newCategory, this.icon);
        newEntry.pages.addAll(this.pages);
        newEntry.advancement = this.advancement;
        newEntry.flag = this.flag;
        newEntry.priority = this.priority;
        newEntry.secret = this.secret;
        newEntry.read_by_default = this.read_by_default;
        newEntry.sortnum = this.sortnum;
        newEntry.turnin = this.turnin;
        newEntry.extra_recipe_mappings.putAll(this.extra_recipe_mappings);
        return newEntry;
    }

    public JPatchouliEntry addPage(JPageBase page) {
        this.pages.add(page);
        return this;
    }

    public JPatchouliEntry addTextPage(String text) {
        this.pages.add(JTextPage.create(text));
        return this;
    }

    public JPatchouliEntry setAdvancement(String advancement) {
        this.advancement = advancement;
        return this;
    }

    public JPatchouliEntry setFlag(String flag) {
        this.flag = flag;
        return this;
    }

    public JPatchouliEntry prioritize() {
        this.priority = true;
        return this;
    }

    public JPatchouliEntry isSecret() {
        this.secret = true;
        return this;
    }

    public JPatchouliEntry isReadByDefault() {
        this.read_by_default = true;
        return this;
    }

    public JPatchouliEntry setSortnum(int sortnum) {
        this.sortnum = sortnum;
        return this;
    }

    public JPatchouliEntry setTurnin(String turnin) {
        this.turnin = turnin;
        return this;
    }

    public JPatchouliEntry addExtraRecipeMapping(String itemStack, int page) {
        this.extra_recipe_mappings.put(itemStack, page);
        return this;
    }

    public JsonObject toJson() throws IllegalArgumentException {
        if (this.pages.isEmpty()) {
            throw new IllegalArgumentException("An entry must have at least one page");
        }
        JPageBase jPageBase = this.pages.get(0);
        if (jPageBase instanceof JTextPage) {
            JTextPage textPage = (JTextPage)jPageBase;
            if (textPage.hasTitle()) {
                throw new IllegalArgumentException("The first page of an entry must not have a title");
            }
        } else {
            throw new IllegalArgumentException("The first page of an entry must be a JTextPage");
        }
        if (this.category == null) {
            throw new IllegalArgumentException("An entry must have a category");
        }
        JsonObject entryJson = new JsonObject();
        entryJson.addProperty("name", this.name);
        entryJson.addProperty("category", this.category);
        entryJson.addProperty("icon", this.icon);
        JsonArray pagesJson = new JsonArray();
        for (JPageBase page : this.pages) {
            pagesJson.add((JsonElement)page.toJson());
        }
        entryJson.add("pages", (JsonElement)pagesJson);
        if (this.advancement != null) {
            entryJson.addProperty("advancement", this.advancement);
        }
        if (this.flag != null) {
            entryJson.addProperty("flag", this.flag);
        }
        if (this.priority) {
            entryJson.addProperty("priority", Boolean.valueOf(true));
        }
        if (this.secret) {
            entryJson.addProperty("secret", Boolean.valueOf(true));
        }
        if (this.read_by_default) {
            entryJson.addProperty("read_by_default", Boolean.valueOf(true));
        }
        if (this.sortnum != 0) {
            entryJson.addProperty("sortnum", (Number)this.sortnum);
        }
        if (this.turnin != null) {
            entryJson.addProperty("turnin", this.turnin);
        }
        if (!this.extra_recipe_mappings.isEmpty()) {
            JsonObject extra_recipe_mappingsJson = new JsonObject();
            for (Map.Entry<String, Integer> entry : this.extra_recipe_mappings.entrySet()) {
                extra_recipe_mappingsJson.addProperty(entry.getKey(), (Number)entry.getValue());
            }
            entryJson.add("extra_recipe_mappings", (JsonElement)extra_recipe_mappingsJson);
        }
        return entryJson;
    }

    public String toString() {
        return SakuraJsonHelper.toPrettyJson((JsonElement)this.toJson());
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }
}

