/*
 * Decompiled with CFR 0.152.
 */
package de.sakurajin.sakuralib.arrp.v2.patchouli;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sakurajin.sakuralib.util.v1.SakuraJsonHelper;

public class JPatchouliCategory {
    private final String name;
    private final String description;
    private final String icon;
    private String parent = null;
    private String flag = null;
    private int sortnum = 0;
    private boolean secret = false;

    private JPatchouliCategory(String name, String description, String icon) {
        this.name = name;
        this.description = description;
        this.icon = icon;
    }

    public static JPatchouliCategory create(String name, String description, String icon) {
        return new JPatchouliCategory(name, description, icon);
    }

    public JPatchouliCategory setParent(String parent) {
        this.parent = parent;
        return this;
    }

    public JPatchouliCategory setFlag(String flag) {
        this.flag = flag;
        return this;
    }

    public JPatchouliCategory setSortnum(int sortnum) {
        this.sortnum = sortnum;
        return this;
    }

    @Deprecated(since="1.4.1", forRemoval=true)
    public JPatchouliCategory setSecret(boolean secret) {
        this.secret = secret;
        return this;
    }

    public JPatchouliCategory isSecret() {
        this.secret = true;
        return this;
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("name", this.name);
        obj.addProperty("description", this.description);
        obj.addProperty("icon", this.icon);
        if (this.parent != null) {
            obj.addProperty("parent", this.parent);
        }
        if (this.flag != null) {
            obj.addProperty("flag", this.flag);
        }
        if (this.sortnum != 0) {
            obj.addProperty("sortnum", (Number)this.sortnum);
        }
        if (this.secret) {
            obj.addProperty("secret", Boolean.valueOf(true));
        }
        return obj;
    }

    public String toString() {
        return SakuraJsonHelper.toPrettyJson((JsonElement)this.toJson());
    }

    public String getName() {
        return this.name;
    }
}

