/*
 * Decompiled with CFR 0.152.
 */
package de.sakurajin.sakuralib.arrp.v2.patchouli;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sakurajin.sakuralib.util.v1.SakuraJsonHelper;
import java.util.HashMap;
import java.util.Map;

public class JPatchouliBook {
    private final String name;
    private final String landing_text;
    private String book_texture = null;
    private String filler_texture = null;
    private String crafting_texture = null;
    private String model = null;
    private String text_color = null;
    private String header_color = null;
    private String nameplate_color = null;
    private String link_color = null;
    private String link_hover_color = null;
    private String progress_bar_color = null;
    private String progress_bar_background = null;
    private String open_sound = null;
    private String flip_sound = null;
    private String index_icon = null;
    private boolean pamphlet = false;
    private boolean show_progress = true;
    private String version = null;
    private String subtitle = null;
    private String creative_tab = null;
    private String advancements_tab = null;
    private boolean dont_generate_book = false;
    private String custom_book_item = null;
    private boolean show_toasts = true;
    private boolean use_blocky_font = false;
    private boolean i18n = true;
    private final HashMap<String, String> macros = new HashMap();
    private boolean pause_game = false;
    private TextOverflowMode text_overflow = null;

    private JPatchouliBook(String name, String landing_text) {
        this.name = name;
        this.landing_text = landing_text;
    }

    public static JPatchouliBook create(String name, String landing_text) {
        return new JPatchouliBook(name, landing_text);
    }

    public JPatchouliBook setBookTexture(String book_texture) {
        this.book_texture = book_texture;
        return this;
    }

    public JPatchouliBook setFillerTexture(String filler_texture) {
        this.filler_texture = filler_texture;
        return this;
    }

    public JPatchouliBook setCraftingTexture(String crafting_texture) {
        this.crafting_texture = crafting_texture;
        return this;
    }

    public JPatchouliBook setModel(String model) {
        this.model = model;
        return this;
    }

    public JPatchouliBook setTextColor(String text_color) {
        this.text_color = text_color;
        return this;
    }

    public JPatchouliBook setHeaderColor(String header_color) {
        this.header_color = header_color;
        return this;
    }

    public JPatchouliBook setNameplateColor(String nameplate_color) {
        this.nameplate_color = nameplate_color;
        return this;
    }

    public JPatchouliBook setLinkColor(String link_color) {
        this.link_color = link_color;
        return this;
    }

    public JPatchouliBook setLinkHoverColor(String link_hover_color) {
        this.link_hover_color = link_hover_color;
        return this;
    }

    public JPatchouliBook setProgressBarColor(String progress_bar_color) {
        this.progress_bar_color = progress_bar_color;
        return this;
    }

    public JPatchouliBook setProgressBarBackground(String progress_bar_background) {
        this.progress_bar_background = progress_bar_background;
        return this;
    }

    public JPatchouliBook setOpenSound(String open_sound) {
        this.open_sound = open_sound;
        return this;
    }

    public JPatchouliBook setFlipSound(String flip_sound) {
        this.flip_sound = flip_sound;
        return this;
    }

    public JPatchouliBook setIndexIcon(String index_icon) {
        this.index_icon = index_icon;
        return this;
    }

    public JPatchouliBook isPamphlet() {
        this.pamphlet = true;
        return this;
    }

    public JPatchouliBook dontShowProgress() {
        this.show_progress = false;
        return this;
    }

    public JPatchouliBook setVersion(String version) {
        this.version = version;
        return this;
    }

    public JPatchouliBook setSubtitle(String subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    public JPatchouliBook setCreativeTab(String creative_tab) {
        this.creative_tab = creative_tab;
        return this;
    }

    public JPatchouliBook setAdvancementsTab(String advancements_tab) {
        this.advancements_tab = advancements_tab;
        return this;
    }

    public JPatchouliBook setCustomBookItem(String custom_book_item) {
        this.dont_generate_book = true;
        this.custom_book_item = custom_book_item;
        return this;
    }

    public JPatchouliBook dontShowToasts() {
        this.show_toasts = false;
        return this;
    }

    public JPatchouliBook useBlockyFont() {
        this.use_blocky_font = true;
        return this;
    }

    public JPatchouliBook dontUseI18n() {
        this.i18n = false;
        return this;
    }

    public JPatchouliBook addMacro(String key, String value) {
        this.macros.put(key, value);
        return this;
    }

    public JPatchouliBook pauseGame() {
        this.pause_game = true;
        return this;
    }

    public JPatchouliBook setTextOverflow(TextOverflowMode text_overflow) {
        this.text_overflow = text_overflow;
        return this;
    }

    public JsonObject toJson() {
        JsonObject bookJson = new JsonObject();
        bookJson.addProperty("name", this.name);
        bookJson.addProperty("landing_text", this.landing_text);
        bookJson.addProperty("use_resource_pack", Boolean.valueOf(true));
        bookJson.addProperty("i18n", Boolean.valueOf(this.i18n));
        if (this.text_color != null) {
            bookJson.addProperty("text_color", this.text_color);
        }
        if (this.header_color != null) {
            bookJson.addProperty("header_color", this.header_color);
        }
        if (this.nameplate_color != null) {
            bookJson.addProperty("nameplate_color", this.nameplate_color);
        }
        if (this.link_color != null) {
            bookJson.addProperty("link_color", this.link_color);
        }
        if (this.link_hover_color != null) {
            bookJson.addProperty("link_hover_color", this.link_hover_color);
        }
        if (this.progress_bar_color != null) {
            bookJson.addProperty("progress_bar_color", this.progress_bar_color);
        }
        if (this.progress_bar_background != null) {
            bookJson.addProperty("progress_bar_background", this.progress_bar_background);
        }
        if (this.use_blocky_font) {
            bookJson.addProperty("use_blocky_font", Boolean.valueOf(true));
        }
        if (this.text_overflow != null) {
            bookJson.addProperty("text_overflow", this.text_overflow.toString());
        }
        if (!this.show_toasts) {
            bookJson.addProperty("show_toasts", Boolean.valueOf(false));
        }
        if (this.book_texture != null) {
            bookJson.addProperty("book_texture", this.book_texture);
        }
        if (this.filler_texture != null) {
            bookJson.addProperty("filler_texture", this.filler_texture);
        }
        if (this.crafting_texture != null) {
            bookJson.addProperty("crafting_texture", this.crafting_texture);
        }
        if (this.model != null) {
            bookJson.addProperty("model", this.model);
        }
        if (this.index_icon != null) {
            bookJson.addProperty("index_icon", this.index_icon);
        }
        if (this.custom_book_item != null) {
            bookJson.addProperty("custom_book_item", this.custom_book_item);
        }
        if (this.open_sound != null) {
            bookJson.addProperty("open_sound", this.open_sound);
        }
        if (this.flip_sound != null) {
            bookJson.addProperty("flip_sound", this.flip_sound);
        }
        if (this.dont_generate_book) {
            bookJson.addProperty("dont_generate_book", Boolean.valueOf(true));
        }
        if (this.pamphlet) {
            bookJson.addProperty("pamphlet", Boolean.valueOf(true));
        }
        if (!this.show_progress) {
            bookJson.addProperty("show_progress", Boolean.valueOf(false));
        }
        if (this.version != null) {
            bookJson.addProperty("version", this.version);
        }
        if (this.subtitle != null) {
            bookJson.addProperty("subtitle", this.subtitle);
        }
        if (this.creative_tab != null) {
            bookJson.addProperty("creative_tab", this.creative_tab);
        }
        if (this.advancements_tab != null) {
            bookJson.addProperty("advancements_tab", this.advancements_tab);
        }
        if (this.pause_game) {
            bookJson.addProperty("pause_game", Boolean.valueOf(true));
        }
        if (!this.macros.isEmpty()) {
            JsonObject macrosJson = new JsonObject();
            for (Map.Entry<String, String> entry : this.macros.entrySet()) {
                macrosJson.addProperty(entry.getKey(), entry.getValue());
            }
            bookJson.add("macros", (JsonElement)macrosJson);
        }
        return bookJson;
    }

    public String toString() {
        return SakuraJsonHelper.toPrettyJson((JsonElement)this.toJson());
    }

    public static enum TextOverflowMode {
        OVERFLOW("overflow"),
        RESIZE("resize"),
        TRUNCATE("truncate");

        private final String modeString;

        private TextOverflowMode(String modeString) {
            this.modeString = modeString;
        }

        public String toString() {
            return this.modeString;
        }
    }
}

