/*
 * Decompiled with CFR 0.152.
 */
package de.sakurajin.sakuralib.arrp.v1.worldgen.processor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sakurajin.sakuralib.arrp.v1.worldgen.processor.InputPredicate;
import de.sakurajin.sakuralib.arrp.v1.worldgen.processor.LocationPredicate;
import de.sakurajin.sakuralib.arrp.v1.worldgen.processor.PositionPredicate;
import de.sakurajin.sakuralib.util.v1.SakuraJsonHelper;
import org.jetbrains.annotations.NotNull;

public class ProcessorRule
implements Comparable<ProcessorRule> {
    protected final JsonObject rule = new JsonObject();

    public ProcessorRule locationPredicate(LocationPredicate predicate) {
        this.rule.add("location_predicate", (JsonElement)predicate.toJson());
        return this;
    }

    public ProcessorRule inputPredicate(InputPredicate predicate) {
        this.rule.add("input_predicate", (JsonElement)predicate.toJson());
        return this;
    }

    public ProcessorRule positionPredicate(PositionPredicate predicate) {
        this.rule.add("position_predicate", (JsonElement)predicate.toJson());
        return this;
    }

    public ProcessorRule outputState(String name) {
        return this.outputState(name, null);
    }

    public ProcessorRule outputState(String name, JsonObject properties) {
        this.rule.add("output_state", (JsonElement)new JsonObject());
        this.rule.getAsJsonObject("output_state").addProperty("Name", name);
        if (properties != null) {
            this.rule.getAsJsonObject("output_state").add("Properties", (JsonElement)properties);
        }
        return this;
    }

    public ProcessorRule appendLoot(String lootTable) {
        this.rule.add("block_entity_modifier", (JsonElement)new JsonObject());
        this.rule.getAsJsonObject("block_entity_modifier").addProperty("type", "minecraft:append_loot");
        this.rule.getAsJsonObject("block_entity_modifier").addProperty("loot_table", lootTable);
        return this;
    }

    public ProcessorRule appendStatic(JsonObject data) {
        this.rule.add("block_entity_modifier", (JsonElement)new JsonObject());
        this.rule.getAsJsonObject("block_entity_modifier").addProperty("type", "minecraft:append_static");
        this.rule.getAsJsonObject("block_entity_modifier").add("data", (JsonElement)data);
        return this;
    }

    public ProcessorRule clearBlockEntity() {
        this.rule.add("block_entity_modifier", (JsonElement)new JsonObject());
        this.rule.getAsJsonObject("block_entity_modifier").addProperty("type", "minecraft:clear");
        return this;
    }

    public static ProcessorRule replaceBlock(String inputBlock, String outputBlock, double probability) {
        return new ProcessorRule().locationPredicate(new LocationPredicate(LocationPredicate.locationPredicateType.ALWAYS_TRUE)).positionPredicate(new PositionPredicate(PositionPredicate.positionPredicateType.ALWAYS_TRUE)).inputPredicate(new InputPredicate(InputPredicate.inputPredicateType.RANDOM_BLOCK_MATCH).block(inputBlock).probability(probability)).outputState(outputBlock);
    }

    public static ProcessorRule replaceBlockWithLoot(String inputBlock, String outputBlock, double probability, String lootTable) {
        return new ProcessorRule().locationPredicate(new LocationPredicate(LocationPredicate.locationPredicateType.ALWAYS_TRUE)).positionPredicate(new PositionPredicate(PositionPredicate.positionPredicateType.ALWAYS_TRUE)).inputPredicate(new InputPredicate(InputPredicate.inputPredicateType.RANDOM_BLOCK_MATCH).block(inputBlock).probability(probability)).outputState(outputBlock).appendLoot(lootTable);
    }

    public static ProcessorRule addLootTable(String inputBlock, String lootTable) {
        return new ProcessorRule().locationPredicate(new LocationPredicate(LocationPredicate.locationPredicateType.ALWAYS_TRUE)).positionPredicate(new PositionPredicate(PositionPredicate.positionPredicateType.ALWAYS_TRUE)).inputPredicate(new InputPredicate(InputPredicate.inputPredicateType.BLOCK_MATCH).block(inputBlock)).outputState(inputBlock).appendLoot(lootTable);
    }

    public JsonObject toJson() {
        return this.rule.deepCopy();
    }

    public String toString() {
        return SakuraJsonHelper.toPrettyJson((JsonElement)this.rule);
    }

    @Override
    public int compareTo(@NotNull ProcessorRule processorRule) {
        return this.toString().compareTo(processorRule.toString());
    }
}

