/*
 * Decompiled with CFR 0.152.
 */
package de.sakurajin.sakuralib.arrp.v1.worldgen.processor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sakurajin.sakuralib.util.v1.SakuraJsonHelper;

public class PositionPredicate {
    protected final positionPredicateType predicate_type;
    protected JsonObject positionPredicate = new JsonObject();

    public PositionPredicate(positionPredicateType type) {
        this.predicate_type = type;
        this.positionPredicate.addProperty("predicate_type", type.positionPredicateType);
    }

    public PositionPredicate axis(char axis) {
        if (this.predicate_type != positionPredicateType.AXIS_ALIGNED_LINEAR_POS) {
            throw new IllegalArgumentException("axis can only be set for AXIS_ALIGNED_LINEAR_POS");
        }
        this.positionPredicate.addProperty("axis", Character.valueOf(axis));
        return this;
    }

    public PositionPredicate minChance(double min_chance) {
        if (this.predicate_type == positionPredicateType.ALWAYS_TRUE) {
            throw new IllegalArgumentException("min_chance can only be set for LINEAR_POS and AXIS_ALIGNED_LINEAR_POS");
        }
        this.positionPredicate.addProperty("min_chance", (Number)min_chance);
        return this;
    }

    public PositionPredicate maxChance(double max_chance) {
        if (this.predicate_type == positionPredicateType.ALWAYS_TRUE) {
            throw new IllegalArgumentException("max_chance can only be set for LINEAR_POS and AXIS_ALIGNED_LINEAR_POS");
        }
        this.positionPredicate.addProperty("max_chance", (Number)max_chance);
        return this;
    }

    public PositionPredicate minDist(int min_dist) {
        if (this.predicate_type != positionPredicateType.LINEAR_POS) {
            throw new IllegalArgumentException("min_dist can only be set for LINEAR_POS");
        }
        this.positionPredicate.addProperty("min_dist", (Number)min_dist);
        return this;
    }

    public PositionPredicate maxDist(int max_dist) {
        if (this.predicate_type != positionPredicateType.LINEAR_POS) {
            throw new IllegalArgumentException("max_dist can only be set for LINEAR_POS");
        }
        this.positionPredicate.addProperty("max_dist", (Number)max_dist);
        return this;
    }

    public String toString() {
        return SakuraJsonHelper.toPrettyJson((JsonElement)this.positionPredicate);
    }

    public JsonObject toJson() {
        return this.positionPredicate.deepCopy();
    }

    public static class positionPredicateType {
        protected final String positionPredicateType;
        public static final positionPredicateType ALWAYS_TRUE = new positionPredicateType("minecraft:always_true");
        public static final positionPredicateType LINEAR_POS = new positionPredicateType("minecraft:linear_pos");
        public static final positionPredicateType AXIS_ALIGNED_LINEAR_POS = new positionPredicateType("minecraft:axis_aligned_linear_pos");

        protected positionPredicateType(String positionPredicateType2) {
            this.positionPredicateType = positionPredicateType2;
        }
    }
}

