/*
 * Decompiled with CFR 0.152.
 */
package de.sakurajin.sakuralib.arrp.v1.worldgen.processor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sakurajin.sakuralib.util.v1.SakuraJsonHelper;
import org.jetbrains.annotations.NotNull;

public class LocationPredicate
implements Comparable<LocationPredicate> {
    protected JsonObject location_predicate = new JsonObject();
    protected final locationPredicateType type;

    @Override
    public int compareTo(@NotNull LocationPredicate locationPredicate) {
        return this.location_predicate.toString().compareTo(locationPredicate.toString());
    }

    public LocationPredicate(locationPredicateType type) {
        this.type = type;
        this.location_predicate.addProperty("predicate_type", type.predicate_type);
    }

    public LocationPredicate block(String block) {
        if (this.type != locationPredicateType.BLOCK_MATCH && this.type != locationPredicateType.RANDOM_BLOCK_MATCH) {
            throw new IllegalArgumentException("This predicate type does not support the block property");
        }
        this.location_predicate.addProperty("block", block);
        return this;
    }

    public LocationPredicate blockstate(JsonObject blockstate) {
        if (this.type != locationPredicateType.BLOCKSTATE_MATCH) {
            throw new IllegalArgumentException("This predicate type does not support the blockstate property");
        }
        this.location_predicate.add("blockstate", (JsonElement)blockstate);
        return this;
    }

    public LocationPredicate probability(double probability) {
        if (this.type != locationPredicateType.RANDOM_BLOCK_MATCH) {
            throw new IllegalArgumentException("This predicate type does not support the probability property");
        }
        this.location_predicate.addProperty("probability", (Number)probability);
        return this;
    }

    public LocationPredicate tag(String tag) {
        if (this.type != locationPredicateType.TAG_MATCH) {
            throw new IllegalArgumentException("This predicate type does not support the tag property");
        }
        this.location_predicate.addProperty("tag", tag);
        return this;
    }

    public JsonObject toJson() {
        return this.location_predicate.deepCopy();
    }

    public String toString() {
        return SakuraJsonHelper.toPrettyJson((JsonElement)this.location_predicate);
    }

    public static class locationPredicateType {
        protected final String predicate_type;
        public static final locationPredicateType ALWAYS_TRUE = new locationPredicateType("minecraft:always_true");
        public static final locationPredicateType BLOCK_MATCH = new locationPredicateType("minecraft:block_match");
        public static final locationPredicateType BLOCKSTATE_MATCH = new locationPredicateType("minecraft:blockstate_match");
        public static final locationPredicateType RANDOM_BLOCK_MATCH = new locationPredicateType("minecraft:random_block_match");
        public static final locationPredicateType TAG_MATCH = new locationPredicateType("minecraft:tag_match");

        protected locationPredicateType(String predicate_type) {
            this.predicate_type = predicate_type;
        }
    }
}

