/*
 * Decompiled with CFR 0.152.
 */
package de.sakurajin.sakuralib.arrp.v1.worldgen.processor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sakurajin.sakuralib.util.v1.SakuraJsonHelper;

public class InputPredicate {
    protected final inputPredicateType type;
    protected final JsonObject input_predicate = new JsonObject();

    public InputPredicate(inputPredicateType type) {
        this.type = type;
        this.input_predicate.addProperty("predicate_type", type.predicate_type);
    }

    public InputPredicate block(String block) {
        if (this.type != inputPredicateType.BLOCK_MATCH && this.type != inputPredicateType.RANDOM_BLOCK_MATCH) {
            throw new IllegalArgumentException("This predicate type does not support the block property");
        }
        this.input_predicate.addProperty("block", block);
        return this;
    }

    public InputPredicate blockstate(JsonObject blockstate) {
        if (this.type != inputPredicateType.BLOCKSTATE_MATCH && this.type != inputPredicateType.RANDOM_BLOCKSTATE_MATCH) {
            throw new IllegalArgumentException("This predicate type does not support the blockstate property");
        }
        this.input_predicate.add("blockstate", (JsonElement)blockstate);
        return this;
    }

    public InputPredicate probability(double probability) {
        if (this.type != inputPredicateType.RANDOM_BLOCK_MATCH && this.type != inputPredicateType.RANDOM_BLOCKSTATE_MATCH) {
            throw new IllegalArgumentException("This predicate type does not support the probability property");
        }
        this.input_predicate.addProperty("probability", (Number)probability);
        return this;
    }

    public InputPredicate tag(String tag) {
        if (this.type != inputPredicateType.TAG_MATCH) {
            throw new IllegalArgumentException("This predicate type does not support the tag property");
        }
        this.input_predicate.addProperty("tag", tag);
        return this;
    }

    public JsonObject toJson() {
        return this.input_predicate.deepCopy();
    }

    public String toString() {
        return SakuraJsonHelper.toPrettyJson((JsonElement)this.input_predicate);
    }

    public static class inputPredicateType {
        protected final String predicate_type;
        public static final inputPredicateType ALWAYS_TRUE = new inputPredicateType("minecraft:always_true");
        public static final inputPredicateType BLOCK_MATCH = new inputPredicateType("minecraft:block_match");
        public static final inputPredicateType BLOCKSTATE_MATCH = new inputPredicateType("minecraft:blockstate_match");
        public static final inputPredicateType RANDOM_BLOCK_MATCH = new inputPredicateType("minecraft:random_block_match");
        public static final inputPredicateType RANDOM_BLOCKSTATE_MATCH = new inputPredicateType("minecraft:random_blockstate_match");
        public static final inputPredicateType TAG_MATCH = new inputPredicateType("minecraft:tag_match");

        protected inputPredicateType(String predicate_type) {
            this.predicate_type = predicate_type;
        }
    }
}

