/*
 * Decompiled with CFR 0.152.
 */
package de.sakurajin.sakuralib.arrp.v1.worldgen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sakurajin.sakuralib.arrp.v1.worldgen.processor.JProcessor;
import de.sakurajin.sakuralib.datagen.v1.DatagenModContainer;
import de.sakurajin.sakuralib.util.v1.SakuraJsonHelper;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class StructureDataBuilder {
    protected final String name;
    protected final String type;
    protected class_2960 structureBiomeID = null;
    protected String terrain_adaptation = "beard_thin";
    protected int start_height = 0;
    protected String project_start_to_heightmap = "WORLD_SURFACE_WG";
    protected String structure_step = "surface_structures";
    protected int structure_size = 1;
    protected int max_distance_from_center = 80;
    protected String placement_type = "minecraft:random_spread";
    protected int placement_spacing = 96;
    protected int placement_separation = 64;
    protected int structure_weight = 1;
    protected int salt = 0;
    protected int exclusion_radius = 16;
    protected String exculision_structure = null;
    protected String structure_pool_fallback = "minecraft:empty";
    protected int structure_pool_weight = 1;
    protected String structure_projection = "rigid";
    protected ArrayList<JProcessor> processors = new ArrayList();

    protected StructureDataBuilder(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public static StructureDataBuilder create(@NotNull String name, @NotNull String type) {
        return new StructureDataBuilder(name, type);
    }

    public StructureDataBuilder structureWeight(int structure_weight) {
        this.structure_weight = structure_weight;
        return this;
    }

    public StructureDataBuilder salt(int salt) {
        this.salt = salt;
        return this;
    }

    public StructureDataBuilder placementType(String placement_type) {
        this.placement_type = placement_type;
        return this;
    }

    public StructureDataBuilder placementSpacing(int placement_spacing) {
        this.placement_spacing = placement_spacing;
        return this;
    }

    public StructureDataBuilder placementSeparation(int placement_separation) {
        this.placement_separation = placement_separation;
        return this;
    }

    public StructureDataBuilder exclusionRadius(int exclusion_radius) {
        this.exclusion_radius = exclusion_radius;
        return this;
    }

    public StructureDataBuilder exculisionStructure(String exculision_structure) {
        this.exculision_structure = exculision_structure;
        return this;
    }

    public StructureDataBuilder structurePoolFallback(String structure_pool_fallback) {
        this.structure_pool_fallback = structure_pool_fallback;
        return this;
    }

    public StructureDataBuilder structurePoolWeight(int structure_pool_weight) {
        this.structure_pool_weight = structure_pool_weight;
        return this;
    }

    public StructureDataBuilder structureProjection(String structure_projection) {
        this.structure_projection = structure_projection;
        return this;
    }

    public StructureDataBuilder structureStep(String structure_step) {
        this.structure_step = structure_step;
        return this;
    }

    public StructureDataBuilder structureBiomeID(class_2960 structureBiomeID) {
        this.structureBiomeID = structureBiomeID;
        return this;
    }

    public StructureDataBuilder addProcessor(JProcessor processor) {
        return this.addProcessors(processor);
    }

    public StructureDataBuilder addProcessors(JProcessor ... processors) {
        this.processors.addAll(Arrays.asList(processors));
        return this;
    }

    public StructureDataBuilder terrainAdaptation(String terrain_adaptation) {
        this.terrain_adaptation = terrain_adaptation;
        return this;
    }

    public StructureDataBuilder startHeight(int start_height) {
        this.start_height = start_height;
        return this;
    }

    public StructureDataBuilder projectStartToHeightmap(String project_start_to_heightmap) {
        this.project_start_to_heightmap = project_start_to_heightmap;
        return this;
    }

    public StructureDataBuilder structureSize(int structure_size) {
        this.structure_size = structure_size;
        return this;
    }

    public StructureDataBuilder maxDistanceFromCenter(int max_distance_from_center) {
        this.max_distance_from_center = max_distance_from_center;
        return this;
    }

    public StructureDataBuilder buildStructure(DatagenModContainer dataContainer) {
        if (this.name == null || this.type == null) {
            throw new IllegalStateException("Name or type is somehow null");
        }
        String nameId = dataContainer.getStringID(this.name);
        JsonObject structure = new JsonObject();
        if (this.structureBiomeID == null) {
            this.structureBiomeID = dataContainer.getSimpleID(this.name, "#has_structure");
        }
        structure.addProperty("start_pool", nameId);
        structure.addProperty("type", dataContainer.getStringID(this.type));
        structure.addProperty("biomes", this.structureBiomeID.toString());
        structure.addProperty("terrain_adaptation", this.terrain_adaptation);
        JsonObject start_height_json = new JsonObject();
        start_height_json.addProperty("absolute", (Number)this.start_height);
        structure.add("start_height", (JsonElement)start_height_json);
        structure.addProperty("project_start_to_heightmap", this.project_start_to_heightmap);
        structure.addProperty("size", (Number)this.structure_size);
        structure.addProperty("max_distance_from_center", (Number)this.max_distance_from_center);
        structure.addProperty("step", this.structure_step);
        structure.add("spawn_overrides", (JsonElement)new JsonObject());
        dataContainer.RESOURCE_PACK.addData(dataContainer.getSimpleID(this.name + ".json", "worldgen/structure"), SakuraJsonHelper.toPrettyBytes((JsonElement)structure));
        return this;
    }

    public StructureDataBuilder buildStructureSet(DatagenModContainer dataContainer) {
        if (this.name == null || this.type == null) {
            throw new IllegalStateException("Name or type is somehow null");
        }
        if (this.exclusion_radius < 1 || this.exclusion_radius > 16) {
            throw new IllegalStateException("Exclusion radius is not between 1 and 16");
        }
        String nameId = dataContainer.getStringID(this.name);
        if (this.salt <= 0) {
            this.salt = nameId.hashCode();
        }
        JsonObject structure_set = new JsonObject();
        structure_set.add("structures", (JsonElement)new JsonArray());
        JsonObject structureObj = new JsonObject();
        structureObj.addProperty("structure", nameId);
        structureObj.addProperty("weight", (Number)this.structure_weight);
        JsonObject placement = new JsonObject();
        placement.addProperty("type", this.placement_type);
        placement.addProperty("salt", (Number)this.salt);
        placement.addProperty("spacing", (Number)this.placement_spacing);
        placement.addProperty("separation", (Number)this.placement_separation);
        JsonObject exculsion = new JsonObject();
        exculsion.addProperty("chunk_count", (Number)this.exclusion_radius);
        exculsion.addProperty("other_set", this.exculision_structure);
        placement.add("exclusion_zone", (JsonElement)exculsion);
        structure_set.getAsJsonArray("structures").add((JsonElement)structureObj);
        structure_set.add("placement", (JsonElement)placement);
        dataContainer.RESOURCE_PACK.addData(dataContainer.getSimpleID(this.name + ".json", "worldgen/structure_set"), SakuraJsonHelper.toPrettyBytes((JsonElement)structure_set));
        return this;
    }

    public StructureDataBuilder buildStructurePool(DatagenModContainer dataContainer) {
        if (this.name == null || this.type == null) {
            throw new IllegalStateException("Name or type is somehow null");
        }
        JsonObject structure_pool = new JsonObject();
        JsonObject structureElement = new JsonObject();
        structureElement.addProperty("location", dataContainer.getStringID(this.name));
        structureElement.addProperty("projection", this.structure_projection);
        structureElement.addProperty("element_type", "minecraft:single_pool_element");
        JProcessor.addToResourcePack(dataContainer, this.name + "_processor", (JProcessor[])this.processors.toArray(JProcessor[]::new));
        structureElement.addProperty("processors", dataContainer.getStringID(this.name + "_processor"));
        JsonObject element = new JsonObject();
        element.addProperty("weight", (Number)this.structure_pool_weight);
        element.add("element", (JsonElement)structureElement);
        JsonArray elements = new JsonArray();
        elements.add((JsonElement)element);
        structure_pool.addProperty("fallback", this.structure_pool_fallback);
        structure_pool.add("elements", (JsonElement)elements);
        dataContainer.RESOURCE_PACK.addData(dataContainer.getSimpleID(this.name + ".json", "worldgen/template_pool"), SakuraJsonHelper.toPrettyBytes((JsonElement)structure_pool));
        return this;
    }
}

