/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.mixinsquared.selector;

import com.bawnorton.mixinsquared.TargetHandler;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.injection.selectors.ElementNode;
import org.spongepowered.asm.mixin.injection.selectors.ISelectorContext;
import org.spongepowered.asm.mixin.injection.selectors.ITargetSelector;
import org.spongepowered.asm.mixin.injection.selectors.ITargetSelectorDynamic;
import org.spongepowered.asm.mixin.injection.selectors.InvalidSelectorException;
import org.spongepowered.asm.mixin.injection.selectors.MatchResult;
import org.spongepowered.asm.mixin.transformer.meta.MixinMerged;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.asm.util.asm.IAnnotatedElement;
import org.spongepowered.asm.util.asm.MethodNodeEx;

@ITargetSelectorDynamic.SelectorId(value="Handler")
public final class DynamicSelectorHandler
implements ITargetSelectorDynamic {
    private final String mixinName;
    private final String name;
    private final String prefix;
    private final boolean print;
    private final PrettyPrinter printer = new PrettyPrinter();

    public DynamicSelectorHandler(String mixinName, String name, String prefix, boolean print) {
        this.mixinName = mixinName;
        this.name = name;
        this.prefix = prefix == null ? null : (prefix.isEmpty() ? null : prefix);
        this.print = print;
    }

    public static DynamicSelectorHandler parse(String input, ISelectorContext context) {
        AnnotationNode annotationNode;
        if (context.getMethod() instanceof MethodNode) {
            MethodNode method = (MethodNode)context.getMethod();
            annotationNode = Annotations.getVisible((MethodNode)method, TargetHandler.class);
        } else if (context.getMethod() instanceof IAnnotatedElement) {
            IAnnotatedElement element = (IAnnotatedElement)context.getMethod();
            annotationNode = (AnnotationNode)element.getAnnotation(TargetHandler.class).getValue();
        } else {
            throw new AssertionError((Object)"Could not get annotation for method");
        }
        return new DynamicSelectorHandler((String)Annotations.getValue((AnnotationNode)annotationNode, (String)"mixin"), (String)Annotations.getValue((AnnotationNode)annotationNode, (String)"name"), (String)Annotations.getValue((AnnotationNode)annotationNode, (String)"prefix", (Object)""), (Boolean)Annotations.getValue((AnnotationNode)annotationNode, (String)"print", (Object)Boolean.FALSE));
    }

    public ITargetSelector next() {
        return null;
    }

    public ITargetSelector configure(ITargetSelector.Configure request, String ... args) {
        return this;
    }

    public ITargetSelector validate() throws InvalidSelectorException {
        return this;
    }

    public ITargetSelector attach(ISelectorContext context) throws InvalidSelectorException {
        if (context.getMixin().getClassName().equals(this.mixinName)) {
            throw new InvalidSelectorException("Dynamic selector targets self!");
        }
        if (this.print) {
            this.printer.kvWidth(20).kv("Mixin", (Object)this.mixinName).kv("Name", (Object)this.name).kv("Prefix", (Object)this.prefix).add("%100s %-15s %-50s %s", new Object[]{"MIXIN", "PREFIX", "ORIGINAL NAME", "CANDIDATE"}).print(System.err);
        }
        return this;
    }

    public int getMinMatchCount() {
        return 0;
    }

    public int getMaxMatchCount() {
        return 1;
    }

    public <TNode> MatchResult match(ElementNode<TNode> node) {
        MethodNode method = node.getMethod();
        AnnotationNode annotation = Annotations.getVisible((MethodNode)method, MixinMerged.class);
        if (annotation == null) {
            return MatchResult.NONE;
        }
        if (!(method instanceof MethodNodeEx)) {
            return MatchResult.NONE;
        }
        MethodNodeEx methodNodeEx = (MethodNodeEx)method;
        String targetMixinName = (String)Annotations.getValue((AnnotationNode)annotation, (String)"mixin");
        MatchResult result = this.matchInternal(targetMixinName, methodNodeEx);
        if (this.print) {
            System.err.printf("/* %100s %-15s %-50s %9s */\n", targetMixinName, method.name.split("\\$")[0], methodNodeEx.getOriginalName(), result.isExactMatch() ? "YES" : "-");
        }
        return result;
    }

    private MatchResult matchInternal(String targetMixinName, MethodNodeEx method) {
        String methodPrefix;
        if (!this.mixinName.equals(targetMixinName)) {
            return MatchResult.NONE;
        }
        if (this.prefix != null && !(methodPrefix = method.name.split("\\$")[0]).equalsIgnoreCase(this.prefix)) {
            return MatchResult.NONE;
        }
        if (method.getOriginalName().equals(this.name)) {
            return MatchResult.EXACT_MATCH;
        }
        if (method.getOriginalName().equalsIgnoreCase(this.name)) {
            return MatchResult.MATCH;
        }
        return MatchResult.NONE;
    }

    public String toString() {
        return "@MixinSquared:Handler[mixin='" + this.mixinName + '\'' + ", name='" + this.name + '\'' + ", prefix='" + this.prefix + '\'' + ']';
    }
}

