/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.noindium;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import me.luligabi.noindium.ModConfig;
import me.luligabi.noindium.NoIndiumWarningScreen;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class NoIndium
implements ClientModInitializer {
    public static final boolean HAS_SODIUM = FabricLoader.getInstance().isModLoaded("sodium") && !FabricLoader.getInstance().isModLoaded("indium");
    public static final boolean HAS_OPTIFABRIC = FabricLoader.getInstance().isModLoaded("optifabric");
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"No Indium?");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(String.format("%s%snoindium.json", FabricLoader.getInstance().getConfigDir(), File.separator));
    public static final ModConfig CONFIG = NoIndium.createConfig();

    public void onInitializeClient() {
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            if (HAS_SODIUM && NoIndium.CONFIG.showIndiumScreen || HAS_OPTIFABRIC && NoIndium.CONFIG.showOptifabricScreen) {
                client.method_1507((class_437)new NoIndiumWarningScreen());
            }
        });
    }

    private static ModConfig createConfig() {
        ModConfig finalConfig;
        LOGGER.info("Trying to read config file...");
        try {
            if (CONFIG_FILE.createNewFile()) {
                LOGGER.info("No config file found, creating a new one...");
                Gson gson = GSON;
                NoIndium.writeConfig(gson.toJson(JsonParser.parseString((String)gson.toJson((Object)new ModConfig()))));
                finalConfig = new ModConfig();
                LOGGER.info("Successfully created default config file.");
            } else {
                LOGGER.info("A config file was found, loading it..");
                finalConfig = (ModConfig)GSON.fromJson(new String(Files.readAllBytes(CONFIG_FILE.toPath())), ModConfig.class);
                if (finalConfig == null) {
                    throw new NullPointerException("The config file was empty.");
                }
                LOGGER.info("Successfully loaded config file.");
            }
        }
        catch (Exception e) {
            LOGGER.error("There was an error creating/loading the config file!", (Throwable)e);
            finalConfig = new ModConfig();
            LOGGER.warn("Defaulting to original config.");
        }
        return finalConfig;
    }

    public static void saveConfig(ModConfig modConfig) {
        try {
            Gson gson = GSON;
            NoIndium.writeConfig(gson.toJson(JsonParser.parseString((String)gson.toJson((Object)modConfig))));
            LOGGER.info("Saved new config file.");
            return;
        }
        catch (Exception e) {
            LOGGER.error("There was an error saving the config file!", (Throwable)e);
            return;
        }
    }

    private static void writeConfig(String json) {
        try (PrintWriter printWriter = new PrintWriter(CONFIG_FILE);){
            printWriter.write(json);
            printWriter.flush();
        }
        catch (IOException e) {
            LOGGER.error("Failed to write config file", (Throwable)e);
        }
    }
}

