/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.mm;

import com.chocohead.mm.EnumSubclasser;
import com.chocohead.mm.api.ClassTinkerers;
import com.chocohead.mm.api.EnumAdder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class EnumExtender {
    public static final Map<String, Object[]> POOL = new HashMap<String, Object[]>();

    static Consumer<ClassNode> makeEnumExtender(EnumAdder builder) {
        return node -> {
            Supplier<String> anonymousClassFactory;
            int currentOrdinal;
            AbstractInsnNode fieldsSet;
            AbstractInsnNode newArray;
            AbstractInsnNode setValues;
            MethodNode arrayCreation;
            MethodNode clinit;
            block51: {
                block52: {
                    block50: {
                        if ((node.access & 0x4000) != 16384) {
                            throw new IllegalStateException("Tried to add enum entries to a non-enum type " + node.name);
                        }
                        String valuesField = null;
                        block22: for (Object method : node.methods) {
                            if (!"values".equals(((MethodNode)method).name) || !("()[L" + node.name + ';').equals(((MethodNode)method).desc)) continue;
                            for (AbstractInsnNode insn : ((MethodNode)method).instructions) {
                                if (insn.getType() != 4) continue;
                                valuesField = ((FieldInsnNode)insn).name;
                                break block22;
                            }
                            throw new IllegalStateException("Unable to find values field in " + node.name + '#' + ((MethodNode)method).name + ((MethodNode)method).desc);
                        }
                        if (valuesField == null) {
                            throw new IllegalStateException("Unable to find " + node.name + "#values()[L" + node.name + ';');
                        }
                        clinit = null;
                        for (MethodNode method : node.methods) {
                            if (!"<clinit>".equals(method.name) || !"()V".equals(method.desc)) continue;
                            clinit = method;
                            break;
                        }
                        if (clinit == null) {
                            throw new IllegalStateException("Unable to find " + node.name + "'s static block");
                        }
                        arrayCreation = clinit;
                        setValues = null;
                        newArray = null;
                        fieldsSet = null;
                        ListIterator it = clinit.instructions.iterator();
                        block25: while (it.hasNext()) {
                            AbstractInsnNode insn;
                            block48: {
                                insn = (AbstractInsnNode)it.next();
                                if (insn.getType() != 4 || insn.getOpcode() != 179 || !valuesField.equals(((FieldInsnNode)insn).name)) continue;
                                setValues = insn;
                                if (insn.getPrevious().getType() == 5) {
                                    MethodInsnNode minsn = (MethodInsnNode)insn.getPrevious();
                                    if (!node.name.equals(minsn.owner) || !minsn.desc.endsWith(")[L" + node.name + ';')) {
                                        throw new IllegalStateException("Unexpected $VALUES array creator: " + minsn.owner + '#' + minsn.name + minsn.desc);
                                    }
                                    for (MethodNode method : node.methods) {
                                        if (!minsn.name.equals(method.name) || !minsn.desc.equals(method.desc)) continue;
                                        arrayCreation = method;
                                        fieldsSet = minsn;
                                        it = method.instructions.iterator(method.instructions.size());
                                        insn = (AbstractInsnNode)it.previous();
                                        while (it.hasPrevious()) {
                                            if (insn.getType() == 0 && insn.getOpcode() == 176) {
                                                setValues = insn;
                                                break block48;
                                            }
                                            insn = (AbstractInsnNode)it.previous();
                                        }
                                        throw new IllegalStateException("$VALUES array creator " + minsn.owner + '#' + minsn.name + minsn.desc + " never returns?!");
                                    }
                                    throw new IllegalStateException("Unable to find $VALUES array creator: " + minsn.owner + '#' + minsn.name + minsn.desc);
                                }
                            }
                            insn = (AbstractInsnNode)it.previous();
                            while (it.hasPrevious()) {
                                if (insn.getType() == 3 && insn.getOpcode() == 189) {
                                    newArray = (AbstractInsnNode)it.previous();
                                    if (fieldsSet != null) break block25;
                                    fieldsSet = newArray;
                                    break block25;
                                }
                                insn = (AbstractInsnNode)it.previous();
                            }
                            throw new IllegalStateException("Unable to find $VALUES array creation point");
                        }
                        if (setValues == null) {
                            throw new IllegalStateException("Unable to find $VALUES array setting point");
                        }
                        if (newArray.getType() != 1) break block50;
                        currentOrdinal = ((IntInsnNode)newArray).operand;
                        break block51;
                    }
                    if (newArray.getType() != 0) break block52;
                    switch (newArray.getOpcode()) {
                        case 3: {
                            currentOrdinal = 0;
                            break block51;
                        }
                        case 4: {
                            currentOrdinal = 1;
                            break block51;
                        }
                        case 5: {
                            currentOrdinal = 2;
                            break block51;
                        }
                        case 6: {
                            currentOrdinal = 3;
                            break block51;
                        }
                        case 7: {
                            currentOrdinal = 4;
                            break block51;
                        }
                        case 8: {
                            currentOrdinal = 5;
                            break block51;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected Insn opcode: " + newArray.getOpcode());
                        }
                    }
                }
                throw new IllegalStateException("Unexpected newArray instruction type: " + newArray.getType() + " (" + newArray.getOpcode() + ')');
            }
            String constructor = EnumExtender.getConstructorDescriptor(builder.parameterTypes);
            if (builder.willSubclass()) {
                anonymousClassFactory = EnumExtender.anonymousClassFactory(node);
                node.access &= 0xFFFFFFEF;
                for (MethodNode method : node.methods) {
                    if (!"<init>".equals(method.name) || !constructor.equals(method.desc)) continue;
                    method.access &= 0xFFFFFFFD;
                    break;
                }
            } else {
                anonymousClassFactory = null;
            }
            InsnList fieldSetting = new InsnList();
            InsnList arrayFilling = new InsnList();
            for (EnumAdder.EnumAddition addition : builder.getAdditions()) {
                LabelNode stuffStart;
                node.visitField(16409, addition.name, 'L' + node.name + ';', null, null);
                if (builder.hasParameters()) {
                    String poolKey = builder.type + '#' + addition.name;
                    fieldSetting.add((AbstractInsnNode)new FieldInsnNode(178, "com/chocohead/mm/EnumExtender", "POOL", "Ljava/util/Map;"));
                    POOL.put(poolKey, addition.getParameters());
                    fieldSetting.add((AbstractInsnNode)new LdcInsnNode((Object)poolKey));
                    fieldSetting.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true));
                    fieldSetting.add((AbstractInsnNode)new TypeInsnNode(192, "[Ljava/lang/Object;"));
                    fieldSetting.add((AbstractInsnNode)new VarInsnNode(58, 0));
                    stuffStart = new LabelNode();
                    fieldSetting.add((AbstractInsnNode)stuffStart);
                } else {
                    stuffStart = null;
                }
                String additionType = addition.isEnumSubclass() ? anonymousClassFactory.get() : node.name;
                fieldSetting.add((AbstractInsnNode)new TypeInsnNode(187, additionType));
                fieldSetting.add((AbstractInsnNode)new InsnNode(89));
                fieldSetting.add((AbstractInsnNode)new LdcInsnNode((Object)addition.name));
                fieldSetting.add(EnumExtender.instructionForValue(currentOrdinal));
                block31: for (int i = 0; i < builder.parameterTypes.length; ++i) {
                    fieldSetting.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    fieldSetting.add(EnumExtender.instructionForValue(i));
                    fieldSetting.add((AbstractInsnNode)new InsnNode(50));
                    Type targetType = builder.parameterTypes[i];
                    switch (targetType.getSort()) {
                        case 5: {
                            fieldSetting.add((AbstractInsnNode)new TypeInsnNode(192, "java/lang/Integer"));
                            fieldSetting.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Integer", "intValue", "()I", false));
                            continue block31;
                        }
                        case 0: {
                            throw new AssertionError((Object)"Constructor takes a primitive void as a parameter?");
                        }
                        case 1: {
                            fieldSetting.add((AbstractInsnNode)new TypeInsnNode(192, "java/lang/Boolean"));
                            fieldSetting.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Boolean", "booleanValue", "()Z", false));
                            continue block31;
                        }
                        case 3: {
                            fieldSetting.add((AbstractInsnNode)new TypeInsnNode(192, "java/lang/Byte"));
                            fieldSetting.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Byte", "byteValue", "()B", false));
                            continue block31;
                        }
                        case 2: {
                            fieldSetting.add((AbstractInsnNode)new TypeInsnNode(192, "java/lang/Character"));
                            fieldSetting.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Character", "charValue", "()C", false));
                            continue block31;
                        }
                        case 4: {
                            fieldSetting.add((AbstractInsnNode)new TypeInsnNode(192, "java/lang/Short"));
                            fieldSetting.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Short", "shortValue", "()S", false));
                            continue block31;
                        }
                        case 8: {
                            fieldSetting.add((AbstractInsnNode)new TypeInsnNode(192, "java/lang/Double"));
                            fieldSetting.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Double", "doubleValue", "()D", false));
                            continue block31;
                        }
                        case 6: {
                            fieldSetting.add((AbstractInsnNode)new TypeInsnNode(192, "java/lang/Float"));
                            fieldSetting.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Float", "floatValue", "()F", false));
                            continue block31;
                        }
                        case 7: {
                            fieldSetting.add((AbstractInsnNode)new TypeInsnNode(192, "java/lang/Long"));
                            fieldSetting.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Long", "longValue", "()J", false));
                            continue block31;
                        }
                        case 10: {
                            if ("java/lang/Object".equals(targetType.getInternalName())) continue block31;
                        }
                        case 9: {
                            fieldSetting.add((AbstractInsnNode)new TypeInsnNode(192, targetType.getInternalName()));
                            continue block31;
                        }
                        case 11: {
                            throw new IllegalArgumentException("Tried to use method Type as a constructor argument");
                        }
                        default: {
                            throw new IllegalStateException("Unexpected target type sort: " + targetType.getSort() + " (" + targetType + ')');
                        }
                    }
                }
                fieldSetting.add((AbstractInsnNode)new MethodInsnNode(183, additionType, "<init>", constructor, false));
                fieldSetting.add((AbstractInsnNode)new FieldInsnNode(179, node.name, addition.name, 'L' + node.name + ';'));
                if (builder.hasParameters()) {
                    LabelNode stuffEnd = new LabelNode();
                    fieldSetting.add((AbstractInsnNode)stuffEnd);
                    assert (stuffStart != null);
                    clinit.localVariables.add(new LocalVariableNode("stuff", "[Ljava/lang/Object;", null, stuffStart, stuffEnd, 0));
                }
                if (addition.isEnumSubclass()) {
                    ClassTinkerers.define(additionType, EnumSubclasser.defineAnonymousSubclass(node, addition, additionType, constructor));
                    node.innerClasses.add(new InnerClassNode(additionType, node.name, additionType.substring(node.name.length() + 1), 16384));
                }
                arrayFilling.add((AbstractInsnNode)new InsnNode(89));
                arrayFilling.add(EnumExtender.instructionForValue(currentOrdinal++));
                arrayFilling.add((AbstractInsnNode)new FieldInsnNode(178, node.name, addition.name, 'L' + node.name + ';'));
                arrayFilling.add((AbstractInsnNode)new InsnNode(83));
            }
            clinit.instructions.insertBefore(fieldsSet, fieldSetting);
            clinit.instructions.insertBefore(setValues, arrayFilling);
            arrayCreation.instructions.set(newArray, EnumExtender.instructionForValue(currentOrdinal));
            if (builder.hasParameters()) {
                clinit.maxLocals = Math.max(clinit.maxLocals, 1);
            }
            clinit.maxStack = Math.max(clinit.maxStack, EnumExtender.getStackSize(builder.parameterTypes));
        };
    }

    private static String getConstructorDescriptor(Type[] parameters) {
        StringBuilder stringBuilder = new StringBuilder("(Ljava/lang/String;I");
        for (Type parameter : parameters) {
            stringBuilder.append(parameter.getDescriptor());
        }
        return stringBuilder.append(")V").toString();
    }

    private static Supplier<String> anonymousClassFactory(ClassNode target) {
        final String leadIn = target.name + '$';
        final HashSet<String> seenInners = new HashSet<String>();
        for (MethodNode method : target.methods) {
            block1: for (AbstractInsnNode insn : method.instructions) {
                String owner;
                if (insn.getType() != 5 || !(owner = ((MethodInsnNode)insn).owner).startsWith(leadIn)) continue;
                for (int i = leadIn.length(); i < owner.length(); ++i) {
                    char c = owner.charAt(i);
                    if ('0' > c || c > '9') continue block1;
                }
                seenInners.add(owner.substring(leadIn.length()));
            }
        }
        return new Supplier<String>(){
            private int last;
            {
                this.last = seenInners.stream().mapToInt(Integer::parseInt).max().orElse(0);
            }

            @Override
            public String get() {
                return leadIn + ++this.last;
            }
        };
    }

    private static int getStackSize(Type[] parameters) {
        int size = 4;
        switch (parameters.length) {
            case 0: {
                return size;
            }
            case 1: {
                assert (parameters[0].getSize() <= 2);
                return size + 1 + 1;
            }
        }
        int end = parameters.length - 1;
        for (int i = 0; i < end; ++i) {
            size += parameters[i].getSize();
        }
        assert (parameters[parameters.length - 1].getSize() <= 2);
        return size + 1 + 1;
    }

    private static AbstractInsnNode instructionForValue(int value) {
        switch (value) {
            case -1: {
                return new InsnNode(2);
            }
            case 0: {
                return new InsnNode(3);
            }
            case 1: {
                return new InsnNode(4);
            }
            case 2: {
                return new InsnNode(5);
            }
            case 3: {
                return new InsnNode(6);
            }
            case 4: {
                return new InsnNode(7);
            }
            case 5: {
                return new InsnNode(8);
            }
        }
        if (value >= -128 && value <= 127) {
            return new IntInsnNode(16, value);
        }
        if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            return new IntInsnNode(17, value);
        }
        return new LdcInsnNode((Object)value);
    }
}

