/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.transfer.v1.item.base;

import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1799;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public abstract class SingleStackStorage
extends SnapshotParticipant<class_1799>
implements SingleSlotStorage<ItemVariant> {
    protected abstract class_1799 getStack();

    protected abstract void setStack(class_1799 var1);

    protected boolean canInsert(ItemVariant itemVariant) {
        return true;
    }

    protected boolean canExtract(ItemVariant itemVariant) {
        return true;
    }

    protected int getCapacity(ItemVariant itemVariant) {
        return itemVariant.getItem().method_7882();
    }

    @Override
    public boolean isResourceBlank() {
        return this.getStack().method_7960();
    }

    @Override
    public ItemVariant getResource() {
        return ItemVariant.of(this.getStack());
    }

    @Override
    public long getAmount() {
        return this.getStack().method_7947();
    }

    @Override
    public long getCapacity() {
        return this.getCapacity(this.getResource());
    }

    @Override
    public long insert(ItemVariant insertedVariant, long maxAmount, TransactionContext transaction) {
        int insertedAmount;
        StoragePreconditions.notBlankNotNegative(insertedVariant, maxAmount);
        class_1799 currentStack = this.getStack();
        if ((insertedVariant.matches(currentStack) || currentStack.method_7960()) && this.canInsert(insertedVariant) && (insertedAmount = (int)Math.min(maxAmount, (long)(this.getCapacity(insertedVariant) - currentStack.method_7947()))) > 0) {
            this.updateSnapshots(transaction);
            currentStack = this.getStack();
            if (currentStack.method_7960()) {
                currentStack = insertedVariant.toStack(insertedAmount);
            } else {
                currentStack.method_7933(insertedAmount);
            }
            this.setStack(currentStack);
            return insertedAmount;
        }
        return 0L;
    }

    @Override
    public long extract(ItemVariant variant, long maxAmount, TransactionContext transaction) {
        int extracted;
        StoragePreconditions.notBlankNotNegative(variant, maxAmount);
        class_1799 currentStack = this.getStack();
        if (variant.matches(currentStack) && this.canExtract(variant) && (extracted = (int)Math.min((long)currentStack.method_7947(), maxAmount)) > 0) {
            this.updateSnapshots(transaction);
            currentStack = this.getStack();
            currentStack.method_7934(extracted);
            this.setStack(currentStack);
            return extracted;
        }
        return 0L;
    }

    @Override
    protected class_1799 createSnapshot() {
        class_1799 original = this.getStack();
        this.setStack(original.method_7972());
        return original;
    }

    @Override
    protected void readSnapshot(class_1799 snapshot) {
        this.setStack(snapshot);
    }

    public String toString() {
        return "SingleStackStorage[" + String.valueOf(this.getStack()) + "]";
    }
}

