/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.satin.impl;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Set;
import java.util.function.Consumer;
import ladysnake.satin.Satin;
import ladysnake.satin.api.event.ResolutionChangeCallback;
import ladysnake.satin.api.managed.ManagedCoreShader;
import ladysnake.satin.api.managed.ManagedShaderEffect;
import ladysnake.satin.api.managed.ShaderEffectManager;
import ladysnake.satin.impl.ResettableManagedCoreShader;
import ladysnake.satin.impl.ResettableManagedShaderBase;
import ladysnake.satin.impl.ResettableManagedShaderEffect;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_5912;

public final class ReloadableShaderEffectManager
implements ShaderEffectManager,
ResolutionChangeCallback {
    public static final ReloadableShaderEffectManager INSTANCE = new ReloadableShaderEffectManager();
    public static final class_2960 SHADER_RESOURCE_KEY = new class_2960("dissolution:shaders");
    private final Set<ResettableManagedShaderBase<?>> managedShaders = new ReferenceOpenHashSet();

    @Override
    public ManagedShaderEffect manage(class_2960 location) {
        return this.manage(location, s -> {});
    }

    @Override
    public ManagedShaderEffect manage(class_2960 location, Consumer<ManagedShaderEffect> initCallback) {
        ResettableManagedShaderEffect ret = new ResettableManagedShaderEffect(location, initCallback);
        this.managedShaders.add(ret);
        return ret;
    }

    @Override
    public ManagedCoreShader manageCoreShader(class_2960 location) {
        return this.manageCoreShader(location, class_290.field_1580);
    }

    @Override
    public ManagedCoreShader manageCoreShader(class_2960 location, class_293 vertexFormat) {
        return this.manageCoreShader(location, vertexFormat, s -> {});
    }

    @Override
    public ManagedCoreShader manageCoreShader(class_2960 location, class_293 vertexFormat, Consumer<ManagedCoreShader> initCallback) {
        ResettableManagedCoreShader ret = new ResettableManagedCoreShader(location, vertexFormat, initCallback);
        this.managedShaders.add(ret);
        return ret;
    }

    @Override
    public void dispose(ManagedShaderEffect shader) {
        shader.release();
        this.managedShaders.remove(shader);
    }

    @Override
    public void dispose(ManagedCoreShader shader) {
        shader.release();
        this.managedShaders.remove(shader);
    }

    public void reload(class_5912 shaderResources) {
        for (ResettableManagedShaderBase<?> ss : this.managedShaders) {
            ss.initializeOrLog(shaderResources);
        }
    }

    @Override
    public void onResolutionChanged(int newWidth, int newHeight) {
        if (!Satin.areShadersDisabled() && !this.managedShaders.isEmpty()) {
            for (ResettableManagedShaderBase<?> ss : this.managedShaders) {
                if (!ss.isInitialized()) continue;
                ss.setup(newWidth, newHeight);
            }
        }
    }
}

