/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.utils.fabric;

import com.lowdragmc.lowdraglib.LDLib;
import it.unimi.dsi.fastutil.Pair;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.apache.commons.io.file.AccumulatorPathVisitor;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.PathFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.spongepowered.asm.util.asm.ASM;

public class ReflectionUtilsImpl {
    private static final Map<Class<? extends Annotation>, List<Pair<Consumer<Class<?>>, Runnable>>> QUEUE = new HashMap();

    public static <A extends Annotation> void findAnnotationClasses(Class<A> annotationClass, Consumer<Class<?>> consumer, Runnable onFinished) {
        QUEUE.computeIfAbsent(annotationClass, a -> new ArrayList()).add(Pair.of(consumer, (Object)onFinished));
    }

    public static void execute() {
        LDLib.LOGGER.info("Start to search classes for notation: {}", QUEUE.keySet());
        ReflectionUtilsImpl.findAnnotationCandidates(QUEUE.keySet()).forEach((annotation, names) -> {
            for (String name : names) {
                try {
                    Class<?> clazz = Class.forName(name.replace("/", "."), false, ReflectionUtilsImpl.class.getClassLoader());
                    for (Pair<Consumer<Class<?>>, Runnable> consumer : QUEUE.get(annotation)) {
                        ((Consumer)consumer.left()).accept(clazz);
                    }
                }
                catch (Throwable throwable) {
                    LDLib.LOGGER.error("Failed to load class {} for notation {} ", new Object[]{name, annotation.getName(), throwable});
                }
            }
        });
        for (List<Pair<Consumer<Class<?>>, Runnable>> pairs : QUEUE.values()) {
            for (Pair<Consumer<Class<?>>, Runnable> pair : pairs) {
                ((Runnable)pair.right()).run();
            }
        }
        QUEUE.clear();
        LDLib.LOGGER.info("Finish searching for notation");
    }

    public static Map<Class<? extends Annotation>, Set<String>> findAnnotationCandidates(Set<Class<? extends Annotation>> annotationTypes) {
        HashMap<Class<? extends Annotation>, Set<String>> annotationCandidates = new HashMap<Class<? extends Annotation>, Set<String>>();
        for (ModContainer allMod : FabricLoader.getInstance().getAllMods()) {
            for (Path rootPath : allMod.getRootPaths()) {
                AccumulatorPathVisitor visitor = new AccumulatorPathVisitor(Counters.noopPathCounters(), (PathFilter)new RegexFileFilter(".*.class"), (PathFilter)TrueFileFilter.TRUE);
                try {
                    Files.walkFileTree(rootPath, (FileVisitor<? super Path>)visitor);
                }
                catch (IOException e) {
                    LDLib.LOGGER.warn("Failed to discover plugins from path: %s".formatted(rootPath), (Throwable)e);
                    continue;
                }
                List classFiles = visitor.getFileList();
                for (Path classFile : classFiles) {
                    ClassReader reader;
                    try {
                        reader = new ClassReader(Files.newInputStream(classFile, new OpenOption[0]));
                    }
                    catch (IOException e) {
                        LDLib.LOGGER.warn("Failed to read class for annotation detection: %s".formatted(classFile.toAbsolutePath()), (Throwable)e);
                        continue;
                    }
                    reader.accept((ClassVisitor)new AnnotationSearchingClassVisitor(annotationCandidates, annotationTypes), 7);
                }
            }
        }
        return annotationCandidates;
    }

    private static final class AnnotationSearchingClassVisitor
    extends ClassVisitor {
        private final Map<Class<? extends Annotation>, Set<String>> annotationCandidates;
        private final Map<String, Class<? extends Annotation>> annotationDescMap;
        private String name = "";

        public AnnotationSearchingClassVisitor(Map<Class<? extends Annotation>, Set<String>> annotationCandidates, Set<Class<? extends Annotation>> annotationTypes) {
            super(ASM.API_VERSION);
            this.annotationCandidates = annotationCandidates;
            this.annotationDescMap = new HashMap<String, Class<? extends Annotation>>();
            for (Class<? extends Annotation> annotationType : annotationTypes) {
                this.annotationDescMap.put(annotationType.descriptorString(), annotationType);
            }
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.name = name;
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (this.annotationDescMap.containsKey(descriptor)) {
                this.annotationCandidates.computeIfAbsent(this.annotationDescMap.get(descriptor), a -> new HashSet()).add(this.name);
            }
            return super.visitAnnotation(descriptor, visible);
        }
    }
}

