/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.utils;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.EntityInfo;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtils {
    public static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    @Nullable
    public static Document loadXml(InputStream inputstream) {
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(inputstream);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getAsInt(Element element, String name, int defaultValue) {
        if (element.hasAttribute(name)) {
            try {
                return Integer.parseInt(element.getAttribute(name));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static long getAsLong(Element element, String name, long defaultValue) {
        if (element.hasAttribute(name)) {
            try {
                return Long.parseLong(element.getAttribute(name));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static boolean getAsBoolean(Element element, String name, boolean defaultValue) {
        if (element.hasAttribute(name)) {
            try {
                return Boolean.parseBoolean(element.getAttribute(name));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static String getAsString(Element element, String name, String defaultValue) {
        if (element.hasAttribute(name)) {
            return element.getAttribute(name);
        }
        return defaultValue;
    }

    public static float getAsFloat(Element element, String name, float defaultValue) {
        if (element.hasAttribute(name)) {
            try {
                return Float.parseFloat(element.getAttribute(name));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static int getAsColor(Element element, String name, int defaultValue) {
        if (element.hasAttribute(name)) {
            try {
                int value = Long.decode(element.getAttribute(name)).intValue();
                if (value != 0 && (value & 0xFF000000) == 0) {
                    value |= 0xFF000000;
                }
                return value;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static class_2338 getAsBlockPos(Element element, String name, class_2338 defaultValue) {
        if (element.hasAttribute(name)) {
            String pos = XmlUtils.getAsString(element, name, "0 0 0");
            try {
                String[] s = pos.split(" ");
                return new class_2338(Integer.parseInt(s[0]), Integer.parseInt(s[1]), Integer.parseInt(s[2]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static <T extends Enum<T>> T getAsEnum(Element element, String name, Class<T> enumClass, T defaultValue) {
        if (element.hasAttribute(name)) {
            try {
                Enum[] values;
                String data = element.getAttribute(name);
                for (Enum value : values = (Enum[])enumClass.getEnumConstants()) {
                    if (!value.name().equals(data)) continue;
                    return (T)value;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static class_2487 getCompoundTag(Element element) {
        NodeList nodeList = element.getChildNodes();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String text = node.getTextContent().replaceAll("\\h*\\R+\\h*", " ");
            if (!text.isEmpty() && text.charAt(0) == ' ') {
                text = text.substring(1);
            }
            builder.append(text);
        }
        if (!builder.isEmpty()) {
            try {
                return class_2522.method_10718((String)builder.toString());
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return new class_2487();
    }

    public static class_1799 getItemStack(Element element) {
        SizedIngredient ingredient = XmlUtils.getIngredient(element);
        if (ingredient.ingredient.method_8105().length > 0) {
            class_1799 stack = ingredient.ingredient.method_8105()[0];
            stack.method_7939(ingredient.count);
            return stack;
        }
        return class_1799.field_8037;
    }

    public static class_243 getAsVec3(Element element, String name, class_243 defaultValue) {
        if (element.hasAttribute(name)) {
            String pos = XmlUtils.getAsString(element, name, "0 0 0");
            try {
                String[] s = pos.split(" ");
                return new class_243((double)Float.parseFloat(s[0]), (double)Float.parseFloat(s[1]), (double)Float.parseFloat(s[2]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static class_241 getAsVec2(Element element, String name, class_241 defaultValue) {
        if (element.hasAttribute(name)) {
            String pos = XmlUtils.getAsString(element, name, "0 0");
            try {
                String[] s = pos.split(" ");
                return new class_241(Float.parseFloat(s[0]), Float.parseFloat(s[1]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static EntityInfo getEntityInfo(Element element) {
        int id = XmlUtils.getAsInt(element, "id", LDLib.random.nextInt());
        class_1299 entityType = null;
        if (element.hasAttribute("type")) {
            entityType = (class_1299)class_7923.field_41177.method_10223(new class_2960(element.getAttribute("type")));
        }
        class_2487 tag = null;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element subElement;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(subElement = (Element)node).getNodeName().equals("nbt")) continue;
            tag = XmlUtils.getCompoundTag(subElement);
            break;
        }
        return new EntityInfo(id, entityType, tag);
    }

    public static SizedIngredient getIngredient(Element element) {
        int count = XmlUtils.getAsInt(element, "count", 1);
        SizedIngredient ingredient = new SizedIngredient(class_1856.field_9017, 0);
        if (element.hasAttribute("item")) {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(element.getAttribute("item")));
            if (item != class_1802.field_8162) {
                class_1799 itemStack = new class_1799((class_1935)item, count);
                NodeList nodeList = element.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element subElement;
                    Node node = nodeList.item(i);
                    if (!(node instanceof Element) || !(subElement = (Element)node).getNodeName().equals("nbt")) continue;
                    itemStack.method_7980(XmlUtils.getCompoundTag(subElement));
                    break;
                }
                ingredient = new SizedIngredient(class_1856.method_8101((class_1799[])new class_1799[]{itemStack}), count);
            }
        } else if (Platform.isForge() && element.hasAttribute("forge-tag")) {
            ingredient = new SizedIngredient(class_1856.method_8106((class_6862)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960(element.getAttribute("forge-tag")))), count);
        } else if (!Platform.isForge() && element.hasAttribute("fabric-tag")) {
            ingredient = new SizedIngredient(class_1856.method_8106((class_6862)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960(element.getAttribute("fabric-tag")))), count);
        } else if (element.hasAttribute("tag")) {
            ingredient = new SizedIngredient(class_1856.method_8106((class_6862)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960(element.getAttribute("tag")))), count);
        }
        return ingredient;
    }

    public static FluidStack getFluidStack(Element element) {
        class_3611 fluid;
        long amount = XmlUtils.getAsLong(element, "amount", 1L) * FluidHelper.getBucket() / 1000L;
        FluidStack fluidStack = FluidStack.empty();
        if (element.hasAttribute("fluid") && (fluid = (class_3611)class_7923.field_41173.method_10223(new class_2960(element.getAttribute("fluid")))) != class_3612.field_15906) {
            fluidStack = FluidStack.create(fluid, amount);
            NodeList nodeList = element.getChildNodes();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                String text = node.getTextContent().replaceAll("\\h*\\R+\\h*", " ");
                if (!text.isEmpty() && text.charAt(0) == ' ') {
                    text = text.substring(1);
                }
                builder.append(text);
            }
            if (!builder.isEmpty()) {
                try {
                    fluidStack.setTag(class_2522.method_10718((String)builder.toString()));
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
        }
        return fluidStack;
    }

    public static BlockInfo getBlockInfo(Element element) {
        class_2248 block;
        BlockInfo blockInfo = BlockInfo.EMPTY;
        if (element.hasAttribute("block") && (block = (class_2248)class_7923.field_41175.method_10223(new class_2960(element.getAttribute("block")))) != class_2246.field_10124) {
            class_2680 blockState = block.method_9564();
            NodeList nodeList = element.getChildNodes();
            class_2487 tag = new class_2487();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                Element subElement = (Element)node;
                if (subElement.getNodeName().equals("properties")) {
                    blockState = XmlUtils.setBlockState(blockState, subElement);
                    continue;
                }
                if (!subElement.getNodeName().equals("nbt")) continue;
                tag = XmlUtils.getCompoundTag(subElement);
            }
            blockInfo = BlockInfo.fromBlockState(blockState);
            if (!tag.method_33133()) {
                blockInfo.setTag(tag);
            }
        }
        return blockInfo;
    }

    public static class_2680 setBlockState(class_2680 blockState, Element element) {
        class_2769 property;
        class_2689 stateDefinition = blockState.method_26204().method_9595();
        String name = XmlUtils.getAsString(element, "name", "");
        String value = XmlUtils.getAsString(element, "value", "");
        if (!name.isEmpty() && (property = stateDefinition.method_11663(name)) != null) {
            blockState = XmlUtils.setValueHelper(blockState, property, value);
        }
        return blockState;
    }

    private static class_2680 setValueHelper(class_2680 stateHolder, class_2769 property, String value) {
        Optional optional = property.method_11900(value);
        if (optional.isPresent()) {
            return (class_2680)stateHolder.method_11657(property, (Comparable)optional.get());
        }
        return stateHolder;
    }

    public static String getContent(Element element, boolean pretty) {
        NodeList nodeList = element.getChildNodes();
        StringBuilder builder = new StringBuilder();
        boolean lastNodeIsText = false;
        block8: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                String text = node.getTextContent();
                if (pretty) {
                    text = text.replaceAll("\\h*\\R+\\h*", " ");
                }
                if (!lastNodeIsText && !text.isEmpty() && text.charAt(0) == ' ') {
                    text = text.substring(1);
                }
                builder.append(text);
                lastNodeIsText = false;
                continue;
            }
            if (!(node instanceof Element)) continue;
            Element nodeElement = (Element)node;
            String nodeName = nodeElement.getNodeName();
            lastNodeIsText = false;
            switch (nodeName) {
                case "lang": {
                    String key = XmlUtils.getAsString(nodeElement, "key", "");
                    builder.append(LocalizationUtils.format(key, new Object[0]));
                    lastNodeIsText = true;
                    continue block8;
                }
                case "br": {
                    builder.append('\n');
                }
            }
        }
        return builder.toString();
    }

    public static List<class_5250> getComponents(Element element, class_2583 style) {
        NodeList nodeList = element.getChildNodes();
        ArrayList<class_5250> results = new ArrayList<class_5250>();
        class_5250 component = null;
        block10: for (int i = 0; i < nodeList.getLength(); ++i) {
            String nodeName;
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                String text = node.getTextContent();
                text = text.replaceAll("\\h*\\R+\\h*", " ");
                if (component == null) {
                    component = class_2561.method_43470((String)text).method_27696(style);
                    continue;
                }
                component = component.method_10852((class_2561)class_2561.method_43470((String)text).method_27696(style));
                continue;
            }
            if (!(node instanceof Element)) continue;
            Element nodeElement = (Element)node;
            switch (nodeName = nodeElement.getNodeName()) {
                case "lang": {
                    String key = XmlUtils.getAsString(nodeElement, "key", "");
                    if (component == null) {
                        component = class_2561.method_43471((String)key).method_27696(style);
                        continue block10;
                    }
                    component = component.method_10852((class_2561)class_2561.method_43471((String)key).method_27696(style));
                    continue block10;
                }
                case "br": {
                    results.add(Objects.requireNonNullElseGet(component, class_2561::method_43473));
                    component = class_2561.method_43473();
                    continue block10;
                }
                case "style": {
                    class_2583 newStyle = style.method_27703(style.method_10973());
                    if (nodeElement.hasAttribute("color")) {
                        newStyle = newStyle.method_36139(XmlUtils.getAsColor(nodeElement, "color", -1));
                    }
                    if (nodeElement.hasAttribute("bold")) {
                        newStyle = newStyle.method_10982(Boolean.valueOf(XmlUtils.getAsBoolean(nodeElement, "bold", true)));
                    }
                    if (nodeElement.hasAttribute("font")) {
                        newStyle = newStyle.method_27704(new class_2960(nodeElement.getAttribute("font")));
                    }
                    if (nodeElement.hasAttribute("italic")) {
                        newStyle = newStyle.method_10978(Boolean.valueOf(XmlUtils.getAsBoolean(nodeElement, "italic", true)));
                    }
                    if (nodeElement.hasAttribute("underlined")) {
                        newStyle = newStyle.method_30938(Boolean.valueOf(XmlUtils.getAsBoolean(nodeElement, "underlined", true)));
                    }
                    if (nodeElement.hasAttribute("strikethrough")) {
                        newStyle = newStyle.method_36140(Boolean.valueOf(XmlUtils.getAsBoolean(nodeElement, "strikethrough", true)));
                    }
                    if (nodeElement.hasAttribute("obfuscated")) {
                        newStyle = newStyle.method_36141(Boolean.valueOf(XmlUtils.getAsBoolean(nodeElement, "obfuscated", true)));
                    }
                    if (nodeElement.hasAttribute("hover-info")) {
                        newStyle = newStyle.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)nodeElement.getAttribute("hover-info"))));
                    }
                    if (nodeElement.hasAttribute("link")) {
                        newStyle = newStyle.method_10958(new class_2558(class_2558.class_2559.field_11749, "@!" + nodeElement.getAttribute("link")));
                    }
                    if (nodeElement.hasAttribute("url-link")) {
                        newStyle = newStyle.method_10958(new class_2558(class_2558.class_2559.field_11749, "@#" + nodeElement.getAttribute("url-link")));
                    }
                    List<class_5250> components = XmlUtils.getComponents(nodeElement, newStyle);
                    for (int j = 0; j < components.size(); ++j) {
                        if (j == 0) {
                            if (component != null) {
                                component.method_10852((class_2561)components.get(j));
                                continue;
                            }
                            component = components.get(j);
                            continue;
                        }
                        results.add(component);
                        component = components.get(j);
                    }
                    continue block10;
                }
            }
        }
        if (component != null) {
            results.add(component);
        }
        return results;
    }

    public record SizedIngredient(class_1856 ingredient, int count) {
    }
}

