/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.utils;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.scene.ParticleManager;
import com.lowdragmc.lowdraglib.core.mixins.accessor.EntityAccessor;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.DummyWorld;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_1533;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2802;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_5558;
import net.minecraft.class_5577;
import net.minecraft.class_6328;
import net.minecraft.class_6539;
import net.minecraft.class_6880;
import org.joml.Vector3f;

@ParametersAreNonnullByDefault
@class_6328
public class TrackedDummyWorld
extends DummyWorld {
    private Predicate<class_2338> renderFilter;
    public final class_1937 proxyWorld;
    public final Map<class_2338, BlockInfo> renderedBlocks = new HashMap<class_2338, BlockInfo>();
    public final Map<class_2338, class_2586> blockEntities = new HashMap<class_2338, class_2586>();
    public final Map<Integer, class_1297> entities = new Int2ObjectArrayMap();
    public final Vector3f minPos = new Vector3f(2.1474836E9f, 2.1474836E9f, 2.1474836E9f);
    public final Vector3f maxPos = new Vector3f(-2.1474836E9f, -2.1474836E9f, -2.1474836E9f);

    public void setRenderFilter(Predicate<class_2338> renderFilter) {
        this.renderFilter = renderFilter;
    }

    public TrackedDummyWorld() {
        super((class_1937)class_310.method_1551().field_1687);
        this.proxyWorld = null;
    }

    public TrackedDummyWorld(class_1937 world) {
        super(world);
        this.proxyWorld = world;
    }

    public void clear() {
        this.renderedBlocks.clear();
        this.blockEntities.clear();
        this.entities.clear();
    }

    public Map<class_2338, BlockInfo> getRenderedBlocks() {
        return this.renderedBlocks;
    }

    public void addBlocks(Map<class_2338, BlockInfo> renderedBlocks) {
        renderedBlocks.forEach(this::addBlock);
    }

    public void addBlock(class_2338 pos, BlockInfo blockInfo) {
        if (blockInfo.getBlockState().method_26204() == class_2246.field_10124) {
            return;
        }
        this.renderedBlocks.put(pos, blockInfo);
        this.blockEntities.remove(pos);
        this.minPos.x = Math.min(this.minPos.x, (float)pos.method_10263());
        this.minPos.y = Math.min(this.minPos.y, (float)pos.method_10264());
        this.minPos.z = Math.min(this.minPos.z, (float)pos.method_10260());
        this.maxPos.x = Math.max(this.maxPos.x, (float)pos.method_10263());
        this.maxPos.y = Math.max(this.maxPos.y, (float)pos.method_10264());
        this.maxPos.z = Math.max(this.maxPos.z, (float)pos.method_10260());
    }

    public BlockInfo removeBlock(class_2338 pos) {
        this.blockEntities.remove(pos);
        return this.renderedBlocks.remove(pos);
    }

    public void setInnerBlockEntity(@Nonnull class_2586 pBlockEntity) {
        this.blockEntities.put(pBlockEntity.method_11016(), pBlockEntity);
    }

    @Override
    public void method_8438(@Nonnull class_2586 pBlockEntity) {
        this.blockEntities.put(pBlockEntity.method_11016(), pBlockEntity);
    }

    @Override
    public boolean method_30092(@Nonnull class_2338 pos, @Nonnull class_2680 state, int a, int b) {
        this.renderedBlocks.put(pos, BlockInfo.fromBlockState(state));
        this.blockEntities.remove(pos);
        return true;
    }

    @Override
    public class_2586 method_8321(@Nonnull class_2338 pos) {
        if (this.renderFilter != null && !this.renderFilter.test(pos)) {
            return null;
        }
        return this.proxyWorld != null ? this.proxyWorld.method_8321(pos) : this.blockEntities.computeIfAbsent(pos, p -> this.renderedBlocks.getOrDefault(p, BlockInfo.EMPTY).getBlockEntity(this, (class_2338)p));
    }

    @Override
    public class_2680 method_8320(@Nonnull class_2338 pos) {
        if (this.renderFilter != null && !this.renderFilter.test(pos)) {
            return class_2246.field_10124.method_9564();
        }
        return this.proxyWorld != null ? this.proxyWorld.method_8320(pos) : this.renderedBlocks.getOrDefault(pos, BlockInfo.EMPTY).getBlockState();
    }

    public boolean method_8649(class_1297 entity) {
        ((EntityAccessor)entity).invokeSetLevel(this);
        if (entity instanceof class_1533) {
            class_1533 itemFrame = (class_1533)entity;
            itemFrame.method_6935(TrackedDummyWorld.withUnsafeNBTDiscarded(itemFrame.method_6940()));
        }
        if (entity instanceof class_1531) {
            class_1531 armorStand = (class_1531)entity;
            for (class_1304 equipmentSlot : class_1304.values()) {
                armorStand.method_5673(equipmentSlot, TrackedDummyWorld.withUnsafeNBTDiscarded(armorStand.method_6118(equipmentSlot)));
            }
        }
        this.entities.put(entity.method_5628(), entity);
        return true;
    }

    public static class_1799 withUnsafeNBTDiscarded(class_1799 stack) {
        if (stack.method_7969() == null) {
            return stack;
        }
        class_1799 copy = stack.method_7972();
        stack.method_7969().method_10541().stream().filter(TrackedDummyWorld::isUnsafeItemNBTKey).forEach(arg_0 -> ((class_1799)copy).method_7983(arg_0));
        if (copy.method_7969().method_33133()) {
            copy.method_7980(null);
        }
        return copy;
    }

    public static boolean isUnsafeItemNBTKey(String name) {
        if (name.equals("StoredEnchantments")) {
            return false;
        }
        if (name.equals("Enchantments")) {
            return false;
        }
        if (name.contains("Potion")) {
            return false;
        }
        if (name.contains("Damage")) {
            return false;
        }
        return !name.equals("display");
    }

    @Override
    protected class_5577<class_1297> method_31592() {
        return super.method_31592();
    }

    @Override
    public class_1297 method_8469(int id) {
        for (class_1297 entity : this.entities.values()) {
            if (entity.method_5628() != id || !entity.method_5805()) continue;
            return entity;
        }
        return super.method_8469(id);
    }

    public Vector3f getSize() {
        return new Vector3f(this.maxPos.x - this.minPos.x + 1.0f, this.maxPos.y - this.minPos.y + 1.0f, this.maxPos.z - this.minPos.z + 1.0f);
    }

    public Vector3f getMinPos() {
        return this.minPos;
    }

    public Vector3f getMaxPos() {
        return this.maxPos;
    }

    @Override
    public class_2802 method_8398() {
        return this.proxyWorld == null ? super.method_8398() : this.proxyWorld.method_8398();
    }

    @Override
    public class_3610 method_8316(class_2338 pPos) {
        return this.proxyWorld == null ? super.method_8316(pPos) : this.proxyWorld.method_8316(pPos);
    }

    public int method_23752(@Nonnull class_2338 blockPos, @Nonnull class_6539 colorResolver) {
        return this.proxyWorld == null ? super.method_23752(blockPos, colorResolver) : this.proxyWorld.method_23752(blockPos, colorResolver);
    }

    @Override
    @Nonnull
    public class_6880<class_1959> method_23753(@Nonnull class_2338 pos) {
        return this.proxyWorld == null ? super.method_23753(pos) : this.proxyWorld.method_23753(pos);
    }

    @Override
    public void setParticleManager(ParticleManager particleManager) {
        super.setParticleManager(particleManager);
        class_1937 class_19372 = this.proxyWorld;
        if (class_19372 instanceof DummyWorld) {
            DummyWorld dummyWorld = (DummyWorld)class_19372;
            dummyWorld.setParticleManager(particleManager);
        }
    }

    @Override
    @Nullable
    public ParticleManager getParticleManager() {
        class_1937 class_19372;
        ParticleManager particleManager = super.getParticleManager();
        if (particleManager == null && (class_19372 = this.proxyWorld) instanceof DummyWorld) {
            DummyWorld dummyWorld = (DummyWorld)class_19372;
            return dummyWorld.getParticleManager();
        }
        return particleManager;
    }

    public void tickWorld() {
        Iterator<class_1297> iter = this.entities.values().iterator();
        while (iter.hasNext()) {
            class_1297 entity = iter.next();
            ++entity.field_6012;
            entity.method_22862();
            entity.method_5773();
            if (entity.method_23318() <= -0.5) {
                entity.method_31472();
            }
            if (entity.method_5805()) continue;
            iter.remove();
        }
        for (Map.Entry<class_2338, BlockInfo> entry : this.renderedBlocks.entrySet()) {
            class_2680 blockState = entry.getValue().getBlockState();
            class_2586 blockEntity = this.method_8321(entry.getKey());
            if (blockEntity == null || !blockEntity.method_11017().method_20526(blockState)) continue;
            try {
                class_5558 ticker = blockState.method_31708((class_1937)this, blockEntity.method_11017());
                if (ticker == null) continue;
                ticker.tick((class_1937)this, entry.getKey(), blockState, blockEntity);
            }
            catch (Exception e) {
                LDLib.LOGGER.error("error while update DummyWorld tick, pos {} type {}", new Object[]{entry.getKey(), blockEntity.method_11017(), e});
            }
        }
    }

    public List<class_1297> geAllEntities() {
        ArrayList<class_1297> entities = new ArrayList<class_1297>(this.entities.values());
        class_1937 class_19372 = this.proxyWorld;
        if (class_19372 instanceof TrackedDummyWorld) {
            TrackedDummyWorld trackedDummyWorld = (TrackedDummyWorld)class_19372;
            entities.addAll(trackedDummyWorld.geAllEntities());
        }
        return entities;
    }
}

