/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.utils;

import com.lowdragmc.lowdraglib.utils.FacadeBlockAndTintGetter;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class BlockInfo {
    public static final BlockInfo EMPTY = new BlockInfo(class_2246.field_10124);
    private class_2680 blockState;
    private class_2487 tag;
    private boolean hasBlockEntity;
    private final class_1799 itemStack;
    private class_2586 lastEntity;
    private final Consumer<class_2586> postCreate;

    public BlockInfo(class_2248 block) {
        this(block.method_9564());
    }

    public BlockInfo(class_2680 blockState) {
        this(blockState, false);
    }

    public BlockInfo(class_2680 blockState, boolean hasBlockEntity) {
        this(blockState, hasBlockEntity, null, null);
    }

    public BlockInfo(class_2680 blockState, Consumer<class_2586> postCreate) {
        this(blockState, true, null, null);
    }

    public BlockInfo(class_2680 blockState, boolean hasBlockEntity, class_1799 itemStack, Consumer<class_2586> postCreate) {
        this.blockState = blockState;
        this.hasBlockEntity = hasBlockEntity;
        this.itemStack = itemStack;
        this.postCreate = postCreate;
    }

    public static BlockInfo fromBlockState(class_2680 state) {
        try {
            class_2586 blockEntity;
            if (state.method_26204() instanceof class_2343 && (blockEntity = ((class_2343)state.method_26204()).method_10123(class_2338.field_10980, state)) != null) {
                return new BlockInfo(state, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new BlockInfo(state);
    }

    public static BlockInfo fromBlock(class_2248 block) {
        return BlockInfo.fromBlockState(block.method_9564());
    }

    public class_2680 getBlockState() {
        return this.blockState;
    }

    public boolean hasBlockEntity() {
        return this.hasBlockEntity;
    }

    public class_2586 getBlockEntity(class_2338 pos) {
        class_2248 class_22482;
        if (this.hasBlockEntity && (class_22482 = this.blockState.method_26204()) instanceof class_2343) {
            class_2343 entityBlock = (class_2343)class_22482;
            if (this.lastEntity != null && this.lastEntity.method_11016().equals((Object)pos)) {
                return this.lastEntity;
            }
            this.lastEntity = entityBlock.method_10123(pos, this.blockState);
            if (this.tag != null && this.lastEntity != null) {
                class_2487 compoundTag2 = this.lastEntity.method_38244();
                class_2487 compoundTag3 = compoundTag2.method_10553();
                compoundTag2.method_10543(this.tag);
                if (!compoundTag2.equals((Object)compoundTag3)) {
                    this.lastEntity.method_11014(compoundTag2);
                }
            }
            if (this.postCreate != null) {
                this.postCreate.accept(this.lastEntity);
            }
            return this.lastEntity;
        }
        return null;
    }

    public class_2586 getBlockEntity(class_1937 level, class_2338 pos) {
        class_2586 entity = this.getBlockEntity(pos);
        if (entity != null) {
            entity.method_31662(level);
        }
        return entity;
    }

    public class_1799 getItemStackForm() {
        return this.itemStack == null ? new class_1799((class_1935)this.blockState.method_26204()) : this.itemStack;
    }

    public class_1799 getItemStackForm(class_1920 level, class_2338 pos) {
        if (this.itemStack != null) {
            return this.itemStack;
        }
        return this.blockState.method_26204().method_9574((class_1922)new FacadeBlockAndTintGetter(level, pos, this.blockState, null), pos, this.blockState);
    }

    public void apply(class_1937 world, class_2338 pos) {
        world.method_8501(pos, this.blockState);
        class_2586 blockEntity = this.getBlockEntity(pos);
        if (blockEntity != null) {
            world.method_8438(blockEntity);
        }
    }

    public void clearBlockEntityCache() {
        this.lastEntity = null;
    }

    public void setBlockState(class_2680 blockState) {
        this.blockState = blockState;
    }

    public void setTag(class_2487 tag) {
        this.tag = tag;
    }

    public void setHasBlockEntity(boolean hasBlockEntity) {
        this.hasBlockEntity = hasBlockEntity;
    }
}

