/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.managed;

import com.lowdragmc.lowdraglib.syncdata.IContentChangeAware;
import com.lowdragmc.lowdraglib.syncdata.IManaged;
import com.lowdragmc.lowdraglib.syncdata.managed.IArrayRef;
import com.lowdragmc.lowdraglib.syncdata.managed.IRef;
import com.lowdragmc.lowdraglib.syncdata.managed.ReadonlyRef;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;

public class ReadonlyArrayRef
extends ReadonlyRef
implements IArrayRef {
    private final IntSet dirty = new IntOpenHashSet();

    public ReadonlyArrayRef(boolean isLazy, Object value) {
        super(isLazy, value);
    }

    @Override
    protected void init() {
        Object value = this.readRaw();
        if (value instanceof IContentChangeAware || value instanceof IManaged) {
            super.init();
            return;
        }
        if (this.isLazy()) {
            return;
        }
        Class<?> type = value.getClass();
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            if (IManaged.class.isAssignableFrom(componentType)) {
                return;
            }
            if (!IContentChangeAware.class.isAssignableFrom(componentType)) {
                throw new IllegalArgumentException("complex sync field must be an IContentChangeAware if not lazy!");
            }
            for (IContentChangeAware handler : (IContentChangeAware[])value) {
                this.replaceHandler(handler);
            }
            return;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            for (Object item : collection) {
                if (item instanceof IContentChangeAware) {
                    IContentChangeAware handler = (IContentChangeAware)item;
                    this.replaceHandler(handler);
                    continue;
                }
                if (item instanceof IManaged) continue;
                throw new IllegalArgumentException("complex sync field must be an IContentChangeAware if not lazy!");
            }
            return;
        }
        throw new IllegalArgumentException("Field must be an array or collection");
    }

    @Override
    public void update() {
        block8: {
            Object value;
            block7: {
                super.update();
                value = this.readRaw();
                Class<?> type = value.getClass();
                if (!type.isArray()) break block7;
                Class<?> componentType = type.getComponentType();
                if (!IManaged.class.isAssignableFrom(componentType)) break block8;
                IManaged[] values = (IManaged[])value;
                for (int i = 0; i < values.length; ++i) {
                    IManaged managed = values[i];
                    for (IRef field : managed.getSyncStorage().getNonLazyFields()) {
                        field.update();
                    }
                    if (!managed.getSyncStorage().hasDirtySyncFields() && !managed.getSyncStorage().hasDirtyPersistedFields()) continue;
                    this.setChanged(i);
                }
                break block8;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                int i = 0;
                for (Object item : collection) {
                    if (item instanceof IManaged) {
                        IManaged managed = (IManaged)item;
                        for (IRef field : managed.getSyncStorage().getNonLazyFields()) {
                            field.update();
                        }
                        if (managed.getSyncStorage().hasDirtySyncFields() || managed.getSyncStorage().hasDirtyPersistedFields()) {
                            this.setChanged(i);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public void markAsDirty() {
        super.markAsDirty();
    }

    @Override
    public void setChanged(int index) {
        this.markAsDirty();
        this.dirty.add(index);
    }

    @Override
    public IntSet getChanged() {
        return this.dirty;
    }
}

