/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.managed;

import com.lowdragmc.lowdraglib.syncdata.field.ManagedKey;
import com.lowdragmc.lowdraglib.syncdata.managed.IManagedVar;
import com.lowdragmc.lowdraglib.syncdata.managed.IRef;
import com.lowdragmc.lowdraglib.syncdata.managed.ReadOnlyManagedField;
import com.lowdragmc.lowdraglib.syncdata.managed.ReadOnlyManagedRef;
import com.lowdragmc.lowdraglib.syncdata.managed.SimpleObjectRef;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;

public class ManagedRef
implements IRef {
    protected final IManagedVar<?> field;
    protected boolean isSyncDirty;
    protected boolean isPersistedDirty;
    protected boolean lazy = false;
    protected ManagedKey key;
    protected BooleanConsumer onSyncListener = changed -> {};
    protected BooleanConsumer onPersistedListener = changed -> {};

    protected ManagedRef(IManagedVar<?> field) {
        this.field = field;
    }

    public static ManagedRef create(IManagedVar<?> field, boolean lazy) {
        if (field instanceof IManagedVar.Int) {
            return new IntRef((IManagedVar.Int)field).setLazy(lazy);
        }
        if (field instanceof IManagedVar.Long) {
            return new LongRef((IManagedVar.Long)field).setLazy(lazy);
        }
        if (field instanceof IManagedVar.Float) {
            return new FloatRef((IManagedVar.Float)field).setLazy(lazy);
        }
        if (field instanceof IManagedVar.Double) {
            return new DoubleRef((IManagedVar.Double)field).setLazy(lazy);
        }
        if (field instanceof IManagedVar.Boolean) {
            return new BooleanRef((IManagedVar.Boolean)field).setLazy(lazy);
        }
        if (field instanceof IManagedVar.Byte) {
            return new ByteRef((IManagedVar.Byte)field).setLazy(lazy);
        }
        if (field instanceof IManagedVar.Short) {
            return new ShortRef((IManagedVar.Short)field).setLazy(lazy);
        }
        if (field instanceof IManagedVar.Char) {
            return new CharRef((IManagedVar.Char)field).setLazy(lazy);
        }
        if (field instanceof ReadOnlyManagedField) {
            return new ReadOnlyManagedRef((ReadOnlyManagedField)field).setLazy(lazy);
        }
        return new SimpleObjectRef(field).setLazy(lazy);
    }

    @Override
    public ManagedKey getKey() {
        return this.key;
    }

    public IRef setKey(ManagedKey key) {
        this.key = key;
        return this;
    }

    public <T extends IManagedVar<?>> T getField() {
        return (T)this.field;
    }

    @Override
    public void clearSyncDirty() {
        this.isSyncDirty = false;
        if (this.key.isDestSync()) {
            this.onSyncListener.accept(false);
        }
    }

    @Override
    public void clearPersistedDirty() {
        this.isPersistedDirty = false;
        if (this.key.isPersist()) {
            this.onPersistedListener.accept(false);
        }
    }

    @Override
    public void markAsDirty() {
        if (this.key.isDestSync()) {
            this.isSyncDirty = true;
            this.onSyncListener.accept(true);
        }
        if (this.key.isPersist()) {
            this.isPersistedDirty = true;
            this.onPersistedListener.accept(true);
        }
    }

    @Override
    public boolean isLazy() {
        return this.lazy;
    }

    @Override
    public <T> T readRaw() {
        return this.getField().value();
    }

    protected ManagedRef setLazy(boolean lazy) {
        this.lazy = lazy;
        return this;
    }

    @Override
    public void update() {
    }

    @Override
    public boolean isSyncDirty() {
        return this.isSyncDirty;
    }

    @Override
    public boolean isPersistedDirty() {
        return this.isPersistedDirty;
    }

    @Override
    public void setOnSyncListener(BooleanConsumer onSyncListener) {
        this.onSyncListener = onSyncListener;
    }

    @Override
    public void setOnPersistedListener(BooleanConsumer onPersistedListener) {
        this.onPersistedListener = onPersistedListener;
    }

    static class IntRef
    extends ManagedRef {
        private int oldValue = ((IManagedVar.Int)this.getField()).intValue();

        IntRef(IManagedVar.Int field) {
            super(field);
        }

        @Override
        public void update() {
            int newValue = ((IManagedVar.Int)this.getField()).intValue();
            if (this.oldValue != newValue) {
                this.oldValue = newValue;
                this.markAsDirty();
            }
        }
    }

    static class LongRef
    extends ManagedRef {
        private long oldValue = ((IManagedVar.Long)this.getField()).longValue();

        LongRef(IManagedVar.Long field) {
            super(field);
        }

        @Override
        public void update() {
            long newValue = ((IManagedVar.Long)this.getField()).longValue();
            if (this.oldValue != newValue) {
                this.oldValue = newValue;
                this.markAsDirty();
            }
        }
    }

    static class FloatRef
    extends ManagedRef {
        private float oldValue = ((IManagedVar.Float)this.getField()).floatValue();

        FloatRef(IManagedVar.Float field) {
            super(field);
        }

        @Override
        public void update() {
            float newValue = ((IManagedVar.Float)this.getField()).floatValue();
            if (this.oldValue != newValue) {
                this.oldValue = newValue;
                this.markAsDirty();
            }
        }
    }

    static class DoubleRef
    extends ManagedRef {
        private double oldValue = ((IManagedVar.Double)this.getField()).doubleValue();

        DoubleRef(IManagedVar.Double field) {
            super(field);
        }

        @Override
        public void update() {
            double newValue = ((IManagedVar.Double)this.getField()).doubleValue();
            if (this.oldValue != newValue) {
                this.oldValue = newValue;
                this.markAsDirty();
            }
        }
    }

    static class BooleanRef
    extends ManagedRef {
        private boolean oldValue = ((IManagedVar.Boolean)this.getField()).booleanValue();

        BooleanRef(IManagedVar.Boolean field) {
            super(field);
        }

        @Override
        public void update() {
            boolean newValue = ((IManagedVar.Boolean)this.getField()).booleanValue();
            if (this.oldValue != newValue) {
                this.oldValue = newValue;
                this.markAsDirty();
            }
        }
    }

    static class ByteRef
    extends ManagedRef {
        private byte oldValue = ((IManagedVar.Byte)this.getField()).byteValue();

        ByteRef(IManagedVar.Byte field) {
            super(field);
        }

        @Override
        public void update() {
            byte newValue = ((IManagedVar.Byte)this.getField()).byteValue();
            if (this.oldValue != newValue) {
                this.oldValue = newValue;
                this.markAsDirty();
            }
        }
    }

    static class ShortRef
    extends ManagedRef {
        private short oldValue = ((IManagedVar.Short)this.getField()).shortValue();

        ShortRef(IManagedVar.Short field) {
            super(field);
        }

        @Override
        public void update() {
            short newValue = ((IManagedVar.Short)this.getField()).shortValue();
            if (this.oldValue != newValue) {
                this.oldValue = newValue;
                this.markAsDirty();
            }
        }
    }

    static class CharRef
    extends ManagedRef {
        private char oldValue = ((IManagedVar.Char)this.getField()).charValue();

        CharRef(IManagedVar.Char field) {
            super(field);
        }

        @Override
        public void update() {
            char newValue = ((IManagedVar.Char)this.getField()).charValue();
            if (this.oldValue != newValue) {
                this.oldValue = newValue;
                this.markAsDirty();
            }
        }
    }
}

