/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.field;

import com.lowdragmc.lowdraglib.syncdata.IFieldUpdateListener;
import com.lowdragmc.lowdraglib.syncdata.IManaged;
import com.lowdragmc.lowdraglib.syncdata.IManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.ManagedFieldUtils;
import com.lowdragmc.lowdraglib.syncdata.field.FieldUpdateSubscription;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedKey;
import com.lowdragmc.lowdraglib.syncdata.managed.IRef;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class FieldManagedStorage
implements IManagedStorage {
    private final IManaged owner;
    private BitSet dirtySyncFields;
    private BitSet dirtyPersistedFields;
    private IRef[] syncFields;
    private boolean initialized = false;
    private IRef[] persistedFields;
    private IRef[] nonLazyFields;
    private Map<ManagedKey, IRef> fieldMap;
    private final ReentrantLock lock = new ReentrantLock();
    private final Map<ManagedKey, List<FieldUpdateSubscription>> listeners = new HashMap<ManagedKey, List<FieldUpdateSubscription>>();

    @Override
    public <T> ISubscription addSyncUpdateListener(ManagedKey key, IFieldUpdateListener<T> listener) {
        FieldUpdateSubscription subscription = new FieldUpdateSubscription(key, listener){

            @Override
            public void unsubscribe() {
                ((List)FieldManagedStorage.this.listeners.getOrDefault(this.key, new ArrayList())).remove(this);
            }
        };
        this.listeners.computeIfAbsent(key, k -> new ArrayList()).add(subscription);
        return subscription;
    }

    @Override
    public void removeAllSyncUpdateListener(ManagedKey key) {
        this.listeners.remove(key);
    }

    @Override
    public boolean hasSyncListener(ManagedKey key) {
        List<FieldUpdateSubscription> list = this.listeners.get(key);
        return list != null && !list.isEmpty();
    }

    @Override
    public <T> void notifyFieldUpdate(ManagedKey key, T newVal, T oldVal) {
        List<FieldUpdateSubscription> list = this.listeners.get(key);
        if (list != null) {
            for (FieldUpdateSubscription sub : list) {
                IFieldUpdateListener<?> listener = sub.listener;
                try {
                    listener.onFieldChanged(key.getName(), newVal, oldVal);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    @Override
    public void init() {
        this.lock.lock();
        try {
            if (this.initialized) {
                return;
            }
            ManagedKey[] fields = this.owner.getFieldHolder().getFields();
            ManagedFieldUtils.FieldRefs result = ManagedFieldUtils.getFieldRefs(fields, this.owner, (ref, index, changed) -> {
                if (this.dirtySyncFields != null && index >= 0) {
                    this.dirtySyncFields.set(index, changed);
                    this.owner.onSyncChanged(ref, changed);
                }
            }, (ref, index, changed) -> {
                if (this.dirtyPersistedFields != null && index >= 0) {
                    this.dirtyPersistedFields.set(index, changed);
                    this.owner.onPersistedChanged(ref, changed);
                }
            });
            this.syncFields = result.syncedRefs();
            this.persistedFields = result.persistedRefs();
            this.dirtySyncFields = new BitSet(this.syncFields.length);
            this.dirtyPersistedFields = new BitSet(result.persistedRefs().length);
            this.nonLazyFields = result.nonLazyFields();
            this.fieldMap = result.fieldRefMap();
            this.initialized = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public FieldManagedStorage(IManaged owner) {
        this.owner = owner;
    }

    @Override
    public IRef[] getSyncFields() {
        this.init();
        return this.syncFields;
    }

    @Override
    public boolean hasDirtySyncFields() {
        return !this.dirtySyncFields.isEmpty();
    }

    @Override
    public boolean hasDirtyPersistedFields() {
        return !this.dirtyPersistedFields.isEmpty();
    }

    @Override
    public IRef[] getPersistedFields() {
        this.init();
        return this.persistedFields;
    }

    @Override
    public IManaged[] getManaged() {
        return new IManaged[]{this.owner};
    }

    @Override
    public IRef getFieldByKey(ManagedKey key) {
        this.init();
        return this.fieldMap.get(key);
    }

    @Override
    public IRef[] getNonLazyFields() {
        this.init();
        return this.nonLazyFields;
    }
}

