/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.blockentity;

import com.google.common.base.Strings;
import com.lowdragmc.lowdraglib.syncdata.accessor.IManagedAccessor;
import com.lowdragmc.lowdraglib.syncdata.blockentity.IManagedBlockEntity;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedKey;
import com.lowdragmc.lowdraglib.syncdata.managed.IRef;
import com.lowdragmc.lowdraglib.utils.TagUtils;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public interface IAutoPersistBlockEntity
extends IManagedBlockEntity {
    default public void saveManagedPersistentData(class_2487 tag, boolean forDrop) {
        IRef[] persistedFields;
        for (IRef persistedField : persistedFields = this.getRootStorage().getPersistedFields()) {
            class_2520 nbt;
            ManagedKey fieldKey = persistedField.getKey();
            if (forDrop && !fieldKey.isDrop()) continue;
            String key = fieldKey.getPersistentKey();
            if (Strings.isNullOrEmpty((String)key)) {
                key = fieldKey.getName();
            }
            if ((nbt = fieldKey.readPersistedField(persistedField)) == null) continue;
            TagUtils.setTagExtended(tag, key, nbt);
        }
        this.saveCustomPersistedData(tag, forDrop);
    }

    default public void loadManagedPersistentData(class_2487 tag) {
        IRef[] refs = this.getRootStorage().getPersistedFields();
        IManagedAccessor.writePersistedFields(tag, refs);
        this.loadCustomPersistedData(tag);
    }

    default public void saveCustomPersistedData(class_2487 tag, boolean forDrop) {
    }

    default public void loadCustomPersistedData(class_2487 tag) {
    }
}

