/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.accessor;

import com.lowdragmc.lowdraglib.syncdata.AccessorOp;
import com.lowdragmc.lowdraglib.syncdata.IAccessor;
import com.lowdragmc.lowdraglib.syncdata.TypedPayloadRegistries;
import com.lowdragmc.lowdraglib.syncdata.managed.IRef;
import com.lowdragmc.lowdraglib.syncdata.managed.ReadOnlyManagedField;
import com.lowdragmc.lowdraglib.syncdata.managed.ReadOnlyManagedRef;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.NbtTagPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.PrimitiveTypedPayload;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public abstract class ReadonlyAccessor
implements IAccessor {
    private byte defaultType = (byte)-1;

    @Override
    public byte getDefaultType() {
        return this.defaultType;
    }

    @Override
    public void setDefaultType(byte defaultType) {
        this.defaultType = defaultType;
    }

    @Override
    public abstract ITypedPayload<?> readFromReadonlyField(AccessorOp var1, Object var2);

    @Override
    public abstract void writeToReadonlyField(AccessorOp var1, Object var2, ITypedPayload<?> var3);

    @Override
    public boolean isManaged() {
        return false;
    }

    @Override
    public ITypedPayload<?> readField(AccessorOp op, IRef field) {
        Object obj = field.readRaw();
        if (field instanceof ReadOnlyManagedRef) {
            ReadOnlyManagedRef managedRef = (ReadOnlyManagedRef)field;
            if (obj == null) {
                return PrimitiveTypedPayload.NullPayload.ofNull();
            }
            class_2487 tag = new class_2487();
            tag.method_10566("uid", (class_2520)managedRef.getReadOnlyField().serializeUid(obj));
            class_2487 payloadTag = new class_2487();
            ITypedPayload<?> payload = this.readFromReadonlyField(op, obj);
            payloadTag.method_10567("t", payload.getType());
            class_2520 data = payload.serializeNBT();
            if (data != null) {
                payloadTag.method_10566("d", data);
            }
            tag.method_10566("payload", (class_2520)payloadTag);
            return NbtTagPayload.of((class_2520)tag);
        }
        if (obj == null) {
            throw new IllegalArgumentException("readonly field %s has a null reference".formatted(field.getKey()));
        }
        return this.readFromReadonlyField(op, obj);
    }

    @Override
    public void writeField(AccessorOp op, IRef field, ITypedPayload<?> payload) {
        Object obj = field.readRaw();
        if (field instanceof ReadOnlyManagedRef) {
            NbtTagPayload nbtTagPayload;
            Object t;
            PrimitiveTypedPayload primitive;
            ReadOnlyManagedRef managedRef = (ReadOnlyManagedRef)field;
            ReadOnlyManagedField readOnlyField = managedRef.getReadOnlyField();
            if (payload instanceof PrimitiveTypedPayload && (primitive = (PrimitiveTypedPayload)payload).isNull()) {
                readOnlyField.set(null);
            } else if (payload instanceof NbtTagPayload && (t = (nbtTagPayload = (NbtTagPayload)payload).getPayload()) instanceof class_2487) {
                class_2487 tag = (class_2487)t;
                class_2487 uid = tag.method_10562("uid");
                if (obj == null || !readOnlyField.serializeUid(obj).equals((Object)uid)) {
                    obj = managedRef.getReadOnlyField().deserializeUid(uid);
                    readOnlyField.set(obj);
                }
                class_2487 payloadTag = tag.method_10562("payload");
                byte id = payloadTag.method_10571("t");
                ITypedPayload<?> p = TypedPayloadRegistries.create(id);
                p.deserializeNBT(payloadTag.method_10580("d"));
                this.writeToReadonlyField(op, obj, p);
            }
            return;
        }
        if (obj == null) {
            throw new IllegalArgumentException("readonly field %s has a null reference".formatted(field));
        }
        this.writeToReadonlyField(op, obj, payload);
    }
}

