/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.accessor;

import com.lowdragmc.lowdraglib.syncdata.AccessorOp;
import com.lowdragmc.lowdraglib.syncdata.accessor.ManagedAccessor;
import com.lowdragmc.lowdraglib.syncdata.managed.IManagedVar;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.PrimitiveTypedPayload;
import java.util.Objects;

public abstract class PrimitiveAccessor
extends ManagedAccessor {
    private final Class<?>[] operandTypes;

    protected PrimitiveAccessor(Class<?> ... operandTypes) {
        this.operandTypes = operandTypes;
    }

    @Override
    public Class<?>[] operandTypes() {
        return this.operandTypes;
    }

    protected PrimitiveTypedPayload<?> ensurePrimitive(ITypedPayload<?> payload) {
        if (!(payload instanceof PrimitiveTypedPayload)) {
            throw new IllegalArgumentException("Payload %s is not a primitive payload".formatted(payload));
        }
        PrimitiveTypedPayload primitivePayload = (PrimitiveTypedPayload)payload;
        return primitivePayload;
    }

    protected <T> IManagedVar<T> ensureType(IManagedVar<?> field, Class<T> clazz) {
        if (!clazz.isAssignableFrom(field.getType())) {
            throw new IllegalArgumentException("Field %s is not of type %s".formatted(field, clazz));
        }
        return field;
    }

    public static class ShortAccessor
    extends PrimitiveAccessor {
        public ShortAccessor() {
            super(Short.TYPE, Short.class);
        }

        @Override
        public ITypedPayload<?> readManagedField(AccessorOp op, IManagedVar<?> field) {
            if (field instanceof IManagedVar.Short) {
                IManagedVar.Short shortField = (IManagedVar.Short)field;
                return PrimitiveTypedPayload.ofShort(shortField.shortValue());
            }
            PrimitiveTypedPayload<?> result = PrimitiveTypedPayload.tryOfBoxed(field.value());
            return Objects.requireNonNull(result, "Field %s is not a short field".formatted(field));
        }

        @Override
        public void writeManagedField(AccessorOp op, IManagedVar<?> field, ITypedPayload<?> payload) {
            PrimitiveTypedPayload<?> primitivePayload = this.ensurePrimitive(payload);
            if (field instanceof IManagedVar.Short) {
                IManagedVar.Short shortField = (IManagedVar.Short)field;
                shortField.setShort(primitivePayload.getAsShort());
            } else {
                this.ensureType(field, Short.class).set(primitivePayload.getAsShort());
            }
        }
    }

    public static class CharAccessor
    extends PrimitiveAccessor {
        public CharAccessor() {
            super(Character.TYPE, Character.class);
        }

        @Override
        public ITypedPayload<?> readManagedField(AccessorOp op, IManagedVar<?> field) {
            if (field instanceof IManagedVar.Char) {
                IManagedVar.Char charField = (IManagedVar.Char)field;
                return PrimitiveTypedPayload.ofChar(charField.charValue());
            }
            PrimitiveTypedPayload<?> result = PrimitiveTypedPayload.tryOfBoxed(field.value());
            return Objects.requireNonNull(result, "Field %s is not a char field".formatted(field));
        }

        @Override
        public void writeManagedField(AccessorOp op, IManagedVar<?> field, ITypedPayload<?> payload) {
            PrimitiveTypedPayload<?> primitivePayload = this.ensurePrimitive(payload);
            if (field instanceof IManagedVar.Char) {
                IManagedVar.Char charField = (IManagedVar.Char)field;
                charField.setChar(primitivePayload.getAsChar());
            } else {
                this.ensureType(field, Character.class).set(Character.valueOf(primitivePayload.getAsChar()));
            }
        }
    }

    public static class ByteAccessor
    extends PrimitiveAccessor {
        public ByteAccessor() {
            super(Byte.TYPE, Byte.class);
        }

        @Override
        public ITypedPayload<?> readManagedField(AccessorOp op, IManagedVar<?> field) {
            if (field instanceof IManagedVar.Byte) {
                IManagedVar.Byte byteField = (IManagedVar.Byte)field;
                return PrimitiveTypedPayload.ofByte(byteField.byteValue());
            }
            PrimitiveTypedPayload<?> result = PrimitiveTypedPayload.tryOfBoxed(field.value());
            return Objects.requireNonNull(result, "Field %s is not a byte field".formatted(field));
        }

        @Override
        public void writeManagedField(AccessorOp op, IManagedVar<?> field, ITypedPayload<?> payload) {
            PrimitiveTypedPayload<?> primitivePayload = this.ensurePrimitive(payload);
            if (field instanceof IManagedVar.Byte) {
                IManagedVar.Byte byteField = (IManagedVar.Byte)field;
                byteField.setByte(primitivePayload.getAsByte());
            } else {
                this.ensureType(field, Byte.class).set(primitivePayload.getAsByte());
            }
        }
    }

    public static class BooleanAccessor
    extends PrimitiveAccessor {
        public BooleanAccessor() {
            super(Boolean.TYPE, Boolean.class);
        }

        @Override
        public ITypedPayload<?> readManagedField(AccessorOp op, IManagedVar<?> field) {
            if (field instanceof IManagedVar.Boolean) {
                IManagedVar.Boolean booleanField = (IManagedVar.Boolean)field;
                return PrimitiveTypedPayload.ofBoolean(booleanField.booleanValue());
            }
            PrimitiveTypedPayload<?> result = PrimitiveTypedPayload.tryOfBoxed(field.value());
            return Objects.requireNonNull(result, "Field %s is not a boolean field".formatted(field));
        }

        @Override
        public void writeManagedField(AccessorOp op, IManagedVar<?> field, ITypedPayload<?> payload) {
            PrimitiveTypedPayload<?> primitivePayload = this.ensurePrimitive(payload);
            if (field instanceof IManagedVar.Boolean) {
                IManagedVar.Boolean booleanField = (IManagedVar.Boolean)field;
                booleanField.setBoolean(primitivePayload.getAsBoolean());
            } else {
                this.ensureType(field, Boolean.class).set(primitivePayload.getAsBoolean());
            }
        }
    }

    public static class DoubleAccessor
    extends PrimitiveAccessor {
        public DoubleAccessor() {
            super(Double.TYPE, Double.class);
        }

        @Override
        public ITypedPayload<?> readManagedField(AccessorOp op, IManagedVar<?> field) {
            if (field instanceof IManagedVar.Double) {
                IManagedVar.Double doubleField = (IManagedVar.Double)field;
                return PrimitiveTypedPayload.ofDouble(doubleField.doubleValue());
            }
            PrimitiveTypedPayload<?> result = PrimitiveTypedPayload.tryOfBoxed(field.value());
            return Objects.requireNonNull(result, "Field %s is not a double field".formatted(field));
        }

        @Override
        public void writeManagedField(AccessorOp op, IManagedVar<?> field, ITypedPayload<?> payload) {
            PrimitiveTypedPayload<?> primitivePayload = this.ensurePrimitive(payload);
            if (field instanceof IManagedVar.Double) {
                IManagedVar.Double doubleField = (IManagedVar.Double)field;
                doubleField.setDouble(primitivePayload.getAsDouble());
            } else {
                this.ensureType(field, Double.class).set(primitivePayload.getAsDouble());
            }
        }
    }

    public static class FloatAccessor
    extends PrimitiveAccessor {
        public FloatAccessor() {
            super(Float.TYPE, Float.class);
        }

        @Override
        public ITypedPayload<?> readManagedField(AccessorOp op, IManagedVar<?> field) {
            if (field instanceof IManagedVar.Float) {
                IManagedVar.Float floatField = (IManagedVar.Float)field;
                return PrimitiveTypedPayload.ofFloat(floatField.floatValue());
            }
            PrimitiveTypedPayload<?> result = PrimitiveTypedPayload.tryOfBoxed(field.value());
            return Objects.requireNonNull(result, "Field %s is not a float field".formatted(field));
        }

        @Override
        public void writeManagedField(AccessorOp op, IManagedVar<?> field, ITypedPayload<?> payload) {
            PrimitiveTypedPayload<?> primitivePayload = this.ensurePrimitive(payload);
            if (field instanceof IManagedVar.Float) {
                IManagedVar.Float floatField = (IManagedVar.Float)field;
                floatField.setFloat(primitivePayload.getAsFloat());
            } else {
                this.ensureType(field, Float.class).set(Float.valueOf(primitivePayload.getAsFloat()));
            }
        }
    }

    public static class LongAccessor
    extends PrimitiveAccessor {
        public LongAccessor() {
            super(Long.TYPE, Long.class);
        }

        @Override
        public ITypedPayload<?> readManagedField(AccessorOp op, IManagedVar<?> field) {
            if (field instanceof IManagedVar.Long) {
                IManagedVar.Long longField = (IManagedVar.Long)field;
                return PrimitiveTypedPayload.ofLong(longField.longValue());
            }
            PrimitiveTypedPayload<?> result = PrimitiveTypedPayload.tryOfBoxed(field.value());
            return Objects.requireNonNull(result, "Field %s is not a long field".formatted(field));
        }

        @Override
        public void writeManagedField(AccessorOp op, IManagedVar<?> field, ITypedPayload<?> payload) {
            PrimitiveTypedPayload<?> primitivePayload = this.ensurePrimitive(payload);
            if (field instanceof IManagedVar.Long) {
                IManagedVar.Long longField = (IManagedVar.Long)field;
                longField.setLong(primitivePayload.getAsLong());
            } else {
                this.ensureType(field, Long.class).set(primitivePayload.getAsLong());
            }
        }
    }

    public static class IntAccessor
    extends PrimitiveAccessor {
        public IntAccessor() {
            super(Integer.TYPE, Integer.class);
        }

        @Override
        public ITypedPayload<?> readManagedField(AccessorOp op, IManagedVar<?> field) {
            if (field instanceof IManagedVar.Int) {
                IManagedVar.Int intField = (IManagedVar.Int)field;
                return PrimitiveTypedPayload.ofInt(intField.intValue());
            }
            PrimitiveTypedPayload<?> result = PrimitiveTypedPayload.tryOfBoxed(field.value());
            return Objects.requireNonNull(result, "Field %s is not an int field".formatted(field));
        }

        @Override
        public void writeManagedField(AccessorOp op, IManagedVar<?> field, ITypedPayload<?> payload) {
            PrimitiveTypedPayload<?> primitivePayload = this.ensurePrimitive(payload);
            if (field instanceof IManagedVar.Int) {
                IManagedVar.Int intField = (IManagedVar.Int)field;
                intField.setInt(primitivePayload.getAsInt());
            } else {
                this.ensureType(field, Integer.class).set(primitivePayload.getAsInt());
            }
        }
    }
}

