/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.accessor;

import com.google.common.base.Strings;
import com.lowdragmc.lowdraglib.syncdata.AccessorOp;
import com.lowdragmc.lowdraglib.syncdata.IManaged;
import com.lowdragmc.lowdraglib.syncdata.IManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.TypedPayloadRegistries;
import com.lowdragmc.lowdraglib.syncdata.accessor.ReadonlyAccessor;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedKey;
import com.lowdragmc.lowdraglib.syncdata.managed.IRef;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.NbtTagPayload;
import com.lowdragmc.lowdraglib.utils.TagUtils;
import java.util.BitSet;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class IManagedAccessor
extends ReadonlyAccessor {
    @Override
    public boolean hasPredicate() {
        return true;
    }

    @Override
    public boolean test(Class<?> type) {
        return IManaged.class.isAssignableFrom(type);
    }

    @Override
    public ITypedPayload<?> readFromReadonlyField(AccessorOp op, Object obj) {
        if (!(obj instanceof IManaged)) {
            throw new IllegalArgumentException("Field %s is not ITagSerializable".formatted(obj));
        }
        IManaged managed = (IManaged)obj;
        class_2487 tag = op == AccessorOp.SYNCED || op == AccessorOp.FORCE_SYNCED ? IManagedAccessor.readSyncedFields(managed, new class_2487(), op == AccessorOp.FORCE_SYNCED) : IManagedAccessor.readManagedFields(managed, new class_2487());
        return new NbtTagPayload().setPayload(tag);
    }

    public static class_2487 readSyncedFields(IManaged managed, class_2487 tag, boolean force) {
        BitSet changed = new BitSet();
        IRef[] syncedFields = managed.getSyncStorage().getSyncFields();
        class_2499 list = new class_2499();
        for (int i = 0; i < syncedFields.length; ++i) {
            IRef field = syncedFields[i];
            if (!force && !field.isSyncDirty()) continue;
            changed.set(i);
            ManagedKey key = field.getKey();
            ITypedPayload<?> payload = key.readSyncedField(field, force);
            class_2487 payloadTag = new class_2487();
            payloadTag.method_10567("t", payload.getType());
            class_2520 data = payload.serializeNBT();
            if (data != null) {
                payloadTag.method_10566("d", data);
            }
            list.add((Object)payloadTag);
            field.clearSyncDirty();
        }
        tag.method_10570("c", changed.toByteArray());
        tag.method_10566("l", (class_2520)list);
        return tag;
    }

    public static class_2487 readManagedFields(IManaged managed, class_2487 tag) {
        IRef[] persistedFields;
        for (IRef persistedField : persistedFields = managed.getSyncStorage().getPersistedFields()) {
            class_2520 nbt;
            ManagedKey fieldKey = persistedField.getKey();
            String key = fieldKey.getPersistentKey();
            if (Strings.isNullOrEmpty((String)key)) {
                key = fieldKey.getName();
            }
            if ((nbt = fieldKey.readPersistedField(persistedField)) == null) continue;
            TagUtils.setTagExtended(tag, key, nbt);
        }
        return tag;
    }

    @Override
    public void writeToReadonlyField(AccessorOp op, Object obj, ITypedPayload<?> payload) {
        NbtTagPayload nbtPayload;
        Object t;
        if (!(obj instanceof IManaged)) {
            throw new IllegalArgumentException("Field %s is not ITagSerializable".formatted(obj));
        }
        IManaged managed = (IManaged)obj;
        if (!(payload instanceof NbtTagPayload) || !((t = (nbtPayload = (NbtTagPayload)payload).getPayload()) instanceof class_2487)) {
            throw new IllegalArgumentException("Payload %s is not NbtTagPayload".formatted(payload));
        }
        class_2487 tag = (class_2487)t;
        if (op == AccessorOp.SYNCED || op == AccessorOp.FORCE_SYNCED) {
            IManagedStorage storage = managed.getSyncStorage();
            IRef[] syncedFields = storage.getSyncFields();
            BitSet changed = BitSet.valueOf(tag.method_10547("c"));
            class_2499 list = tag.method_10554("l", 10);
            ITypedPayload[] payloads = new ITypedPayload[list.size()];
            for (int i = 0; i < payloads.length; ++i) {
                class_2487 payloadTag = list.method_10602(i);
                byte id = payloadTag.method_10571("t");
                ITypedPayload<?> p = TypedPayloadRegistries.create(id);
                p.deserializeNBT(payloadTag.method_10580("d"));
                payloads[i] = p;
            }
            IManagedAccessor.writeSyncedFields(storage, syncedFields, changed, payloads);
        } else if (op == AccessorOp.PERSISTED) {
            IRef[] refs = managed.getSyncStorage().getPersistedFields();
            IManagedAccessor.writePersistedFields(tag, refs);
        } else {
            throw new IllegalArgumentException("Payload %s does not match op %s".formatted(new Object[]{payload, op}));
        }
    }

    public static void writePersistedFields(class_2487 tag, IRef[] refs) {
        for (IRef ref : refs) {
            class_2520 nbt;
            ManagedKey fieldKey = ref.getKey();
            String key = fieldKey.getPersistentKey();
            if (Strings.isNullOrEmpty((String)key)) {
                key = fieldKey.getName();
            }
            if ((nbt = TagUtils.getTagExtended(tag, key)) == null) continue;
            fieldKey.writePersistedField(ref, nbt);
        }
    }

    public static void writeSyncedFields(IManagedStorage storage, IRef[] syncedFields, BitSet changed, ITypedPayload<?>[] payloads) {
        int j = 0;
        for (int i = 0; i < changed.length(); ++i) {
            if (!changed.get(i)) continue;
            IRef field = syncedFields[i];
            ManagedKey key = field.getKey();
            boolean hasListener = storage.hasSyncListener(key);
            Object oldValue = null;
            if (hasListener) {
                oldValue = field.readRaw();
            }
            key.writeSyncedField(field, payloads[j]);
            if (hasListener) {
                storage.notifyFieldUpdate(key, field.readRaw(), oldValue);
            }
            ++j;
        }
    }
}

