/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.accessor;

import com.lowdragmc.lowdraglib.syncdata.AccessorOp;
import com.lowdragmc.lowdraglib.syncdata.IAccessor;
import com.lowdragmc.lowdraglib.syncdata.TypedPayloadRegistries;
import com.lowdragmc.lowdraglib.syncdata.accessor.IArrayLikeAccessor;
import com.lowdragmc.lowdraglib.syncdata.managed.IManagedVar;
import com.lowdragmc.lowdraglib.syncdata.managed.IRef;
import com.lowdragmc.lowdraglib.syncdata.managed.ManagedArrayItem;
import com.lowdragmc.lowdraglib.syncdata.managed.ManagedHolder;
import com.lowdragmc.lowdraglib.syncdata.managed.ManagedRef;
import com.lowdragmc.lowdraglib.syncdata.payload.ArrayPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.PrimitiveTypedPayload;
import java.lang.reflect.Array;

public class ArrayAccessor
implements IAccessor,
IArrayLikeAccessor {
    private final IAccessor childAccessor;
    private final Class<?> childType;

    @Override
    public byte getDefaultType() {
        return TypedPayloadRegistries.getId(ArrayPayload.class);
    }

    @Override
    public void setDefaultType(byte defaultType) {
        throw new UnsupportedOperationException("Cannot set default type for array accessor");
    }

    public ArrayAccessor(IAccessor childAccessor, Class<?> childType) {
        this.childAccessor = childAccessor;
        this.childType = childType;
    }

    @Override
    public ITypedPayload<?> readField(AccessorOp op, IRef field) {
        if (field instanceof ManagedRef) {
            ManagedRef managedRef = (ManagedRef)field;
            Object managedField = managedRef.getField();
            if (!managedField.isPrimitive() && managedField.value() == null) {
                return PrimitiveTypedPayload.ofNull();
            }
            return this.readManagedField(op, (IManagedVar<?>)managedField);
        }
        Object obj = field.readRaw();
        if (obj == null) {
            throw new IllegalArgumentException("readonly field %s has a null reference".formatted(field));
        }
        return this.readFromReadonlyField(op, obj);
    }

    @Override
    public void writeField(AccessorOp op, IRef field, ITypedPayload<?> payload) {
        Object obj;
        if (field instanceof ManagedRef) {
            ManagedRef syncedField = (ManagedRef)field;
            Object managedField = syncedField.getField();
            this.writeManagedField(op, (IManagedVar<?>)managedField, payload);
        }
        if ((obj = field.readRaw()) == null) {
            throw new IllegalArgumentException("readonly field %s has a null reference".formatted(field));
        }
        this.writeToReadonlyField(op, obj, payload);
    }

    @Override
    public boolean hasPredicate() {
        return true;
    }

    @Override
    public boolean test(Class<?> type) {
        return type.isArray();
    }

    @Override
    public boolean isManaged() {
        return this.childAccessor.isManaged();
    }

    @Override
    public ITypedPayload<?> readManagedField(AccessorOp op, IManagedVar<?> field) {
        Object value = field.value();
        if (value == null) {
            return PrimitiveTypedPayload.ofNull();
        }
        if (!value.getClass().isArray()) {
            throw new IllegalArgumentException("Value %s is not an array".formatted(value));
        }
        int size = Array.getLength(value);
        ITypedPayload[] result = new ITypedPayload[size];
        if (!this.childAccessor.isManaged()) {
            for (int i = 0; i < size; ++i) {
                ITypedPayload<?> payload;
                Object obj = Array.get(value, i);
                result[i] = payload = this.childAccessor.readFromReadonlyField(op, obj);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                ITypedPayload<?> payload;
                ManagedArrayItem holder = ManagedArrayItem.of(value, i);
                result[i] = payload = this.childAccessor.readManagedField(op, holder);
            }
        }
        return ArrayPayload.of(result);
    }

    @Override
    public void writeManagedField(AccessorOp op, IManagedVar<?> field, ITypedPayload<?> payload) {
        PrimitiveTypedPayload primitive;
        if (payload instanceof PrimitiveTypedPayload && (primitive = (PrimitiveTypedPayload)payload).isNull()) {
            field.set(null);
            return;
        }
        if (!(payload instanceof ArrayPayload)) {
            throw new IllegalArgumentException("Payload %s is not ArrayPayload".formatted(payload));
        }
        ArrayPayload arrayPayload = (ArrayPayload)payload;
        boolean isManaged = this.childAccessor.isManaged();
        Object result = field.value();
        if (result == null || Array.getLength(result) != ((ITypedPayload[])arrayPayload.getPayload()).length) {
            if (!isManaged) {
                throw new IllegalArgumentException("The array of %s should not be changed".formatted(this.childType));
            }
            result = Array.newInstance(this.childType, ((ITypedPayload[])arrayPayload.getPayload()).length);
        }
        ITypedPayload[] payloads = (ITypedPayload[])arrayPayload.getPayload();
        if (!isManaged) {
            for (int i = 0; i < payloads.length; ++i) {
                Object obj = Array.get(result, i);
                ITypedPayload item = payloads[i];
                this.childAccessor.writeToReadonlyField(op, obj, item);
            }
        } else {
            for (int i = 0; i < payloads.length; ++i) {
                ManagedArrayItem holder = ManagedArrayItem.of(result, i);
                this.childAccessor.writeManagedField(op, holder, payloads[i]);
            }
        }
        if (isManaged) {
            field.set(result);
        }
    }

    @Override
    public ITypedPayload<?> readFromReadonlyField(AccessorOp op, Object obj) {
        ManagedHolder<Object> holder = ManagedHolder.of(obj);
        return this.readManagedField(op, holder);
    }

    @Override
    public void writeToReadonlyField(AccessorOp op, Object obj, ITypedPayload<?> payload) {
        ManagedHolder<Object> holder = ManagedHolder.of(obj);
        this.writeManagedField(op, holder, payload);
    }

    @Override
    public IAccessor getChildAccessor() {
        return this.childAccessor;
    }
}

