/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.side.item.fabric;

import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import java.util.ArrayList;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public class ItemTransferProxyStorage
extends SnapshotParticipant<Object>
implements Storage<ItemVariant> {
    final IItemTransfer transfer;

    public ItemTransferProxyStorage(IItemTransfer transfer) {
        this.transfer = transfer;
    }

    protected void onFinalCommit() {
        this.transfer.onContentsChanged();
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (this.simulateInsert(resource, maxAmount, transaction) > 0L) {
            this.updateSnapshots(transaction);
            long left = maxAmount;
            for (int i = 0; i < this.transfer.getSlots() && (left = (long)this.transfer.insertItem(i, resource.toStack((int)left), false, false).method_7947()) != 0L; ++i) {
            }
            return maxAmount - left;
        }
        return 0L;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (this.simulateExtract(resource, maxAmount, transaction) > 0L) {
            class_1799 extracted;
            this.updateSnapshots(transaction);
            long left = maxAmount;
            for (int i = 0; !(i >= this.transfer.getSlots() || resource.matches(extracted = this.transfer.extractItem(i, (int)left, false, false)) && (left -= (long)extracted.method_7947()) == 0L); ++i) {
            }
            return maxAmount - left;
        }
        return 0L;
    }

    public long simulateInsert(ItemVariant resource, long maxAmount, @Nullable TransactionContext transaction) {
        long left = maxAmount;
        for (int i = 0; i < this.transfer.getSlots() && (left = (long)this.transfer.insertItem(i, resource.toStack((int)left), true, false).method_7947()) != 0L; ++i) {
        }
        return maxAmount - left;
    }

    public long simulateExtract(ItemVariant resource, long maxAmount, @Nullable TransactionContext transaction) {
        class_1799 extracted;
        long left = maxAmount;
        for (int i = 0; !(i >= this.transfer.getSlots() || resource.matches(extracted = this.transfer.extractItem(i, (int)left, true, false)) && (left -= (long)extracted.method_7947()) == 0L); ++i) {
        }
        return maxAmount - left;
    }

    public Iterator<StorageView<ItemVariant>> iterator() {
        ArrayList<ItemStorageView> views = new ArrayList<ItemStorageView>();
        for (int i = 0; i < this.transfer.getSlots(); ++i) {
            views.add(new ItemStorageView(i));
        }
        return views.iterator();
    }

    protected Object createSnapshot() {
        return this.transfer.createSnapshot();
    }

    protected void readSnapshot(Object snapshot) {
        this.transfer.restoreFromSnapshot(snapshot);
    }

    private class ItemStorageView
    extends SnapshotParticipant<class_1799>
    implements StorageView<ItemVariant> {
        private final int index;

        private ItemStorageView(int index) {
            this.index = index;
        }

        protected void onFinalCommit() {
            ItemTransferProxyStorage.this.transfer.onContentsChanged();
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
            class_1799 extracted = ItemTransferProxyStorage.this.transfer.extractItem(this.index, (int)maxAmount, true, false);
            if (resource.matches(extracted) && extracted.method_7947() > 0) {
                this.updateSnapshots(transaction);
                return ItemTransferProxyStorage.this.transfer.extractItem(this.index, extracted.method_7947(), false, false).method_7947();
            }
            return 0L;
        }

        public boolean isResourceBlank() {
            return ItemTransferProxyStorage.this.transfer.getStackInSlot(this.index).method_7960();
        }

        public ItemVariant getResource() {
            return ItemVariant.of((class_1799)ItemTransferProxyStorage.this.transfer.getStackInSlot(this.index));
        }

        public long getAmount() {
            return ItemTransferProxyStorage.this.transfer.getStackInSlot(this.index).method_7947();
        }

        public long getCapacity() {
            return ItemTransferProxyStorage.this.transfer.getSlotLimit(this.index);
        }

        protected class_1799 createSnapshot() {
            return ItemTransferProxyStorage.this.transfer.getStackInSlot(this.index).method_7972();
        }

        protected void readSnapshot(class_1799 snapshot) {
            ItemTransferProxyStorage.this.transfer.setStackInSlot(this.index, snapshot);
        }
    }
}

