/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.side.item.fabric;

import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.fabric.ItemStorageProxyItemTransfer;
import com.lowdragmc.lowdraglib.side.item.fabric.ItemTransferProxyStorage;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.base.SingleStackStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class ItemTransferHelperImpl {
    public static Storage<ItemVariant> toItemVariantStorage(IItemTransfer itemTransfer) {
        return new ItemTransferProxyStorage(itemTransfer);
    }

    public static SingleStackStorage toSingleStackStorage(final IItemTransfer itemTransfer, final int slot) {
        return new SingleStackStorage(){

            protected class_1799 getStack() {
                return itemTransfer.getStackInSlot(slot);
            }

            protected void setStack(class_1799 stack) {
                itemTransfer.setStackInSlot(slot, stack);
            }

            protected boolean canInsert(ItemVariant itemVariant) {
                return itemTransfer.insertItem(slot, itemVariant.toStack(), true, false).method_7960();
            }

            protected boolean canExtract(ItemVariant itemVariant) {
                return itemVariant.matches(this.getStack()) && !itemTransfer.extractItem(slot, Integer.MAX_VALUE, true, false).method_7960();
            }

            protected void onFinalCommit() {
                itemTransfer.onContentsChanged();
            }
        };
    }

    public static IItemTransfer toItemTransfer(Storage<ItemVariant> storage) {
        return new ItemStorageProxyItemTransfer(storage);
    }

    public static IItemTransfer getItemTransfer(class_1937 level, class_2338 pos, @Nullable class_2350 direction) {
        Storage storage = (Storage)ItemStorage.SIDED.find(level, pos, (Object)direction);
        return storage == null ? null : ItemTransferHelperImpl.toItemTransfer((Storage<ItemVariant>)storage);
    }

    public static void exportToTarget(IItemTransfer source, int maxAmount, Predicate<class_1799> predicate, class_1937 level, class_2338 pos, @Nullable class_2350 direction) {
        Storage target = (Storage)ItemStorage.SIDED.find(level, pos, (Object)direction);
        if (target != null) {
            StorageUtil.move(ItemTransferHelperImpl.toItemVariantStorage(source), (Storage)target, iv -> {
                if (predicate == null) {
                    return true;
                }
                return predicate.test(iv.toStack());
            }, (long)maxAmount, null);
        }
    }

    public static void importToTarget(IItemTransfer target, int maxAmount, Predicate<class_1799> predicate, class_1937 level, class_2338 pos, @Nullable class_2350 direction) {
        Storage source = (Storage)ItemStorage.SIDED.find(level, pos, (Object)direction);
        if (source != null) {
            StorageUtil.move((Storage)source, ItemTransferHelperImpl.toItemVariantStorage(target), iv -> {
                if (predicate == null) {
                    return true;
                }
                return predicate.test(iv.toStack());
            }, (long)maxAmount, null);
        }
    }
}

