/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.side.item.fabric;

import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.base.SingleStackStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.NotNull;

class ItemStorageProxyItemTransfer
implements IItemTransfer {
    private final List<StorageView<ItemVariant>> views;
    private final Storage<ItemVariant> storage;

    public ItemStorageProxyItemTransfer(Storage<ItemVariant> storage) {
        Iterator iter = storage.iterator();
        this.views = new ArrayList<StorageView<ItemVariant>>();
        while (iter.hasNext()) {
            this.views.add((StorageView<ItemVariant>)((StorageView)iter.next()));
        }
        this.storage = storage;
    }

    @Override
    public int getSlots() {
        return this.views.size();
    }

    @Override
    @NotNull
    public class_1799 getStackInSlot(int slot) {
        return ((ItemVariant)this.views.get(slot).getResource()).toStack((int)this.views.get(slot).getAmount());
    }

    @Override
    @NotNull
    public class_1799 insertItem(int slot, @NotNull class_1799 stack, boolean simulate, boolean notifyChanges) {
        if (stack.method_7960()) {
            return stack;
        }
        class_1799 copied = stack.method_7972();
        SingleStackStorage handler = this.storage;
        StorageView<ItemVariant> storageView = this.views.get(slot);
        if (storageView instanceof SingleStackStorage) {
            SingleStackStorage storage;
            handler = storage = (SingleStackStorage)storageView;
        } else if (slot != 0) {
            return stack;
        }
        try (Transaction transaction = Transaction.openNested((TransactionContext)Transaction.getCurrentUnsafe());){
            int filled = (int)handler.insert((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)transaction);
            copied.method_7934(filled);
            if (!simulate && filled > 0) {
                transaction.commit();
            }
        }
        return copied;
    }

    @Override
    @NotNull
    public class_1799 extractItem(int slot, int amount, boolean simulate, boolean notifyChanges) {
        class_1799 item = this.getStackInSlot(slot);
        if (item.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 copied = item.method_7972();
        try (Transaction transaction = Transaction.openNested((TransactionContext)Transaction.getCurrentUnsafe());){
            int extracted = (int)this.views.get(slot).extract((Object)ItemVariant.of((class_1799)item), (long)amount, (TransactionContext)transaction);
            copied.method_7939(extracted);
            if (!simulate && extracted > 0) {
                transaction.commit();
            }
        }
        return copied;
    }

    @Override
    public int getSlotLimit(int slot) {
        return (int)this.views.get(slot).getCapacity();
    }

    @Override
    public boolean isItemValid(int slot, @NotNull class_1799 stack) {
        return slot < this.views.size();
    }

    @Override
    @NotNull
    public Object createSnapshot() {
        throw new NotImplementedException("Try to create a snapshot for a proxy transfer.");
    }

    @Override
    public void restoreFromSnapshot(Object snapshot) {
        throw new NotImplementedException("Try to restore a snapshot for a proxy transfer.");
    }
}

