/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.side.fluid.fabric;

import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.fluid.fabric.FluidHelperImpl;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import org.jetbrains.annotations.Nullable;

class FluidTransferProxyStorage
extends SnapshotParticipant<Object>
implements Storage<FluidVariant> {
    public final IFluidTransfer transfer;

    public FluidTransferProxyStorage(IFluidTransfer transfer) {
        this.transfer = transfer;
    }

    protected void releaseSnapshot(Object snapshot) {
        super.releaseSnapshot(snapshot);
    }

    protected void onFinalCommit() {
        this.transfer.onContentsChanged();
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        long filled = this.transfer.fill(FluidStack.create(resource.getFluid(), maxAmount, resource.getNbt()), true, false);
        if (filled != 0L) {
            this.updateSnapshots(transaction);
            return this.transfer.fill(FluidStack.create(resource.getFluid(), maxAmount, resource.getNbt()), false, false);
        }
        return filled;
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        long drained = this.transfer.drain(FluidStack.create(resource.getFluid(), maxAmount, resource.getNbt()), true, false).getAmount();
        if (drained != 0L) {
            this.updateSnapshots(transaction);
            return this.transfer.drain(FluidStack.create(resource.getFluid(), maxAmount, resource.getNbt()), false, false).getAmount();
        }
        return drained;
    }

    public long simulateInsert(FluidVariant resource, long maxAmount, @Nullable TransactionContext transaction) {
        return this.transfer.fill(FluidStack.create(resource.getFluid(), maxAmount, resource.getNbt()), true, false);
    }

    public long simulateExtract(FluidVariant resource, long maxAmount, @Nullable TransactionContext transaction) {
        return this.transfer.drain(FluidStack.create(resource.getFluid(), maxAmount, resource.getNbt()), true, false).getAmount();
    }

    public boolean supportsInsertion() {
        for (int i = 0; i < this.transfer.getTanks(); ++i) {
            if (!this.transfer.supportsFill(i)) continue;
            return true;
        }
        return false;
    }

    public boolean supportsExtraction() {
        for (int i = 0; i < this.transfer.getTanks(); ++i) {
            if (!this.transfer.supportsDrain(i)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public Iterator<StorageView<FluidVariant>> iterator() {
        ArrayList<FluidStorageView> views = new ArrayList<FluidStorageView>();
        for (int i = 0; i < this.transfer.getTanks(); ++i) {
            views.add(new FluidStorageView(i));
        }
        return views.iterator();
    }

    protected Object createSnapshot() {
        return this.transfer.createSnapshot();
    }

    protected void readSnapshot(Object snapshot) {
        this.transfer.restoreFromSnapshot(snapshot);
    }

    private class FluidStorageView
    extends SnapshotParticipant<FluidStack>
    implements StorageView<FluidVariant> {
        private final int index;

        private FluidStorageView(int index) {
            this.index = index;
        }

        protected void onFinalCommit() {
            FluidTransferProxyStorage.this.transfer.onContentsChanged();
        }

        public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            if (!FluidTransferProxyStorage.this.transfer.supportsDrain(this.index)) {
                return 0L;
            }
            StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
            long drained = FluidTransferProxyStorage.this.transfer.drain(this.index, FluidStack.create(resource.getFluid(), maxAmount, resource.getNbt()), true, false).getAmount();
            if (drained != 0L) {
                this.updateSnapshots(transaction);
                return FluidTransferProxyStorage.this.transfer.drain(FluidStack.create(resource.getFluid(), maxAmount, resource.getNbt()), false, false).getAmount();
            }
            return 0L;
        }

        public boolean isResourceBlank() {
            return FluidTransferProxyStorage.this.transfer.getFluidInTank(this.index).isEmpty();
        }

        public FluidVariant getResource() {
            return FluidHelperImpl.toFluidVariant(FluidTransferProxyStorage.this.transfer.getFluidInTank(this.index));
        }

        public long getAmount() {
            return FluidTransferProxyStorage.this.transfer.getFluidInTank(this.index).getAmount();
        }

        public long getCapacity() {
            return FluidTransferProxyStorage.this.transfer.getTankCapacity(this.index);
        }

        protected FluidStack createSnapshot() {
            return FluidTransferProxyStorage.this.transfer.getFluidInTank(this.index).copy();
        }

        protected void readSnapshot(FluidStack snapshot) {
            FluidTransferProxyStorage.this.transfer.setFluidInTank(this.index, snapshot);
        }
    }
}

