/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.side.fluid.fabric;

import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.fluid.fabric.FluidStorageProxyFluidTransfer;
import com.lowdragmc.lowdraglib.side.fluid.fabric.FluidTransferProxyStorage;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.fabric.ItemTransferHelperImpl;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class FluidTransferHelperImpl {
    public static Storage<FluidVariant> toFluidVariantStorage(IFluidTransfer fluidTransfer) {
        return new FluidTransferProxyStorage(fluidTransfer);
    }

    public static IFluidTransfer toFluidTransfer(Storage<FluidVariant> storage) {
        return new FluidStorageProxyFluidTransfer(storage);
    }

    public static IFluidTransfer getFluidTransfer(class_1937 level, class_2338 pos, @Nullable class_2350 direction) {
        Storage storage = (Storage)FluidStorage.SIDED.find(level, pos, (Object)direction);
        return storage == null ? null : FluidTransferHelperImpl.toFluidTransfer((Storage<FluidVariant>)storage);
    }

    public static IFluidTransfer getFluidTransfer(IItemTransfer itemTransfer, int slot) {
        ContainerItemContext handContext = ContainerItemContext.ofSingleSlot((SingleSlotStorage)ItemTransferHelperImpl.toSingleStackStorage(itemTransfer, slot));
        Storage storage = (Storage)handContext.find(FluidStorage.ITEM);
        return storage == null ? null : FluidTransferHelperImpl.toFluidTransfer((Storage<FluidVariant>)storage);
    }

    public static IFluidTransfer getFluidTransfer(class_1657 player, class_1703 screenHandler) {
        ContainerItemContext handContext = ContainerItemContext.ofPlayerCursor((class_1657)player, (class_1703)screenHandler);
        Storage storage = (Storage)handContext.find(FluidStorage.ITEM);
        return storage == null ? null : FluidTransferHelperImpl.toFluidTransfer((Storage<FluidVariant>)storage);
    }

    public static IFluidTransfer getFluidTransfer(class_1657 player, class_1268 hand) {
        ContainerItemContext handContext = ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand);
        Storage storage = (Storage)handContext.find(FluidStorage.ITEM);
        return storage == null ? null : FluidTransferHelperImpl.toFluidTransfer((Storage<FluidVariant>)storage);
    }

    public static IFluidTransfer getFluidTransfer(class_1657 player, int slot) {
        ContainerItemContext handContext = ContainerItemContext.ofPlayerSlot((class_1657)player, (SingleSlotStorage)PlayerInventoryStorage.of((class_1657)player).getSlot(slot));
        Storage storage = (Storage)handContext.find(FluidStorage.ITEM);
        return storage == null ? null : FluidTransferHelperImpl.toFluidTransfer((Storage<FluidVariant>)storage);
    }

    public static class_1799 getContainerItem(ItemStackTransfer copyContainer, IFluidTransfer handler) {
        return copyContainer.getStackInSlot(0);
    }

    public static void exportToTarget(IFluidTransfer source, int maxAmount, Predicate<FluidStack> filter, class_1937 level, class_2338 pos, @Nullable class_2350 direction) {
        Storage target = (Storage)FluidStorage.SIDED.find(level, pos, (Object)direction);
        if (target != null) {
            StorageUtil.move(FluidTransferHelperImpl.toFluidVariantStorage(source), (Storage)target, variant -> {
                if (filter == null) {
                    return true;
                }
                return filter.test(FluidStack.create(variant.getFluid(), 1000L, variant.getNbt()));
            }, (long)maxAmount, null);
        }
    }

    public static void importToTarget(IFluidTransfer target, int maxAmount, Predicate<FluidStack> filter, class_1937 level, class_2338 pos, @Nullable class_2350 direction) {
        Storage source = (Storage)FluidStorage.SIDED.find(level, pos, (Object)direction);
        if (source != null) {
            StorageUtil.move((Storage)source, FluidTransferHelperImpl.toFluidVariantStorage(target), variant -> {
                if (filter == null) {
                    return true;
                }
                return filter.test(FluidStack.create(variant.getFluid(), 1000L, variant.getNbt()));
            }, (long)maxAmount, null);
        }
    }
}

