/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.side.fluid.fabric;

import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.fluid.fabric.FluidHelperImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.NotNull;

class FluidStorageProxyFluidTransfer
implements IFluidTransfer {
    private final List<StorageView<FluidVariant>> views;
    private final Storage<FluidVariant> storage;

    public FluidStorageProxyFluidTransfer(Storage<FluidVariant> storage) {
        Iterator iter = storage.iterator();
        this.views = new ArrayList<StorageView<FluidVariant>>();
        while (iter.hasNext()) {
            this.views.add((StorageView<FluidVariant>)((StorageView)iter.next()));
        }
        this.storage = storage;
    }

    @Override
    public int getTanks() {
        return this.views.size();
    }

    @Override
    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return FluidHelperImpl.toFluidStack(this.views.get(tank));
    }

    @Override
    public void setFluidInTank(int tank, @NotNull FluidStack fluidStack) {
        throw new NotImplementedException("Try to set fluid of the proxy transfer in a specific tank.");
    }

    @Override
    public long getTankCapacity(int tank) {
        return this.views.get(tank).getCapacity();
    }

    @Override
    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        boolean result;
        try (Transaction transaction = Transaction.openNested((TransactionContext)Transaction.getCurrentUnsafe());){
            result = this.storage.simulateExtract((Object)FluidHelperImpl.toFluidVariant(stack), stack.getAmount(), (TransactionContext)transaction) > 0L;
        }
        return result;
    }

    @Override
    public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        throw new NotImplementedException("Try to fill the proxy transfer with a specific tank.");
    }

    @Override
    @NotNull
    public FluidStack drain(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        if (tank >= 0 && tank < this.views.size()) {
            long drained;
            StorageView<FluidVariant> storage = this.views.get(tank);
            try (Transaction transaction = Transaction.openNested((TransactionContext)Transaction.getCurrentUnsafe());){
                drained = storage.extract((Object)FluidHelperImpl.toFluidVariant(resource), resource.getAmount(), (TransactionContext)transaction);
                if (!simulate && drained > 0L) {
                    transaction.commit();
                }
            }
            return resource.copy(drained);
        }
        return FluidStack.empty();
    }

    @Override
    public long fill(FluidStack resource, boolean simulate, boolean notifyChanges) {
        long filled;
        if (resource.isEmpty()) {
            return 0L;
        }
        try (Transaction transaction = Transaction.openNested((TransactionContext)Transaction.getCurrentUnsafe());){
            filled = this.storage.insert((Object)FluidHelperImpl.toFluidVariant(resource), resource.getAmount(), (TransactionContext)transaction);
            if (!simulate && filled > 0L) {
                transaction.commit();
            }
        }
        return filled;
    }

    @Override
    @NotNull
    public FluidStack drain(FluidStack resource, boolean simulate, boolean notifyChanges) {
        if (resource.isEmpty()) {
            return FluidStack.empty();
        }
        FluidStack copied = resource.copy();
        try (Transaction transaction = Transaction.openNested((TransactionContext)Transaction.getCurrentUnsafe());){
            long extracted = this.storage.extract((Object)FluidHelperImpl.toFluidVariant(resource), resource.getAmount(), (TransactionContext)transaction);
            copied.setAmount(extracted);
            if (!simulate && extracted > 0L) {
                transaction.commit();
            }
        }
        return copied;
    }

    @Override
    public boolean supportsFill(int tank) {
        return this.storage.supportsInsertion();
    }

    @Override
    public boolean supportsDrain(int tank) {
        return this.storage.supportsExtraction();
    }

    @Override
    @NotNull
    public Object createSnapshot() {
        throw new NotImplementedException("Try to create a snapshot for a proxy transfer.");
    }

    @Override
    public void restoreFromSnapshot(Object snapshot) {
        throw new NotImplementedException("Try to restore a snapshot for a proxy transfer.");
    }
}

