/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.side.fluid;

import com.google.common.base.Preconditions;
import com.lowdragmc.lowdraglib.misc.BucketPickupTransfer;
import com.lowdragmc.lowdraglib.misc.ContainerTransfer;
import com.lowdragmc.lowdraglib.misc.FluidBlockTransfer;
import com.lowdragmc.lowdraglib.misc.ItemHandlerHelper;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.misc.LiquidBlockContainerTransfer;
import com.lowdragmc.lowdraglib.side.fluid.FluidActionResult;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.fluid.fabric.FluidTransferHelperImpl;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2402;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;

public class FluidTransferHelper {
    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IFluidTransfer getFluidTransfer(class_1937 level, class_2338 pos, @Nullable class_2350 direction) {
        void var2_2;
        void var1_1;
        return FluidTransferHelperImpl.getFluidTransfer(level, (class_2338)var1_1, (class_2350)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IFluidTransfer getFluidTransfer(IItemTransfer itemTransfer, int slot) {
        void var1_1;
        return FluidTransferHelperImpl.getFluidTransfer(itemTransfer, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IFluidTransfer getFluidTransfer(class_1657 player, class_1703 screenHandler) {
        void var1_1;
        return FluidTransferHelperImpl.getFluidTransfer(player, (class_1703)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IFluidTransfer getFluidTransfer(class_1657 player, class_1268 hand) {
        void var1_1;
        return FluidTransferHelperImpl.getFluidTransfer(player, (class_1268)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IFluidTransfer getFluidTransfer(class_1657 player, int slot) {
        void var1_1;
        return FluidTransferHelperImpl.getFluidTransfer(player, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void exportToTarget(IFluidTransfer source, int maxAmount, Predicate<FluidStack> filter, class_1937 level, class_2338 pos, @Nullable class_2350 direction) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        FluidTransferHelperImpl.exportToTarget(source, (int)var1_1, (Predicate<FluidStack>)var2_2, (class_1937)var3_3, (class_2338)var4_4, (class_2350)var5_5);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void importToTarget(IFluidTransfer target, int maxAmount, Predicate<FluidStack> filter, class_1937 level, class_2338 pos, @Nullable class_2350 direction) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        FluidTransferHelperImpl.importToTarget(target, (int)var1_1, (Predicate<FluidStack>)var2_2, (class_1937)var3_3, (class_2338)var4_4, (class_2350)var5_5);
    }

    @Deprecated
    public static IFluidTransfer getFluidTransfer(@NotNull class_1799 itemStack) {
        return FluidTransferHelper.getFluidTransfer(new ItemStackTransfer(itemStack), 0);
    }

    public static boolean interactWithFluidHandler(@Nonnull class_1657 player, @Nonnull class_1268 hand, @Nonnull class_1937 level, @Nonnull class_2338 pos, @Nullable class_2350 side) {
        Preconditions.checkNotNull((Object)level);
        Preconditions.checkNotNull((Object)pos);
        IFluidTransfer handler = FluidTransferHelper.getFluidTransfer(level, pos, side);
        if (handler != null) {
            return FluidTransferHelper.interactWithFluidHandler(player, hand, handler);
        }
        return false;
    }

    public static boolean interactWithFluidHandler(@Nonnull class_1657 player, @Nonnull class_1268 hand, @Nonnull IFluidTransfer handler) {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)hand);
        Preconditions.checkNotNull((Object)handler);
        class_1799 heldItem = player.method_5998(hand);
        if (!heldItem.method_7960()) {
            ContainerTransfer playerInventory = new ContainerTransfer((class_1263)player.method_31548());
            FluidActionResult fluidActionResult = FluidTransferHelper.tryFillContainerAndStow(heldItem, handler, playerInventory, Integer.MAX_VALUE, player, true);
            if (!fluidActionResult.isSuccess()) {
                fluidActionResult = FluidTransferHelper.tryEmptyContainerAndStow(heldItem, handler, playerInventory, Integer.MAX_VALUE, player, true);
            }
            if (fluidActionResult.isSuccess()) {
                player.method_6122(hand, fluidActionResult.getResult());
                return true;
            }
            return false;
        }
        return false;
    }

    @Nonnull
    public static FluidActionResult tryFillContainer(@Nonnull class_1799 container, IFluidTransfer fluidSource, int maxAmount, @Nullable class_1657 player, boolean doFill) {
        FluidStack simulatedTransfer;
        class_1799 containerCopy = ItemTransferHelper.copyStackWithSize(container, 1);
        ItemStackTransfer itemStorage = new ItemStackTransfer(containerCopy);
        IFluidTransfer handler = FluidTransferHelper.getFluidTransfer(itemStorage, 0);
        if (handler != null && !(simulatedTransfer = FluidTransferHelper.tryFluidTransfer(handler, fluidSource, maxAmount, false)).isEmpty()) {
            if (doFill) {
                class_3414 soundevent;
                FluidTransferHelper.tryFluidTransfer(handler, fluidSource, maxAmount, true);
                if (player != null && (soundevent = FluidHelper.getFillSound(simulatedTransfer)) != null) {
                    player.method_37908().method_43128(null, player.method_23317(), player.method_23318() + 0.5, player.method_23321(), soundevent, class_3419.field_15245, 1.0f, 1.0f);
                }
            } else {
                handler.fill(simulatedTransfer, true);
            }
            return new FluidActionResult(FluidTransferHelper.getContainerItem(itemStorage, handler));
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    public static FluidActionResult tryEmptyContainer(@Nonnull class_1799 container, IFluidTransfer fluidDestination, int maxAmount, @Nullable class_1657 player, boolean doDrain) {
        class_1799 containerCopy = ItemTransferHelper.copyStackWithSize(container, 1);
        ItemStackTransfer itemStorage = new ItemStackTransfer(containerCopy);
        IFluidTransfer handler = FluidTransferHelper.getFluidTransfer(itemStorage, 0);
        if (handler != null) {
            class_3414 soundevent;
            FluidStack transfer = FluidTransferHelper.tryFluidTransfer(fluidDestination, handler, maxAmount, doDrain);
            if (transfer.isEmpty()) {
                return FluidActionResult.FAILURE;
            }
            if (doDrain && player != null && (soundevent = FluidHelper.getEmptySound(transfer)) != null) {
                player.method_37908().method_43128(null, player.method_23317(), player.method_23318() + 0.5, player.method_23321(), soundevent, class_3419.field_15245, 1.0f, 1.0f);
            }
            return new FluidActionResult(FluidTransferHelper.getContainerItem(itemStorage, handler));
        }
        return FluidActionResult.FAILURE;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_1799 getContainerItem(ItemStackTransfer copyContainer, IFluidTransfer handler) {
        void var1_1;
        return FluidTransferHelperImpl.getContainerItem(copyContainer, (IFluidTransfer)var1_1);
    }

    @Nonnull
    public static FluidActionResult tryFillContainerAndStow(@Nonnull class_1799 container, IFluidTransfer fluidSource, IItemTransfer inventory, int maxAmount, @Nullable class_1657 player, boolean doFill) {
        if (container.method_7960()) {
            return FluidActionResult.FAILURE;
        }
        if (player != null && player.method_31549().field_7477) {
            FluidActionResult filledReal = FluidTransferHelper.tryFillContainer(container, fluidSource, maxAmount, player, doFill);
            if (filledReal.isSuccess()) {
                return new FluidActionResult(container);
            }
        } else if (container.method_7947() == 1) {
            FluidActionResult filledReal = FluidTransferHelper.tryFillContainer(container, fluidSource, maxAmount, player, doFill);
            if (filledReal.isSuccess()) {
                return filledReal;
            }
        } else {
            class_1799 remainder;
            FluidActionResult filledSimulated = FluidTransferHelper.tryFillContainer(container, fluidSource, maxAmount, player, false);
            if (filledSimulated.isSuccess() && ((remainder = ItemTransferHelper.insertItemStacked(inventory, filledSimulated.getResult(), true)).method_7960() || player != null)) {
                FluidActionResult filledReal = FluidTransferHelper.tryFillContainer(container, fluidSource, maxAmount, player, doFill);
                remainder = ItemTransferHelper.insertItemStacked(inventory, filledReal.getResult(), !doFill);
                if (!remainder.method_7960() && player != null && doFill) {
                    ItemTransferHelper.giveItemToPlayer(player, remainder);
                }
                class_1799 containerCopy = container.method_7972();
                containerCopy.method_7934(1);
                return new FluidActionResult(containerCopy);
            }
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    public static FluidActionResult tryEmptyContainerAndStow(@Nonnull class_1799 container, IFluidTransfer fluidDestination, IItemTransfer inventory, int maxAmount, @Nullable class_1657 player, boolean doDrain) {
        if (container.method_7960()) {
            return FluidActionResult.FAILURE;
        }
        if (player != null && player.method_31549().field_7477) {
            FluidActionResult emptiedReal = FluidTransferHelper.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
            if (emptiedReal.isSuccess()) {
                return new FluidActionResult(container);
            }
        } else if (container.method_7947() == 1) {
            FluidActionResult emptiedReal = FluidTransferHelper.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
            if (emptiedReal.isSuccess()) {
                return emptiedReal;
            }
        } else {
            class_1799 remainder;
            FluidActionResult emptiedSimulated = FluidTransferHelper.tryEmptyContainer(container, fluidDestination, maxAmount, player, false);
            if (emptiedSimulated.isSuccess() && ((remainder = ItemTransferHelper.insertItemStacked(inventory, emptiedSimulated.getResult(), true)).method_7960() || player != null)) {
                FluidActionResult emptiedReal = FluidTransferHelper.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
                remainder = ItemTransferHelper.insertItemStacked(inventory, emptiedReal.getResult(), !doDrain);
                if (!remainder.method_7960() && player != null && doDrain) {
                    ItemTransferHelper.giveItemToPlayer(player, remainder);
                }
                class_1799 containerCopy = container.method_7972();
                containerCopy.method_7934(1);
                return new FluidActionResult(containerCopy);
            }
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    public static FluidStack tryFluidTransfer(IFluidTransfer fluidDestination, IFluidTransfer fluidSource, int maxAmount, boolean doTransfer) {
        FluidStack drainable = fluidSource.drain(maxAmount, true);
        if (!drainable.isEmpty()) {
            return FluidTransferHelper.tryFluidTransfer_Internal(fluidDestination, fluidSource, drainable, doTransfer);
        }
        return FluidStack.empty();
    }

    @Nonnull
    public static FluidStack tryFluidTransfer(IFluidTransfer fluidDestination, IFluidTransfer fluidSource, FluidStack resource, boolean doTransfer) {
        FluidStack drainable = fluidSource.drain(resource, true);
        if (!drainable.isEmpty() && resource.isFluidEqual(drainable)) {
            return FluidTransferHelper.tryFluidTransfer_Internal(fluidDestination, fluidSource, drainable, doTransfer);
        }
        return FluidStack.empty();
    }

    @Nonnull
    private static FluidStack tryFluidTransfer_Internal(IFluidTransfer fluidDestination, IFluidTransfer fluidSource, FluidStack drainable, boolean doTransfer) {
        long fillableAmount = fluidDestination.fill(drainable, true);
        if (fillableAmount > 0L) {
            drainable.setAmount(fillableAmount);
            FluidStack drained = fluidSource.drain(drainable, !doTransfer);
            if (!drained.isEmpty()) {
                drained.setAmount(fluidDestination.fill(drained, !doTransfer));
                return drained;
            }
        }
        return FluidStack.empty();
    }

    public static FluidStack getFluidContained(@Nonnull class_1799 container) {
        FluidStack contained;
        IFluidTransfer handler;
        if (!container.method_7960() && (handler = FluidTransferHelper.getFluidTransfer(new ItemStackTransfer(container = ItemTransferHelper.copyStackWithSize(container, 1)), 0)) != null && !(contained = handler.drain(Integer.MAX_VALUE, true)).isEmpty()) {
            return contained;
        }
        return null;
    }

    @Nonnull
    public static FluidActionResult tryPickUpFluid(@Nonnull class_1799 emptyContainer, @Nullable class_1657 playerIn, class_1937 level, class_2338 pos, class_2350 side) {
        IFluidTransfer targetFluidHandler;
        if (emptyContainer.method_7960() || level == null || pos == null) {
            return FluidActionResult.FAILURE;
        }
        class_2680 state = level.method_8320(pos);
        class_2248 block = state.method_26204();
        if (block instanceof class_2404) {
            class_2404 fluidBlock = (class_2404)block;
            targetFluidHandler = new FluidBlockTransfer(fluidBlock, level, pos);
        } else if (block instanceof class_2263) {
            targetFluidHandler = new BucketPickupTransfer((class_2263)block, level, pos);
        } else {
            IFluidTransfer fluidHandler = FluidTransferHelper.getFluidTransfer(level, pos, side);
            if (fluidHandler != null) {
                return FluidActionResult.FAILURE;
            }
            targetFluidHandler = fluidHandler;
        }
        return FluidTransferHelper.tryFillContainer(emptyContainer, targetFluidHandler, Integer.MAX_VALUE, playerIn, true);
    }

    @Nonnull
    public static FluidActionResult tryPlaceFluid(@Nullable class_1657 player, class_1937 level, class_1268 hand, class_2338 pos, @Nonnull class_1799 container, FluidStack resource) {
        class_1799 containerCopy = ItemHandlerHelper.copyStackWithSize(container, 1);
        ItemStackTransfer itemStorage = new ItemStackTransfer(containerCopy);
        IFluidTransfer handler = FluidTransferHelper.getFluidTransfer(itemStorage, 0);
        if (handler != null && FluidTransferHelper.tryPlaceFluid(player, level, hand, pos, handler, resource)) {
            return new FluidActionResult(itemStorage.getStackInSlot(0));
        }
        return FluidActionResult.FAILURE;
    }

    public static boolean tryPlaceFluid(@Nullable class_1657 player, class_1937 level, class_1268 hand, class_2338 pos, IFluidTransfer fluidSource, FluidStack resource) {
        boolean canDestContainFluid;
        if (level == null || pos == null) {
            return false;
        }
        class_3611 fluid = resource.getFluid();
        if (fluid == class_3612.field_15906 || !FluidHelper.canBePlacedInWorld(resource, (class_1920)level, pos)) {
            return false;
        }
        if (fluidSource.drain(resource, true).isEmpty()) {
            return false;
        }
        class_1750 context = new class_1750(new class_1838(player, hand, new class_3965(class_243.field_1353, class_2350.field_11036, pos, false)));
        class_2680 destBlockState = level.method_8320(pos);
        boolean isDestReplaceable = destBlockState.method_26166(context);
        boolean bl = canDestContainFluid = destBlockState.method_26204() instanceof class_2402 && ((class_2402)destBlockState.method_26204()).method_10310((class_1922)level, pos, destBlockState, fluid);
        if (!(level.method_22347(pos) || isDestReplaceable || canDestContainFluid)) {
            return false;
        }
        if (level.method_8597().comp_644() && FluidHelper.doesVaporize(resource, level, pos)) {
            FluidStack result = fluidSource.drain(resource, false);
            if (!result.isEmpty()) {
                return true;
            }
        } else {
            IFluidTransfer handler = canDestContainFluid ? new LiquidBlockContainerTransfer((class_2402)destBlockState.method_26204(), level, pos) : FluidTransferHelper.getFluidBlockHandler(fluid, level, pos);
            FluidStack result = FluidTransferHelper.tryFluidTransfer(handler, fluidSource, resource, true);
            if (!result.isEmpty()) {
                class_3414 soundevent = FluidHelper.getEmptySound(resource);
                if (soundevent != null) {
                    level.method_8396(player, pos, soundevent, class_3419.field_15245, 1.0f, 1.0f);
                }
                return true;
            }
        }
        return false;
    }

    private static IFluidTransfer getFluidBlockHandler(class_3611 fluid, class_1937 level, class_2338 pos) {
        class_2680 state = fluid.method_15785().method_15759();
        return new LiquidBlockContainerTransfer.BlockWrapper(state, level, pos);
    }

    public static void destroyBlockOnFluidPlacement(class_1937 level, class_2338 pos) {
        if (!level.field_9236) {
            level.method_22352(pos, true);
        }
    }

    public static long transferFluids(@Nonnull IFluidTransfer sourceHandler, @Nonnull IFluidTransfer destHandler, long transferLimit, @Nonnull Predicate<FluidStack> fluidFilter) {
        long fluidLeftToTransfer = transferLimit;
        for (int i = 0; i < sourceHandler.getTanks(); ++i) {
            long canInsertAmount;
            FluidStack currentFluid = sourceHandler.getFluidInTank(i).copy();
            if (currentFluid.isEmpty() || !fluidFilter.test(currentFluid)) continue;
            currentFluid.setAmount(fluidLeftToTransfer);
            FluidStack drained = sourceHandler.drain(currentFluid, true);
            if (drained.isEmpty() || (canInsertAmount = destHandler.fill(drained.copy(), true)) <= 0L) continue;
            drained.setAmount(canInsertAmount);
            drained = sourceHandler.drain(drained, false);
            if (drained.isEmpty()) continue;
            destHandler.fill(drained, false);
            if ((fluidLeftToTransfer -= drained.getAmount()) == 0L) break;
        }
        return transferLimit - fluidLeftToTransfer;
    }
}

