/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.side.fluid;

import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7923;

public class FluidStack {
    private static final FluidStack EMPTY = new FluidStack(class_3612.field_15906, 0L, null);
    private boolean isEmpty;
    private long amount;
    private class_2487 tag;
    private class_3611 fluid;

    public static FluidStack empty() {
        return EMPTY;
    }

    public static FluidStack create(class_3611 fluid, long amount, class_2487 nbt) {
        return new FluidStack(fluid, amount, nbt);
    }

    public static FluidStack create(class_3611 fluid, long amount) {
        return FluidStack.create(fluid, amount, null);
    }

    public static FluidStack create(FluidStack stack, long amount) {
        return FluidStack.create(stack.getFluid(), amount, stack.getTag());
    }

    private FluidStack(class_3611 fluid, long amount, class_2487 nbt) {
        this.fluid = fluid;
        this.amount = amount;
        if (nbt != null) {
            this.tag = nbt.method_10553();
        }
        this.updateEmpty();
    }

    public static FluidStack loadFromTag(class_2487 nbt) {
        if (nbt == null) {
            return EMPTY;
        }
        if (!nbt.method_10573("FluidName", 8)) {
            return EMPTY;
        }
        class_2960 fluidName = new class_2960(nbt.method_10558("FluidName"));
        class_3611 fluid = (class_3611)class_7923.field_41173.method_10223(fluidName);
        if (fluid == class_3612.field_15906) {
            return EMPTY;
        }
        FluidStack stack = FluidStack.create(fluid, nbt.method_10537("Amount"));
        if (nbt.method_10573("Tag", 10)) {
            stack.setTag(nbt.method_10562("Tag"));
        }
        return stack;
    }

    public static FluidStack readFromBuf(class_2540 buf) {
        class_3611 fluid = (class_3611)class_7923.field_41173.method_10223(new class_2960(buf.method_19772()));
        int amount = buf.method_10816();
        class_2487 tag = buf.method_10798();
        if (fluid == class_3612.field_15906) {
            return EMPTY;
        }
        return FluidStack.create(fluid, amount, tag);
    }

    protected void updateEmpty() {
        this.isEmpty = this.getRawFluid() == class_3612.field_15906 || this.amount <= 0L;
    }

    public class_2487 saveToTag(class_2487 nbt) {
        nbt.method_10582("FluidName", class_7923.field_41173.method_10221((Object)this.fluid).toString());
        nbt.method_10544("Amount", this.amount);
        if (this.tag != null) {
            nbt.method_10566("Tag", (class_2520)this.tag);
        }
        return nbt;
    }

    public void writeToBuf(class_2540 buf) {
        buf.method_10814(class_7923.field_41173.method_10221((Object)this.fluid).toString());
        buf.method_10791(this.getAmount());
        buf.method_10794(this.tag);
    }

    public class_3611 getFluid() {
        return this.isEmpty ? class_3612.field_15906 : this.fluid;
    }

    public final class_3611 getRawFluid() {
        return this.fluid;
    }

    public long getAmount() {
        return this.isEmpty ? 0L : this.amount;
    }

    public void setAmount(long amount) {
        if (this.fluid == class_3612.field_15906) {
            throw new IllegalStateException("Can't modify the empty stack.");
        }
        this.amount = amount;
        this.updateEmpty();
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    public class_2487 getTag() {
        return this.tag;
    }

    public void setTag(class_2487 tag) {
        if (this.getRawFluid() == class_3612.field_15906) {
            throw new IllegalStateException("Can't modify the empty stack.");
        }
        this.tag = tag;
    }

    public boolean isEmpty() {
        return this.getAmount() == 0L || this == FluidStack.empty();
    }

    public class_2561 getDisplayName() {
        return FluidHelper.getDisplayName(this);
    }

    public FluidStack copy() {
        return FluidStack.create(this.getFluid(), this.getAmount(), this.getTag());
    }

    public FluidStack copy(long amount) {
        return FluidStack.create(this.getFluid(), amount, this.getTag());
    }

    public boolean isFluidEqual(@Nonnull FluidStack other) {
        return this.getFluid() == other.getFluid() && Objects.equals(this.getTag(), other.getTag());
    }

    public boolean isFluidStackEqual(@Nonnull FluidStack other) {
        return this.isFluidEqual(other) && this.getAmount() == other.getAmount();
    }

    public void grow(long amount) {
        this.setAmount(this.getAmount() + amount);
    }

    public void shrink(long amount) {
        this.setAmount(this.getAmount() - amount);
    }

    public void setFluid(class_3611 fluid) {
        this.fluid = fluid;
    }
}

