/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.pipelike;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.pipelike.Node;
import com.lowdragmc.lowdraglib.pipelike.PipeNet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;

public abstract class PipeNetWalker<NodeDataType, Net extends PipeNet<NodeDataType>> {
    protected PipeNetWalker<NodeDataType, Net> root;
    protected final Net pipeNet;
    protected final Set<Long> walked = new HashSet<Long>();
    protected final List<class_2350> pipes = new ArrayList<class_2350>();
    protected List<PipeNetWalker<NodeDataType, Net>> walkers;
    protected final class_2338.class_2339 currentPos;
    private int walkedBlocks;
    private boolean invalid;
    private boolean running;

    protected PipeNetWalker(Net pipeNet, class_2338 sourcePipe, int walkedBlocks) {
        this.pipeNet = pipeNet;
        this.walkedBlocks = walkedBlocks;
        this.currentPos = sourcePipe.method_25503();
        this.root = this;
    }

    @Nonnull
    protected abstract PipeNetWalker<NodeDataType, Net> createSubWalker(Net var1, class_2338 var2, int var3);

    protected void checkNeighbour(Node<NodeDataType> pipeNode, class_2338 pipePos, class_2350 faceToNeighbour) {
    }

    protected boolean checkPipe(Node<NodeDataType> pipeNode, class_2338 pos) {
        return true;
    }

    protected void onRemoveSubWalker(PipeNetWalker<NodeDataType, Net> subWalker) {
    }

    public void traversePipeNet() {
        this.traversePipeNet(32768);
    }

    public void traversePipeNet(int maxWalks) {
        if (this.invalid) {
            throw new IllegalStateException("This walker already walked. Create a new one if you want to walk again");
        }
        int i = 0;
        this.running = true;
        while (this.running && !this.walk() && i++ < maxWalks) {
        }
        this.running = false;
        this.root.walked.clear();
        if (i >= maxWalks) {
            LDLib.LOGGER.warn("The walker reached the maximum amount of walks {}", (Object)i);
        }
        this.invalid = true;
    }

    private boolean walk() {
        if (this.walkers == null) {
            this.checkPos();
            if (this.pipes.size() == 0) {
                return true;
            }
            if (this.pipes.size() == 1) {
                this.currentPos.method_10098(this.pipes.get(0));
                ++this.walkedBlocks;
                return !this.isRunning();
            }
            this.walkers = new ArrayList<PipeNetWalker<NodeDataType, Net>>();
            for (class_2350 side : this.pipes) {
                PipeNetWalker<NodeDataType, Net> walker = this.createSubWalker(this.pipeNet, this.currentPos.method_10093(side), this.walkedBlocks + 1);
                walker.root = this.root;
                this.walkers.add(walker);
            }
        }
        Iterator<PipeNetWalker<NodeDataType, Net>> iterator = this.walkers.iterator();
        while (iterator.hasNext()) {
            PipeNetWalker<NodeDataType, Net> walker = iterator.next();
            if (!walker.walk()) continue;
            this.onRemoveSubWalker(walker);
            iterator.remove();
        }
        return !this.isRunning() || this.walkers.size() == 0;
    }

    private void checkPos() {
        this.pipes.clear();
        Node pipeNode = ((PipeNet)this.pipeNet).getNodeAt((class_2338)this.currentPos);
        if (pipeNode != null) {
            if (!this.checkPipe(((PipeNet)this.pipeNet).getNodeAt((class_2338)this.currentPos), (class_2338)this.currentPos)) {
                return;
            }
            this.root.walked.add(this.currentPos.method_10063());
            for (class_2350 accessSide : class_2350.values()) {
                if (this.isWalked(this.currentPos.method_10093(accessSide)) || pipeNode.isBlocked(accessSide)) continue;
                if (((PipeNet)this.pipeNet).isNodeConnectedTo((class_2338)this.currentPos, accessSide)) {
                    this.pipes.add(accessSide);
                    continue;
                }
                this.checkNeighbour(pipeNode, (class_2338)this.currentPos, accessSide);
            }
        }
    }

    protected boolean isWalked(class_2338 pos) {
        return this.root.walked.contains(pos.method_10063());
    }

    public void stop() {
        this.root.running = false;
    }

    public boolean isRunning() {
        return this.root.running;
    }

    public class_3218 getLevel() {
        return ((PipeNet)this.pipeNet).getLevel();
    }

    public class_2338 getCurrentPos() {
        return this.currentPos.method_10062();
    }

    public int getWalkedBlocks() {
        return this.walkedBlocks;
    }

    public boolean isInvalid() {
        return this.invalid;
    }
}

