/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.pipelike;

import com.lowdragmc.lowdraglib.pipelike.LevelPipeNet;
import com.lowdragmc.lowdraglib.pipelike.Node;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;

public abstract class PipeNet<NodeDataType>
implements ITagSerializable<class_2487> {
    protected final LevelPipeNet<NodeDataType, PipeNet<NodeDataType>> worldData;
    private final Map<class_2338, Node<NodeDataType>> nodeByBlockPos = new HashMap<class_2338, Node<NodeDataType>>();
    private final Map<class_2338, Node<NodeDataType>> unmodifiableNodeByBlockPos = Collections.unmodifiableMap(this.nodeByBlockPos);
    private final Map<class_1923, Integer> ownedChunks = new HashMap<class_1923, Integer>();
    private long lastUpdate;
    boolean isValid = false;

    public PipeNet(LevelPipeNet<NodeDataType, ? extends PipeNet> Level2) {
        this.worldData = Level2;
    }

    public Set<class_1923> getContainedChunks() {
        return Collections.unmodifiableSet(this.ownedChunks.keySet());
    }

    public LevelPipeNet<NodeDataType, PipeNet<NodeDataType>> getWorldData() {
        return this.worldData;
    }

    public class_3218 getLevel() {
        return this.worldData.getWorld();
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void onNodeConnectionsUpdate() {
        this.lastUpdate = System.currentTimeMillis();
    }

    protected void onNodeDataUpdate() {
    }

    protected void onPipeConnectionsUpdate() {
    }

    public void onNeighbourUpdate(class_2338 fromPos) {
    }

    public Map<class_2338, Node<NodeDataType>> getAllNodes() {
        return this.unmodifiableNodeByBlockPos;
    }

    public Node<NodeDataType> getNodeAt(class_2338 blockPos) {
        return this.nodeByBlockPos.get(blockPos);
    }

    public boolean containsNode(class_2338 blockPos) {
        return this.nodeByBlockPos.containsKey(blockPos);
    }

    public boolean isNodeConnectedTo(class_2338 pos, class_2350 side) {
        Node<NodeDataType> nodeFirst = this.getNodeAt(pos);
        if (nodeFirst == null) {
            return false;
        }
        Node<NodeDataType> nodeSecond = this.getNodeAt(pos.method_10093(side));
        if (nodeSecond == null) {
            return false;
        }
        return this.canNodesConnect(nodeFirst, side, nodeSecond, this);
    }

    protected void addNodeSilently(class_2338 nodePos, Node<NodeDataType> node) {
        this.nodeByBlockPos.put(nodePos, node);
        this.checkAddedInChunk(nodePos);
    }

    protected void addNode(class_2338 nodePos, Node<NodeDataType> node) {
        this.addNodeSilently(nodePos, node);
        this.onNodeConnectionsUpdate();
        this.worldData.method_80();
    }

    protected Node<NodeDataType> removeNodeWithoutRebuilding(class_2338 nodePos) {
        Node<NodeDataType> removedNode = this.nodeByBlockPos.remove(nodePos);
        this.ensureRemovedFromChunk(nodePos);
        this.worldData.method_80();
        return removedNode;
    }

    public void removeNode(class_2338 nodePos) {
        if (this.nodeByBlockPos.containsKey(nodePos)) {
            Node<NodeDataType> selfNode = this.removeNodeWithoutRebuilding(nodePos);
            this.rebuildNetworkOnNodeRemoval(nodePos, selfNode);
        }
    }

    protected void checkAddedInChunk(class_2338 nodePos) {
        class_1923 chunkPos = new class_1923(nodePos);
        int newValue = this.ownedChunks.compute(chunkPos, (pos, old) -> (old == null ? 0 : old) + 1);
        if (newValue == 1 && this.isValid()) {
            this.worldData.addPipeNetToChunk(chunkPos, this);
        }
    }

    protected void ensureRemovedFromChunk(class_2338 nodePos) {
        class_1923 chunkPos = new class_1923(nodePos);
        int newValue = this.ownedChunks.compute(chunkPos, (pos, old) -> old == null ? 0 : old - 1);
        if (newValue == 0) {
            this.ownedChunks.remove(chunkPos);
            if (this.isValid()) {
                this.worldData.removePipeNetFromChunk(chunkPos, this);
            }
        }
    }

    public void updateBlockedConnections(class_2338 nodePos, class_2350 facing, boolean isBlocked) {
        Node<NodeDataType> neighbourNode;
        if (!this.containsNode(nodePos)) {
            return;
        }
        Node<NodeDataType> selfNode = this.getNodeAt(nodePos);
        if (selfNode.isBlocked(facing) == isBlocked) {
            return;
        }
        this.setBlocked(selfNode, facing, isBlocked);
        class_2338 offsetPos = nodePos.method_10093(facing);
        PipeNet<NodeDataType> pipeNetAtOffset = this.worldData.getNetFromPos(offsetPos);
        if (pipeNetAtOffset == null) {
            this.onNodeConnectionsUpdate();
            this.onPipeConnectionsUpdate();
            this.worldData.method_80();
            return;
        }
        if (pipeNetAtOffset == this) {
            if (isBlocked) {
                this.setBlocked(selfNode, facing, false);
                if (this.canNodesConnect(selfNode, facing, this.getNodeAt(offsetPos), this)) {
                    this.setBlocked(selfNode, facing, true);
                    HashMap<class_2338, Node<NodeDataType>> thisENet = this.findAllConnectedBlocks(nodePos);
                    if (!this.getAllNodes().equals(thisENet)) {
                        PipeNet<NodeDataType> newPipeNet = this.worldData.createNetInstance();
                        thisENet.keySet().forEach(this::removeNodeWithoutRebuilding);
                        newPipeNet.transferNodeData(thisENet, this);
                        this.worldData.addPipeNet(newPipeNet);
                    }
                }
            }
        } else if (!isBlocked && this.canNodesConnect(selfNode, facing, neighbourNode = pipeNetAtOffset.getNodeAt(offsetPos), pipeNetAtOffset) && pipeNetAtOffset.canNodesConnect(neighbourNode, facing.method_10153(), selfNode, this)) {
            this.uniteNetworks(pipeNetAtOffset);
        }
        this.onNodeConnectionsUpdate();
        this.onPipeConnectionsUpdate();
        this.worldData.method_80();
    }

    public void updateNodeData(class_2338 nodePos, NodeDataType data) {
        if (this.containsNode(nodePos)) {
            Node<NodeDataType> selfNode = this.getNodeAt(nodePos);
            selfNode.data = data;
            this.onNodeDataUpdate();
            this.worldData.method_80();
        }
    }

    public void updateMark(class_2338 nodePos, int newMark) {
        if (!this.containsNode(nodePos)) {
            return;
        }
        HashMap<class_2338, Node<NodeDataType>> selfConnectedBlocks = null;
        Node<NodeDataType> selfNode = this.getNodeAt(nodePos);
        int oldMark = selfNode.mark;
        selfNode.mark = newMark;
        for (class_2350 facing : class_2350.values()) {
            HashMap<class_2338, Node<NodeDataType>> offsetConnectedBlocks;
            Node<NodeDataType> secondNode;
            class_2338 offsetPos = nodePos.method_10093(facing);
            PipeNet<NodeDataType> otherPipeNet = this.worldData.getNetFromPos(offsetPos);
            Node<NodeDataType> node = secondNode = otherPipeNet == null ? null : otherPipeNet.getNodeAt(offsetPos);
            if (secondNode == null || !this.areNodeBlockedConnectionsCompatible(selfNode, facing, secondNode) || !this.areNodesCustomContactable(selfNode.data, secondNode.data, otherPipeNet) || this.areMarksCompatible(oldMark, secondNode.mark) == this.areMarksCompatible(newMark, secondNode.mark)) continue;
            if (this.areMarksCompatible(newMark, secondNode.mark)) {
                if (otherPipeNet == this) continue;
                this.uniteNetworks(otherPipeNet);
                continue;
            }
            if (otherPipeNet != this) continue;
            if (selfConnectedBlocks == null) {
                selfConnectedBlocks = this.findAllConnectedBlocks(nodePos);
            }
            if (this.getAllNodes().equals(selfConnectedBlocks) || (offsetConnectedBlocks = this.findAllConnectedBlocks(offsetPos)).equals(selfConnectedBlocks)) continue;
            offsetConnectedBlocks.keySet().forEach(this::removeNodeWithoutRebuilding);
            PipeNet<NodeDataType> offsetPipeNet = this.worldData.createNetInstance();
            offsetPipeNet.transferNodeData(offsetConnectedBlocks, this);
            this.worldData.addPipeNet(offsetPipeNet);
        }
        this.onNodeConnectionsUpdate();
        this.worldData.method_80();
    }

    private void setBlocked(Node<NodeDataType> selfNode, class_2350 facing, boolean isBlocked) {
        selfNode.openConnections = !isBlocked ? (selfNode.openConnections |= 1 << facing.ordinal()) : (selfNode.openConnections &= ~(1 << facing.ordinal()));
    }

    public boolean markNodeAsActive(class_2338 nodePos, boolean isActive) {
        if (this.containsNode(nodePos) && this.getNodeAt((class_2338)nodePos).isActive != isActive) {
            this.getNodeAt((class_2338)nodePos).isActive = isActive;
            this.worldData.method_80();
            this.onNodeConnectionsUpdate();
            return true;
        }
        return false;
    }

    protected final void uniteNetworks(PipeNet<NodeDataType> unitedPipeNet) {
        HashMap<class_2338, Node<NodeDataType>> allNodes = new HashMap<class_2338, Node<NodeDataType>>(unitedPipeNet.getAllNodes());
        this.worldData.removePipeNet(unitedPipeNet);
        allNodes.keySet().forEach(unitedPipeNet::removeNodeWithoutRebuilding);
        this.transferNodeData(allNodes, unitedPipeNet);
    }

    private boolean areNodeBlockedConnectionsCompatible(Node<NodeDataType> first, class_2350 firstFacing, Node<NodeDataType> second) {
        return !first.isBlocked(firstFacing) && !second.isBlocked(firstFacing.method_10153());
    }

    private boolean areMarksCompatible(int mark1, int mark2) {
        return mark1 == mark2 || mark1 == 0 || mark2 == 0;
    }

    protected final boolean canNodesConnect(Node<NodeDataType> first, class_2350 firstFacing, Node<NodeDataType> second, PipeNet<NodeDataType> secondPipeNet) {
        return this.areNodeBlockedConnectionsCompatible(first, firstFacing, second) && this.areMarksCompatible(first.mark, second.mark) && this.areNodesCustomContactable(first.data, second.data, secondPipeNet);
    }

    protected HashMap<class_2338, Node<NodeDataType>> findAllConnectedBlocks(class_2338 startPos) {
        HashMap<class_2338, Node<NodeDataType>> observedSet = new HashMap<class_2338, Node<NodeDataType>>();
        observedSet.put(startPos, this.getNodeAt(startPos));
        Node<NodeDataType> firstNode = this.getNodeAt(startPos);
        class_2338.class_2339 currentPos = startPos.method_25503();
        Stack<class_2350> moveStack = new Stack<class_2350>();
        while (true) {
            for (class_2350 facing : class_2350.values()) {
                currentPos.method_10098(facing);
                Node<NodeDataType> secondNode = this.getNodeAt((class_2338)currentPos);
                if (secondNode != null && this.canNodesConnect(firstNode, facing, secondNode, this) && !observedSet.containsKey(currentPos)) {
                    observedSet.put(currentPos.method_10062(), this.getNodeAt((class_2338)currentPos));
                    firstNode = secondNode;
                    moveStack.push(facing.method_10153());
                    continue;
                }
                currentPos.method_10098(facing.method_10153());
            }
            if (moveStack.isEmpty()) break;
            currentPos.method_10098((class_2350)moveStack.pop());
            firstNode = this.getNodeAt((class_2338)currentPos);
        }
        return observedSet;
    }

    protected void rebuildNetworkOnNodeRemoval(class_2338 nodePos, Node<NodeDataType> selfNode) {
        class_2338 offsetPos;
        int amountOfConnectedSides = 0;
        for (class_2350 facing : class_2350.values()) {
            offsetPos = nodePos.method_10093(facing);
            if (!this.containsNode(offsetPos)) continue;
            ++amountOfConnectedSides;
        }
        if (amountOfConnectedSides >= 2) {
            for (class_2350 facing : class_2350.values()) {
                offsetPos = nodePos.method_10093(facing);
                Node<NodeDataType> secondNode = this.getNodeAt(offsetPos);
                if (secondNode == null || !this.canNodesConnect(selfNode, facing, secondNode, this)) continue;
                HashMap<class_2338, Node<NodeDataType>> thisENet = this.findAllConnectedBlocks(offsetPos);
                if (this.getAllNodes().equals(thisENet)) break;
                PipeNet<NodeDataType> energyNet = this.worldData.createNetInstance();
                thisENet.keySet().forEach(this::removeNodeWithoutRebuilding);
                energyNet.transferNodeData(thisENet, this);
                this.worldData.addPipeNet(energyNet);
            }
        }
        if (this.getAllNodes().isEmpty()) {
            this.worldData.removePipeNet(this);
        }
        this.onNodeConnectionsUpdate();
        this.worldData.method_80();
    }

    protected boolean areNodesCustomContactable(NodeDataType first, NodeDataType second, PipeNet<NodeDataType> secondNodePipeNet) {
        return true;
    }

    protected boolean canAttachNode(NodeDataType nodeData) {
        return true;
    }

    protected void transferNodeData(Map<class_2338, Node<NodeDataType>> transferredNodes, PipeNet<NodeDataType> parentNet) {
        transferredNodes.forEach(this::addNodeSilently);
        this.onNodeConnectionsUpdate();
        this.worldData.method_80();
    }

    protected abstract void writeNodeData(NodeDataType var1, class_2487 var2);

    protected abstract NodeDataType readNodeData(class_2487 var1);

    @Override
    public class_2487 serializeNBT() {
        class_2487 compound = new class_2487();
        compound.method_10566("Nodes", (class_2520)this.serializeAllNodeList(this.nodeByBlockPos));
        return compound;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        this.nodeByBlockPos.clear();
        this.ownedChunks.clear();
        this.deserializeAllNodeList(nbt.method_10562("Nodes"));
    }

    protected void deserializeAllNodeList(class_2487 compound) {
        int i;
        class_2499 allNodesList = compound.method_10554("NodeIndexes", 10);
        class_2499 wirePropertiesList = compound.method_10554("WireProperties", 10);
        Int2ObjectOpenHashMap readProperties = new Int2ObjectOpenHashMap();
        for (i = 0; i < wirePropertiesList.size(); ++i) {
            class_2487 propertiesTag = wirePropertiesList.method_10602(i);
            int wirePropertiesIndex = propertiesTag.method_10550("index");
            NodeDataType nodeData = this.readNodeData(propertiesTag);
            readProperties.put(wirePropertiesIndex, nodeData);
        }
        for (i = 0; i < allNodesList.size(); ++i) {
            class_2487 nodeTag = allNodesList.method_10602(i);
            int x = nodeTag.method_10550("x");
            int y = nodeTag.method_10550("y");
            int z = nodeTag.method_10550("z");
            int wirePropertiesIndex = nodeTag.method_10550("index");
            class_2338 blockPos = new class_2338(x, y, z);
            Object nodeData = readProperties.get(wirePropertiesIndex);
            int openConnections = nodeTag.method_10550("open");
            int mark = nodeTag.method_10550("mark");
            boolean isNodeActive = nodeTag.method_10577("active");
            this.addNodeSilently(blockPos, new Node<Object>(nodeData, openConnections, mark, isNodeActive));
        }
    }

    protected class_2487 serializeAllNodeList(Map<class_2338, Node<NodeDataType>> allNodes) {
        class_2487 compound = new class_2487();
        class_2499 allNodesList = new class_2499();
        class_2499 wirePropertiesList = new class_2499();
        Object2IntOpenHashMap alreadyWritten = new Object2IntOpenHashMap();
        int currentIndex = 0;
        for (Map.Entry<class_2338, Node<NodeDataType>> entry : allNodes.entrySet()) {
            class_2338 nodePos = entry.getKey();
            Node<NodeDataType> node = entry.getValue();
            class_2487 nodeTag = new class_2487();
            nodeTag.method_10569("x", nodePos.method_10263());
            nodeTag.method_10569("y", nodePos.method_10264());
            nodeTag.method_10569("z", nodePos.method_10260());
            int wirePropertiesIndex = alreadyWritten.getOrDefault(node.data, -1);
            if (wirePropertiesIndex == -1) {
                wirePropertiesIndex = currentIndex++;
                alreadyWritten.put(node.data, wirePropertiesIndex);
            }
            nodeTag.method_10569("index", wirePropertiesIndex);
            if (node.mark != 0) {
                nodeTag.method_10569("mark", node.mark);
            }
            if (node.openConnections > 0) {
                nodeTag.method_10569("open", node.openConnections);
            }
            if (node.isActive) {
                nodeTag.method_10556("active", true);
            }
            allNodesList.add((Object)nodeTag);
        }
        for (Object nodeData : alreadyWritten.keySet()) {
            int wirePropertiesIndex = alreadyWritten.getInt(nodeData);
            class_2487 propertiesTag = new class_2487();
            propertiesTag.method_10569("index", wirePropertiesIndex);
            this.writeNodeData(nodeData, propertiesTag);
            wirePropertiesList.add((Object)propertiesTag);
        }
        compound.method_10566("NodeIndexes", (class_2520)allNodesList);
        compound.method_10566("WireProperties", (class_2520)wirePropertiesList);
        return compound;
    }
}

