/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.pipelike;

import com.lowdragmc.lowdraglib.pipelike.Node;
import com.lowdragmc.lowdraglib.pipelike.PipeNet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;

public abstract class LevelPipeNet<NodeDataType, T extends PipeNet<NodeDataType>>
extends class_18 {
    private final class_3218 serverLevel;
    protected List<T> pipeNets = new ArrayList<T>();
    protected final Map<class_1923, List<T>> pipeNetsByChunk = new HashMap<class_1923, List<T>>();

    public LevelPipeNet(class_3218 serverLevel) {
        this.serverLevel = serverLevel;
    }

    public LevelPipeNet(class_3218 serverLevel, class_2487 tag) {
        this(serverLevel);
        this.pipeNets = new ArrayList<T>();
        class_2499 allEnergyNets = tag.method_10554("PipeNets", 10);
        for (int i = 0; i < allEnergyNets.size(); ++i) {
            class_2487 pNetTag = allEnergyNets.method_10602(i);
            T pipeNet = this.createNetInstance();
            ((PipeNet)pipeNet).deserializeNBT(pNetTag);
            this.addPipeNetSilently(pipeNet);
        }
        this.init();
    }

    public class_3218 getWorld() {
        return this.serverLevel;
    }

    protected void init() {
        this.pipeNets.forEach(PipeNet::onNodeConnectionsUpdate);
    }

    public void addNode(class_2338 nodePos, NodeDataType nodeData, int mark, int openConnections, boolean isActive) {
        PipeNet<Object> myPipeNet = null;
        Node<NodeDataType> node = new Node<NodeDataType>(nodeData, openConnections, mark, isActive);
        for (class_2350 facing : class_2350.values()) {
            Node secondNode;
            class_2338 offsetPos = nodePos.method_10093(facing);
            T pipeNet = this.getNetFromPos(offsetPos);
            Node node2 = secondNode = pipeNet == null ? null : ((PipeNet)pipeNet).getAllNodes().get(offsetPos);
            if (pipeNet == null || !((PipeNet)pipeNet).canAttachNode(nodeData) || !((PipeNet)pipeNet).canNodesConnect(secondNode, facing.method_10153(), node, null)) continue;
            if (myPipeNet == null) {
                myPipeNet = pipeNet;
                myPipeNet.addNode(nodePos, node);
                continue;
            }
            if (myPipeNet == pipeNet) continue;
            myPipeNet.uniteNetworks((PipeNet<Object>)pipeNet);
        }
        if (myPipeNet == null) {
            myPipeNet = (PipeNet<Object>)this.createNetInstance();
            myPipeNet.addNode(nodePos, node);
            this.addPipeNet(myPipeNet);
            this.method_80();
        }
    }

    protected void addPipeNetToChunk(class_1923 chunkPos, T pipeNet) {
        this.pipeNetsByChunk.computeIfAbsent(chunkPos, any -> new ArrayList()).add(pipeNet);
    }

    protected void removePipeNetFromChunk(class_1923 chunkPos, T pipeNet) {
        List<T> list = this.pipeNetsByChunk.get(chunkPos);
        if (list != null) {
            list.remove(pipeNet);
        }
        if (list.isEmpty()) {
            this.pipeNetsByChunk.remove(chunkPos);
        }
    }

    public void removeNode(class_2338 nodePos) {
        T pipeNet = this.getNetFromPos(nodePos);
        if (pipeNet != null) {
            ((PipeNet)pipeNet).removeNode(nodePos);
        }
    }

    public void updateBlockedConnections(class_2338 nodePos, class_2350 side, boolean isBlocked) {
        T pipeNet = this.getNetFromPos(nodePos);
        if (pipeNet != null) {
            ((PipeNet)pipeNet).updateBlockedConnections(nodePos, side, isBlocked);
        }
    }

    public void updateData(class_2338 nodePos, NodeDataType data) {
        T pipeNet = this.getNetFromPos(nodePos);
        if (pipeNet != null) {
            ((PipeNet)pipeNet).updateNodeData(nodePos, data);
        }
    }

    public void updateMark(class_2338 nodePos, int newMark) {
        T pipeNet = this.getNetFromPos(nodePos);
        if (pipeNet != null) {
            ((PipeNet)pipeNet).updateMark(nodePos, newMark);
        }
    }

    public T getNetFromPos(class_2338 blockPos) {
        List pipeNetsInChunk = this.pipeNetsByChunk.getOrDefault(new class_1923(blockPos), Collections.emptyList());
        for (PipeNet pipeNet : pipeNetsInChunk) {
            if (!pipeNet.containsNode(blockPos)) continue;
            return (T)pipeNet;
        }
        return null;
    }

    protected void addPipeNet(T pipeNet) {
        this.addPipeNetSilently(pipeNet);
    }

    protected void addPipeNetSilently(T pipeNet) {
        this.pipeNets.add(pipeNet);
        ((PipeNet)pipeNet).getContainedChunks().forEach(chunkPos -> this.addPipeNetToChunk((class_1923)chunkPos, pipeNet));
        ((PipeNet)pipeNet).isValid = true;
    }

    protected void removePipeNet(T pipeNet) {
        this.pipeNets.remove(pipeNet);
        ((PipeNet)pipeNet).getContainedChunks().forEach(chunkPos -> this.removePipeNetFromChunk((class_1923)chunkPos, pipeNet));
        ((PipeNet)pipeNet).isValid = false;
        this.method_80();
    }

    protected abstract T createNetInstance();

    public class_2487 method_75(class_2487 compound) {
        class_2499 allPipeNets = new class_2499();
        for (PipeNet pipeNet : this.pipeNets) {
            class_2487 pNetTag = pipeNet.serializeNBT();
            allPipeNets.add((Object)pNetTag);
        }
        compound.method_10566("PipeNets", (class_2520)allPipeNets);
        return compound;
    }
}

