/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.networking.s2c;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.networking.IHandlerContext;
import com.lowdragmc.lowdraglib.networking.IPacket;
import com.lowdragmc.lowdraglib.networking.both.PacketIntLocation;
import com.lowdragmc.lowdraglib.syncdata.IManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.TypedPayloadRegistries;
import com.lowdragmc.lowdraglib.syncdata.accessor.IManagedAccessor;
import com.lowdragmc.lowdraglib.syncdata.blockentity.IAutoSyncBlockEntity;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedKey;
import com.lowdragmc.lowdraglib.syncdata.managed.IRef;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class SPacketManagedPayload
extends PacketIntLocation
implements IPacket {
    private class_2487 extra;
    private class_2591<?> blockEntityType;
    private BitSet changed;
    private ITypedPayload<?>[] payloads;

    public SPacketManagedPayload(class_2591<?> type, class_2338 pos, BitSet changed, ITypedPayload<?>[] payloads, class_2487 extra) {
        super(pos);
        this.blockEntityType = type;
        this.changed = changed;
        this.payloads = payloads;
        this.extra = extra;
    }

    public SPacketManagedPayload(class_2487 tag) {
        super(class_2338.method_10092((long)tag.method_10537("p")));
        this.blockEntityType = (class_2591)class_7923.field_41181.method_10223(new class_2960(tag.method_10558("t")));
        this.changed = BitSet.valueOf(tag.method_10547("c"));
        class_2499 list = tag.method_10554("l", 10);
        this.payloads = new ITypedPayload[list.size()];
        for (int i = 0; i < this.payloads.length; ++i) {
            class_2487 payloadTag = list.method_10602(i);
            byte id = payloadTag.method_10571("t");
            ITypedPayload<?> payload = TypedPayloadRegistries.create(id);
            payload.deserializeNBT(payloadTag.method_10580("d"));
            this.payloads[i] = payload;
        }
        this.extra = tag.method_10562("e");
    }

    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        tag.method_10544("p", this.pos.method_10063());
        tag.method_10582("t", Objects.requireNonNull(class_7923.field_41181.method_10221(this.blockEntityType)).toString());
        tag.method_10570("c", this.changed.toByteArray());
        class_2499 list = new class_2499();
        for (ITypedPayload<?> payload : this.payloads) {
            class_2487 payloadTag = new class_2487();
            payloadTag.method_10567("t", payload.getType());
            class_2520 data = payload.serializeNBT();
            if (data != null) {
                payloadTag.method_10566("d", data);
            }
            list.add((Object)payloadTag);
        }
        tag.method_10566("l", (class_2520)list);
        tag.method_10566("e", (class_2520)this.extra);
        return tag;
    }

    public static SPacketManagedPayload of(IAutoSyncBlockEntity tile, boolean force) {
        BitSet changed = new BitSet();
        LinkedHashMap payloads = new LinkedHashMap();
        IRef[] syncedFields = tile.getRootStorage().getSyncFields();
        for (int i = 0; i < syncedFields.length; ++i) {
            IRef field = syncedFields[i];
            if (!force && !field.isSyncDirty()) continue;
            changed.set(i);
            ManagedKey key = field.getKey();
            payloads.put(key, key.readSyncedField(field, force));
            field.clearSyncDirty();
        }
        class_2487 extra = new class_2487();
        tile.writeCustomSyncData(extra);
        return new SPacketManagedPayload(tile.getBlockEntityType(), tile.getCurrentPos(), changed, payloads.values().toArray(new ITypedPayload[0]), extra);
    }

    public void processPacket(@NotNull IAutoSyncBlockEntity blockEntity) {
        if (blockEntity.getSelf().method_11017() != this.blockEntityType) {
            LDLib.LOGGER.warn("Block entity type mismatch in managed payload packet!");
            return;
        }
        IManagedStorage storage = blockEntity.getRootStorage();
        IRef[] syncedFields = storage.getSyncFields();
        IManagedAccessor.writeSyncedFields(storage, syncedFields, this.changed, this.payloads);
        blockEntity.readCustomSyncData(this.extra);
    }

    @Override
    public void encode(class_2540 buf) {
        super.encode(buf);
        buf.method_10812(Objects.requireNonNull(class_7923.field_41181.method_10221(this.blockEntityType)));
        buf.method_10813(this.changed.toByteArray());
        for (ITypedPayload<?> payload : this.payloads) {
            buf.writeByte((int)payload.getType());
            payload.writePayload(buf);
        }
        buf.method_10794(this.extra);
    }

    @Override
    public void decode(class_2540 buffer) {
        super.decode(buffer);
        this.blockEntityType = (class_2591)class_7923.field_41181.method_10223(buffer.method_10810());
        this.changed = BitSet.valueOf(buffer.method_10795());
        this.payloads = new ITypedPayload[this.changed.cardinality()];
        for (int i = 0; i < this.payloads.length; ++i) {
            byte id = buffer.readByte();
            ITypedPayload<?> payload = TypedPayloadRegistries.create(id);
            payload.readPayload(buffer);
            this.payloads[i] = payload;
        }
        this.extra = buffer.method_10798();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void execute(IHandlerContext handler) {
        class_2586 class_25862;
        class_638 level;
        if (handler.isClient() && (level = class_310.method_1551().field_1687) != null && (class_25862 = level.method_8321(this.pos)) instanceof IAutoSyncBlockEntity) {
            IAutoSyncBlockEntity autoSyncBlockEntity = (IAutoSyncBlockEntity)class_25862;
            this.processPacket(autoSyncBlockEntity);
        }
    }

    public SPacketManagedPayload() {
    }
}

