/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.networking.fabric;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.fabric.PlatformImpl;
import com.lowdragmc.lowdraglib.networking.IHandlerContext;
import com.lowdragmc.lowdraglib.networking.INetworking;
import com.lowdragmc.lowdraglib.networking.IPacket;
import io.netty.buffer.Unpooled;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2802;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class Networking
implements INetworking {
    protected final class_2960 networkingName;
    protected final String version;
    protected final BiMap<Class<? extends IPacket>, Integer> packetRegistry = HashBiMap.create();
    protected int AUTO_ID = 0;

    public Networking(class_2960 location, String version) {
        this.networkingName = location;
        this.version = version;
    }

    public int getPacketId(Class<? extends IPacket> clazz) {
        return (Integer)this.packetRegistry.get(clazz);
    }

    public class_2960 getChannel(Class<? extends IPacket> clazz) {
        return new class_2960(this.networkingName.method_12836(), this.networkingName.method_12832() + "-" + this.getPacketId(clazz));
    }

    public <MSG extends IPacket> void register(Class<MSG> clazz, boolean isC2S) {
        this.packetRegistry.put(clazz, (Object)this.AUTO_ID++);
        if (isC2S) {
            ServerPlayNetworking.registerGlobalReceiver((class_2960)this.getChannel(clazz), (server, player, handler, buf, responseSender) -> {
                try {
                    IPacket packet = (IPacket)clazz.newInstance();
                    packet.decode(buf);
                    server.execute(() -> packet.execute(new IHandlerContext(){

                        @Override
                        public Object getContext() {
                            return handler;
                        }

                        @Override
                        public boolean isClient() {
                            return false;
                        }

                        @Override
                        @Nullable
                        public class_3222 getPlayer() {
                            return player;
                        }

                        @Override
                        public MinecraftServer getServer() {
                            return server;
                        }

                        @Override
                        public class_1937 getLevel() {
                            return player.method_37908();
                        }
                    }));
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            });
        } else if (LDLib.isClient()) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)this.getChannel(clazz), (client, handler, buf, responseSender) -> {
                try {
                    IPacket packet = (IPacket)clazz.newInstance();
                    packet.decode(buf);
                    client.execute(() -> packet.execute(new IHandlerContext(){

                        @Override
                        public Object getContext() {
                            return handler;
                        }

                        @Override
                        public boolean isClient() {
                            return true;
                        }

                        @Override
                        @Nullable
                        public class_3222 getPlayer() {
                            return null;
                        }

                        @Override
                        @Nullable
                        public MinecraftServer getServer() {
                            return null;
                        }

                        @Override
                        public class_1937 getLevel() {
                            return handler.method_2890();
                        }
                    }));
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    @Override
    public <MSG extends IPacket> void registerC2S(Class<MSG> clazz) {
        this.register(clazz, true);
    }

    @Override
    public <MSG extends IPacket> void registerS2C(Class<MSG> clazz) {
        this.register(clazz, false);
    }

    @Override
    public <MSG extends IPacket> void registerBoth(Class<MSG> clazz) {
        this.registerS2C(clazz);
        this.registerC2S(clazz);
    }

    @Override
    public void sendToServer(IPacket msg) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        msg.encode(buffer);
        ClientPlayNetworking.send((class_2960)this.getChannel(msg.getClass()), (class_2540)buffer);
    }

    @Override
    public void sendToPlayer(IPacket msg, class_3222 player) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        msg.encode(buffer);
        ServerPlayNetworking.send((class_3222)player, (class_2960)this.getChannel(msg.getClass()), (class_2540)buffer);
    }

    @Override
    public void sendToTrackingChunk(IPacket msg, class_2818 levelChunk) {
        class_2802 class_28022 = levelChunk.method_12200().method_8398();
        if (class_28022 instanceof class_3215) {
            class_3215 chunkCache = (class_3215)class_28022;
            chunkCache.field_17254.method_17210(levelChunk.method_12004(), false).forEach(player -> this.sendToPlayer(msg, (class_3222)player));
        }
    }

    @Override
    public void sendToAll(IPacket msg) {
        for (class_3222 serverPlayer : PlatformImpl.getMinecraftServer().method_3760().method_14571()) {
            this.sendToPlayer(msg, serverPlayer);
        }
    }

    @Override
    public class_2960 getNetworkingName() {
        return this.networkingName;
    }

    @Override
    public String getVersion() {
        return this.version;
    }
}

