/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.networking.both;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.networking.IHandlerContext;
import com.lowdragmc.lowdraglib.networking.IPacket;
import com.lowdragmc.lowdraglib.networking.both.PacketIntLocation;
import com.lowdragmc.lowdraglib.syncdata.IManaged;
import com.lowdragmc.lowdraglib.syncdata.TypedPayloadRegistries;
import com.lowdragmc.lowdraglib.syncdata.blockentity.IRPCBlockEntity;
import com.lowdragmc.lowdraglib.syncdata.field.RPCMethodMeta;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.lowdragmc.lowdraglib.syncdata.rpc.RPCSender;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class PacketRPCMethodPayload
extends PacketIntLocation
implements IPacket {
    private class_2591<?> blockEntityType;
    private ITypedPayload<?>[] payloads;
    private String methodName;
    private int managedId;

    public PacketRPCMethodPayload(class_2540 buffer) {
        this.decode(buffer);
    }

    public PacketRPCMethodPayload(int managedId, class_2591<?> type, class_2338 pos, String methodName, ITypedPayload<?>[] payloads) {
        super(pos);
        this.managedId = managedId;
        this.blockEntityType = type;
        this.methodName = methodName;
        this.payloads = payloads;
    }

    public static PacketRPCMethodPayload of(IManaged managed, IRPCBlockEntity tile, String methodName, Object ... args) {
        int index = Arrays.stream(tile.getRootStorage().getManaged()).toList().indexOf(managed);
        if (index < 0) {
            throw new IllegalArgumentException("No such rpc managed: " + methodName);
        }
        RPCMethodMeta rpcMethod = tile.getRPCMethod(managed, methodName);
        if (rpcMethod == null) {
            throw new IllegalArgumentException("No such RPC method: " + methodName);
        }
        ITypedPayload<?>[] payloads = rpcMethod.serializeArgs(args);
        return new PacketRPCMethodPayload(index, tile.getBlockEntityType(), tile.getCurrentPos(), methodName, payloads);
    }

    public void processPacket(@NotNull class_2586 blockEntity, RPCSender sender) {
        if (blockEntity.method_11017() != this.blockEntityType) {
            LDLib.LOGGER.warn("Block entity type mismatch in rpc payload packet!");
            return;
        }
        if (!(blockEntity instanceof IRPCBlockEntity)) {
            LDLib.LOGGER.error("Received managed payload packet for block entity that does not implement IRPCBlockEntity: " + blockEntity);
            return;
        }
        IRPCBlockEntity tile = (IRPCBlockEntity)blockEntity;
        if (tile.getRootStorage().getManaged().length >= this.managedId) {
            LDLib.LOGGER.error("Received managed couldn't be found in IRPCBlockEntity: " + blockEntity);
            return;
        }
        RPCMethodMeta rpcMethod = tile.getRPCMethod(tile.getRootStorage().getManaged()[this.managedId], this.methodName);
        if (rpcMethod == null) {
            LDLib.LOGGER.error("Cannot find RPC method: " + this.methodName);
            return;
        }
        rpcMethod.invoke(tile, sender, this.payloads);
    }

    @Override
    public void encode(class_2540 buf) {
        super.encode(buf);
        buf.method_10812(Objects.requireNonNull(class_7923.field_41181.method_10221(this.blockEntityType)));
        buf.method_10814(this.methodName);
        buf.method_10804(this.payloads.length);
        for (ITypedPayload<?> payload : this.payloads) {
            buf.writeByte((int)payload.getType());
            payload.writePayload(buf);
        }
    }

    @Override
    public void decode(class_2540 buffer) {
        super.decode(buffer);
        this.blockEntityType = (class_2591)class_7923.field_41181.method_10223(buffer.method_10810());
        this.methodName = buffer.method_19772();
        this.payloads = new ITypedPayload[buffer.method_10816()];
        for (int i = 0; i < this.payloads.length; ++i) {
            byte id = buffer.readByte();
            ITypedPayload<?> payload = TypedPayloadRegistries.create(id);
            payload.readPayload(buffer);
            this.payloads[i] = payload;
        }
    }

    @Override
    public void execute(IHandlerContext handler) {
        if (!handler.isClient()) {
            class_3222 player = handler.getPlayer();
            if (player == null) {
                LDLib.LOGGER.error("Received rpc payload packet from client with no player!");
                return;
            }
            class_1937 level = player.method_37908();
            if (!level.method_8477(this.pos)) {
                return;
            }
            class_2586 tile = level.method_8321(this.pos);
            if (tile == null) {
                return;
            }
            this.processPacket(tile, RPCSender.ofClient((class_1657)player));
        } else {
            if (handler.getLevel() == null) {
                return;
            }
            class_2586 tile = handler.getLevel().method_8321(this.pos);
            if (tile == null) {
                return;
            }
            this.processPacket(tile, RPCSender.ofServer());
        }
    }

    public PacketRPCMethodPayload() {
    }
}

